﻿* Encoding: UTF-8.

**************************************************************************************************************
*** SINTAXIS PARA EL CÁLCULO DE LOS ESTADÍSTICOS, TABULADOS E INDICADORES
*** DEL MÓDULO DE INFORMACIÓN AMBIENTAL EN AGRICULTURA DE LA ENCUESTA
*** DE SUPERFICIE Y PRODUCCIÓN AGROPECUARIA CONTINUA - ESPAC 2020.
*** REALIZADA POR: RAMIRO BENAVIDES - DEAGA.
*** 02 DE MAYO DE 2016
*** ACTUALIZACIÓN: CARLOS PILATAXI - DEAGA - 2021***  
**************************************************************************************************************

* (0.1) CREACIÓN DE IDENTIFICADOR ÚNICO DE ENCUESTA.
* ABRIR LA BASE DE DATOS DEL MÓDULO AMBIENTAL (ambnac2020.sav).

SORT CASES BY ual_prov ual_cant ual_parr ual_estr ual_segm al_ncues.

STRING identif (A17).
COMPUTE identif = CONCAT(LTRIM(RTRIM(ual_prov)), LTRIM(RTRIM(ual_cant)), LTRIM(RTRIM(ual_parr)), LTRIM(RTRIM(ual_estr)),
LTRIM(RTRIM(ual_segm)), LTRIM(RTRIM(al_ncues))).

SORT CASES BY identif.
COMPUTE id_unico = (LAG(identif) <> identif).
FREQUENCIES id_unico.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* SECCIÓN II. EXTENSIÓN AGRARIA.
* ABRIR BASE DEL MÓDULO AMBIENTAL (ambnac2020.sav) ***.

.
***** TABLA 27. PERSONAS PRODUCTORAS QUE UTILIZAN ELEMENTOS DE PROTECCIÓN AL APLICAR PLAGUICIDAS, POR TIPO DE ELEMENTO DE PROTECCIÓN.

CTABLES
  /VLABELS VARIABLES=plag_utilguan plag_utilmasca plag_utilgafas plag_utilcamisas plag_utilbotas plag_utilvesti DISPLAY=LABEL
  /TABLE BY plag_utilguan [COUNT F40.0, ROWPCT.COUNT PCT40.1] + plag_utilmasca [COUNT F40.0, ROWPCT.COUNT PCT40.1]
    + plag_utilgafas [COUNT F40.0, ROWPCT.COUNT PCT40.1] + plag_utilcamisas [COUNT F40.0, ROWPCT.COUNT PCT40.1] + 
    plag_utilbotas [COUNT F40.0, ROWPCT.COUNT PCT40.1] + plag_utilvesti [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=plag_utilguan plag_utilmasca plag_utilgafas plag_utilcamisas plag_utilbotas 
    plag_utilvesti [1, 2] EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='PERSONAS PRODUCTORAS QUE UTILIZAN ELEMENTOS DE PROTECCIÓN AL APLICAR PLAGUICIDAS, POR TIPO DE ELEMENTO DE PROTECCIÓN'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


***** TABLA 28. PERSONAS PRODUCTORAS QUE UTILIZAN FACILIDADES LOGÍSTICAS Y/O TECNOLÓGICAS, POR TIPO DE FACILIDAD.

CTABLES
  /VLABELS VARIABLES=pa_arealm pa_areempa pa_cfrio pa_cercaelect DISPLAY=LABEL
  /TABLE BY pa_arealm [COUNT F40.0, ROWPCT.COUNT PCT40.1] + pa_areempa [COUNT F40.0, ROWPCT.COUNT PCT40.1] + 
                    pa_cfrio [COUNT F40.0, ROWPCT.COUNT PCT40.1] + pa_cercaelect [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=pa_arealm pa_areempa pa_cfrio pa_cercaelect ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='PERSONAS PRODUCTORAS QUE UTILIZAN FACILIDADES LOGÍSTICAS Y/O TECNOLÓGICAS, POR TIPO DE FACILIDAD'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


***** TABLA 29. PERSONAS PRODUCTORAS QUE REALIZAN ACTIVIDADES DE POST COSECHA, POR TIPO DE ACTIVIDAD.

CTABLES
  /VLABELS VARIABLES=pa_pcselec pa_pclavado pa_pcempaque DISPLAY=LABEL
  /TABLE BY pa_pcselec [COUNT F40.0, ROWPCT.COUNT PCT40.1] + pa_pclavado [COUNT F40.0, ROWPCT.COUNT PCT40.1] + 
                    pa_pcempaque [COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=pa_pcselec pa_pclavado pa_pcempaque ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='PERSONAS PRODUCTORAS QUE REALIZAN ACTIVIDADES DE POST COSECHA, POR TIPO DE ACTIVIDAD'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


**************************************************************************************************************************************************************************************
*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* SECCIÓN IV. EQUIPAMIENTO.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

*****CREAR IDENTIFICADOR************************************************************************************************************************************************************.

DATASET NAME ctnac2020.
SORT CASES BY ual_prov ual_cant ual_parr ual_estr ual_segm al_ncues.

STRING identif (A17).
COMPUTE identif = CONCAT(LTRIM(RTRIM(ual_prov)), LTRIM(RTRIM(ual_cant)), LTRIM(RTRIM(ual_parr)), LTRIM(RTRIM(ual_estr)),
LTRIM(RTRIM(ual_segm)), LTRIM(RTRIM(al_ncues))).

SORT CASES BY identif.
COMPUTE id_unico = (LAG(identif) <> identif).
FREQUENCIES id_unico.


--------- MATCH DE BDD-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.


MATCH FILES /FILE=*
  /FILE='Conjunto_de_datos5'
  /RENAME (su_fertilizada su_plaguicidas ct_porc_aspe ct_secertificada ct_nclavr ct_secomun 
    ct_nuevacondicion ct_aferti ct_afito ct_cant1_fo ct_cant2_fo ct_cant3_fo ct_cantidad_fq 
    ct_cantidad_fun_pq ct_cantidad_her_pq ct_cantidad_ins_pq ct_cantidad_nit_fq ct_cantidad_npk_fq 
    ct_cantidad_po ct_cantidad_pot_fq ct_cantidad_pq ct_codcultiv1_int ct_codcultiv2_int 
    ct_color_fun_pq ct_color_her_pq ct_color_ins_pq ct_color_pq ct_compra_po ct_condcult_int 
    ct_consermaq ct_cosinscos ct_cosotrgas ct_estcompra_fo ct_estpreccom_fo ct_estprofin_fo 
    ct_fercompra_fo ct_ferpreccom_fo ct_ferprofin_fo ct_forg ct_fqui ct_insposcos ct_k506r ct_k509r 
    ct_liqcompra_fo ct_liqpreccom_fo ct_liqprofin_fo ct_messiem_int ct_nuevaclavecult ct_observa 
    ct_piensasem_int ct_porg ct_pqui ct_preccom_fos_fq ct_preccom_fun_pq ct_preccom_her_pq 
    ct_preccom_ins_pq ct_preccom_nit_fq ct_preccom_npk_fq ct_preccom_po ct_preccom_pot_fq ct_preccom_pq 
    ct_prod_1 ct_profin_po ct_superdida ct_superf_regada ct_superf_regada_ha ct_supersem_int 
    ct_supersemha_int ct_totpago ct_totrabcon ct_trahomcon ct_tramujcon ct_umed1_fo ct_umed2_fo 
    ct_umed3_fo ct_umed_fq ct_umed_fun_pq ct_umed_her_pq ct_umed_ins_pq ct_umed_nit_fq ct_umed_npk_fq 
    ct_umed_po ct_umed_pot_fq ct_umed_pq ct_vent ct_vent_2 al_ncues Cultiv_T cultiv_tran 
    cultiv_tran_riego ct_enfermedades fact_exp_fin fexp_final Fil_Fosf_Masa Fil_Fosf_Volum 
    Fil_Nitr_Masa Fil_Nitr_Volum Fil_NPK_Masa Fil_NPK_Volum Fil_Pot_Masa Fil_Pot_Volum Fosf_Masa 
    Fosf_Volum ct_porc_gote ct_helada ct_sehibrinter ct_sehibrinac id_unico ct_inundacion ct_semejorada 
    ct_porc_micr NACIONAL ct_porc_nebu Nitr_Masa Nitr_Volum NPK_Masa NPK_Volum ct_otra ct_porc_otro 
    ct_plagas Pot_Masa Pot_Volum ct_prod ual_prov ct_k512r ct_tro ct_trc ct_trs ct_sriego ct_sequia 
    su_limites Suma_Fert_Masa Suma_Fert_Vol Sup_MASA sup_riego_aspe sup_riego_gote sup_riego_micr 
    sup_riego_nebu sup_riego_otro sup_riego_surc Sup_VOL ct_porc_surc superdida ct_tn Transitorios_13 
    ual_cant ual_estr ual_parr ual_segm Ventas = d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 
    d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 
    d41 d42 d43 d44 d45 d46 d47 d48 d49 d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 
    d66 d67 d68 d69 d70 d71 d72 d73 d74 d75 d76 d77 d78 d79 d80 d81 d82 d83 d84 d85 d86 d87 d88 d89 d90 
    d91 d92 d93 d94 d95 d96 d97 d98 d99 d100 d101 d102 d103 d104 d105 d106 d107 d108 d109 d110 d111 
    d112 d113 d114 d115 d116 d117 d118 d119 d120 d121 d122 d123 d124 d125 d126 d127 d128 d129 d130 d131 
    d132 d133 d134 d135 d136 d137 d138 d139 d140 d141 d142 d143 d144 d145 d146 d147 d148 d149) 
  /BY identif
  /DROP= d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 
    d25 d26 d27 d28 d29 d30 d31 d32 d33 d34 d35 d36 d37 d38 d39 d40 d41 d42 d43 d44 d45 d46 d47 d48 d49 
    d50 d51 d52 d53 d54 d55 d56 d57 d58 d59 d60 d61 d62 d63 d64 d65 d66 d67 d68 d69 d70 d71 d72 d73 d74 
    d75 d76 d77 d78 d79 d80 d81 d82 d83 d84 d85 d86 d87 d88 d89 d90 d91 d92 d93 d94 d95 d96 d97 d98 d99 
    d100 d101 d102 d103 d104 d105 d106 d107 d108 d109 d110 d111 d112 d113 d114 d115 d116 d117 d118 d119 
    d120 d121 d122 d123 d124 d125 d126 d127 d128 d129 d130 d131 d132 d133 d134 d135 d136 d137 d138 d139 
    d140 d141 d142 d143 d144 d145 d146 d147 d148 d149.
EXECUTE.

FILTER OFF.
USE ALL.
SELECT IF  (NOT(ORIGINAL=0)).
EXECUTE.

* Guardar base del módulo ambiental.

* Cerrar la base de cultivos transitorios.

DATASET CLOSE transitorios.

******Abrir BDD Ambiental***************************************************************************************************************************************************************************************.


DATASET ACTIVATE ambientales.

WEIGHT OFF.
FILTER OFF.
COMPUTE cultiv_tran_past = (ual_prov >= 1 & ual_prov <= 24). /* Los cultivos transitorios y pastos están en este rango de productos. 
FREQUENCIES cultiv_tran_past.

USE ALL.

RECODE eq_earado (SYSMIS=2) (ELSE=Copy) INTO eq_earado_1.
EXECUTE.

RECODE eq_erastra (SYSMIS=2) (ELSE=Copy) INTO eq_erastra_1.
EXECUTE.

RECODE eq_esurcadora (SYSMIS=2) (ELSE=Copy) INTO eq_esurcadora_1.
EXECUTE.

RECODE eq_efangueo (SYSMIS=2) (ELSE=Copy) INTO eq_efangueo_1.
EXECUTE.

FILTER BY cultiv_tran_past.


****TABLA 29. PRODUCTORES AGROPECUARIOS QUE UTILIZARON EQUIPO PARA PREPARAR EL SUELO PARA CULTIVO, POR TIPO DE EQUIPO USADO Y SEGÚN UTILIZACIÓN Y ANTIGÜEDAD PROMEDIO DEL EQUIPO******.



* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=eq_pstractor eq_etractor eq_psmotocultor eq_emotocultor eq_psyunta eq_eyunta 
    DISPLAY=LABEL
  /TABLE BY eq_pstractor [C][COUNT F40.0] + eq_etractor [C][COUNT F40.0] + eq_psmotocultor 
    [C][COUNT F40.0] + eq_emotocultor [C][COUNT F40.0] + eq_psyunta [C][COUNT F40.0] + eq_eyunta 
    [C][COUNT F40.0]
  /CATEGORIES VARIABLES=eq_pstractor eq_etractor eq_psmotocultor eq_emotocultor eq_psyunta 
    eq_eyunta ORDER=A KEY=VALUE EMPTY=INCLUDE.

** Calcular Ninguno, los números 6 son los equivalentes a Ninguno****.

COMPUTE Ninguno=eq_pstractor + eq_psmotocultor + eq_psyunta.
EXECUTE.

FILTER BY cultiv_tran_past.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=Ninguno DISPLAY=LABEL
  /TABLE Ninguno [C][COUNT F40.0]
  /CATEGORIES VARIABLES=Ninguno ORDER=A KEY=VALUE EMPTY=EXCLUDE.

***** TABLA 30. PRODUCTORES AGROPECUARIOS QUE UTILIZARON EQUIPO PARA PREPARAR EL SUELO PARA CULTIVO, POR TIPO DE EQUIPO USADO Y SEGÚN UTILIZACIÓN Y ANTIGÜEDAD PROMEDIO DEL EQUIPO


FILTER BY cultiv_tran_past.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=eq_earado_1 eq_tearado eq_erastra_1 eq_terastra eq_esurcadora_1 eq_tesurcadora 
    eq_efangueo_1 eq_tefangueo 
    DISPLAY=LABEL
  /TABLE BY eq_earado_1 [C][COUNT F40.0] + eq_tearado [C][COUNT F40.0] + eq_erastra_1 [C][COUNT 
    F40.0] + eq_terastra [C][COUNT F40.0] + eq_esurcadora_1 [C][COUNT F40.0] + eq_tesurcadora [COUNT 
    F40.0] + eq_efangueo_1 [COUNT F40.0] + eq_tefangueo [COUNT F40.0]
  /CATEGORIES VARIABLES=eq_earado_1 eq_erastra_1 eq_esurcadora_1 eq_efangueo_1 ORDER=A KEY=VALUE 
    EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=eq_tearado eq_terastra eq_tesurcadora eq_tefangueo ORDER=A KEY=VALUE 
    EMPTY=INCLUDE.


***** TABLA 31. PRODUCTORES AGROPECUARIOS QUE UTILIZARON MÁQUINAS PARA DESARROLLAR SUS ACTIVIDADES PRODUCTIVAS.

FILTER BY cultiv_tran_past.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=eq_semman eq_tsemman eq_semmec eq_tsemmec eq_splanman eq_tsplanman eq_splanmec 
    eq_tsplanmec eq_sninguna 
    DISPLAY=LABEL
  /TABLE BY eq_semman [C][COUNT F40.0] + eq_tsemman [C][COUNT F40.0] + eq_semmec [C][COUNT F40.0] + 
    eq_tsemmec [C][COUNT F40.0] + eq_splanman [C][COUNT F40.0] + eq_tsplanman [C][COUNT F40.0] + 
    eq_splanmec [C][COUNT F40.0] + eq_tsplanmec [C][COUNT F40.0] + eq_sninguna [C][COUNT F40.0]
  /CATEGORIES VARIABLES=eq_semman eq_tsemman eq_semmec eq_tsemmec eq_splanman eq_tsplanman 
    eq_splanmec eq_tsplanmec ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=eq_sninguna ORDER=A KEY=VALUE EMPTY=EXCLUDE.


****************************************************************************************************************************************************************************************************

* TABLA 32. PRODUCTORES AGROPECUARIOS QUE UTILIZARON EQUIPO PARA PREPARAR EL TERRENO DE CULTIVO, POR TIPO DE EQUIPO USADO
* Y SEGÚN PROPIEDAD DEL EQUIPO.

FILTER BY cultiv_tran_past.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=eq_eboleadora eq_teboleadora eq_emotoguadana eq_tmotoguadana eq_ecultivador 
    eq_tecultivador eq_eaguilon eq_teaguilon eq_ebestaciona eq_tebestaciona 
    DISPLAY=LABEL
  /TABLE BY eq_eboleadora [COUNT F40.0] + eq_teboleadora [COUNT F40.0] + eq_emotoguadana [COUNT 
    F40.0] + eq_tmotoguadana [COUNT F40.0] + eq_ecultivador [COUNT F40.0] + eq_tecultivador [COUNT 
    F40.0] + eq_eaguilon [COUNT F40.0] + eq_teaguilon [COUNT F40.0] + eq_ebestaciona [COUNT F40.0] + 
    eq_tebestaciona [COUNT F40.0]
  /CATEGORIES VARIABLES=eq_eboleadora eq_teboleadora eq_emotoguadana eq_tmotoguadana eq_ecultivador 
    eq_tecultivador eq_eaguilon eq_teaguilon eq_ebestaciona eq_tebestaciona ORDER=A KEY=VALUE 
    EMPTY=INCLUDE.


FILTER BY cultiv_tran_past.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=eq_ebmotor eq_tebmotor eq_ebmanual eq_tebmanual eq_dninguno DISPLAY=LABEL
  /TABLE BY eq_ebmotor [COUNT F40.0] + eq_tebmotor [COUNT F40.0] + eq_ebmanual [COUNT F40.0] + 
    eq_tebmanual [COUNT F40.0] + eq_dninguno [COUNT F40.0]
  /CATEGORIES VARIABLES=eq_ebmotor eq_tebmotor eq_ebmanual eq_tebmanual ORDER=A KEY=VALUE 
    EMPTY=INCLUDE
  /CATEGORIES VARIABLES=eq_dninguno ORDER=A KEY=VALUE EMPTY=EXCLUDE.


***TABLA 33. PRODUCTORES AGROPECUARIOS QUE UTILIZARON EQUIPO PARA COSECHAR SUS CULTIVOS, POR TIPO DE EQUIPO USADO Y SEGÚN PROPIEDAD DEL EQUIPO***															


FILTER BY cultiv_tran_past.

* Tablas personalizadas.

CTABLES
  /VLABELS VARIABLES=eq_etrilladora eq_tetrilladora eq_ecosgranfigr eq_tecosgranfigr eq_esegadora 
    eq_tesegadora eq_ecosotras eq_tecosotras 
    DISPLAY=LABEL
  /TABLE BY eq_etrilladora [C][COUNT F40.0] + eq_tetrilladora [C][COUNT F40.0] + eq_ecosgranfigr 
    [C][COUNT F40.0] + eq_tecosgranfigr [C][COUNT F40.0] + eq_esegadora [C][COUNT F40.0] + 
    eq_tesegadora [C][COUNT F40.0] + eq_ecosotras [C][COUNT F40.0] + eq_tecosotras [C][COUNT F40.0]
  /CATEGORIES VARIABLES=eq_etrilladora eq_tetrilladora eq_ecosgranfigr eq_tecosgranfigr 
    eq_esegadora eq_tesegadora eq_ecosotras eq_tecosotras ORDER=A KEY=VALUE EMPTY=INCLUDE.



*** GUARDAR BASE DEL MÓDULO AMBIENTAL (ambnac2020.sav) ***.

*** SINTAXIS DE CÁLCULO DE ASISTENCIA TÉCNICA, ANÁLISIS DE SUELO Y FINANCIAMIENTO EN CULTIVOS PERMANENTES Y TRANSITORIOS.
*** ESPAC 2020.
*** DEAGA - Abril 2021.

* (A) PROCESAMIENTO INDEPENDIENTE DEL TIPO DE CULTIVO (Se lo realiza indistintamente para cultivos permanentes y transitorios).

* (1) Llevar las variables de la BDD del Módulo Ambiental a la BDD de Cultivos Permanentes.

* Las variables que se llevan son: 
ea_atagrmag = ¿Usted ha recibido asistencia técnica agrícola del MAG?
ea_atagriniap = ¿Usted ha recibido asistencia técnica agrícola del INIAP?
ea_atagrgadp = ¿Usted ha recibido asistencia técnica agrícola del GAD Provincial?
ea_atagrgadm = ¿Usted ha recibido asistencia técnica agrícola del GAD Municipal?
ea_atagrcc = ¿Usted ha recibido asistencia técnica agrícola de la Casa Comercial?
ea_atagrongs = ¿Usted ha recibido asistencia técnica agrícola de ONGs?
ea_atagrotro = ¿Usted ha recibido asistencia técnica agrícola de Otras instituciones?
plag_anasuelo = ¿Hace cuánto realizó el último análisis de suelo?
pa_intasuelo = Interpretar y aplicar recomendaciones del análisis.

DATASET NAME Permanentes.
DATASET NAME Ambientales.

DATASET ACTIVATE Permanentes.
MATCH FILES /FILE=*
  /FILE='Ambientales'
  /RENAME (al_ncues ual_cant ual_estr ual_parr ual_prov ual_segm = d0 d1 d2 d3 d4 d5) 
  /IN source01
  /BY Identificador
  /DROP= d0 d1 d2 d3 d4 d5.
VARIABLE LABELS source01 'El registro (fila) de la BDD actual proviene de la BDD de Ambientales'.
EXECUTE.

* Con esas variables en la nueva BDD ampliada, se realizan procedimientos de reasignación de variables por productor único y de limpieza.
* Ya no se requiere la BDD del Módulo Ambiental. En adelante, se trabaja únicamente con la BDD de cultivos, pero incluyendo variables ambientales.

* Cálculo de la variable de asistencia técnica y capacitación, contando con todas las instituciones, por productor.
FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE MAGAP = MIN(ea_capagrmag, ea_atagrmag, ea_cappecmag, ea_atpecmag).
COMPUTE INIAP = MIN(ea_capagriniap, ea_atagriniap, ea_cappeciniap, ea_atpeciniap).
COMPUTE GADP = MIN(ea_capagrgadp, ea_atagrgadp, ea_cappecgadp, ea_atpecgadp).
COMPUTE GADM = MIN(ea_capagrgadm, ea_atagrgadm, ea_cappecgadm, ea_atpecgadm).
COMPUTE CCOM = MIN(ea_capagrcc, ea_atagrcc, ea_cappeccc, ea_atpeccc).
COMPUTE ONGS = MIN(ea_capagrongs, ea_atagrongs, ea_cappecongs, ea_atpecongs).
COMPUTE OTRO = MIN(ea_capagrotro, ea_atagrotro, ea_cappecotro, ea_atpecotro).
EXECUTE.

COMPUTE CAPA_AT = MIN(MAGAP, INIAP, GADP, GADM, CCOM, ONGS, OTRO).
VARIABLE LABELS CAPA_AT "¿Ud. ha recibido capacitación o asistencia técnica?".
VALUE LABELS CAPA_AT 1"Sí" 2"No".
FREQUENCIES CAPA_AT.

IF (Missing(CAPA_AT)) CAPA_AT = 2.
FREQUENCIES CAPA_AT.

* Cálculo del máximo de las variables ambientales por Identificador (Productor), con el fin de tener únicamente una instancia de las variables ambientales
* por cada productor. Estas variables maximizadas son las que se agregarán en los tabulados de reporte.

SORT CASES BY Identificador (A).
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=Identificador
  /ea_asistec_max=MAX(ea_asistec) 
  /ea_brindoasistec_max=MAX(ea_brindoasistec) 
  /plag_anasuelo_max=MAX(plag_anasuelo) 
  /pa_intasuelo_max=MAX(pa_intasuelo).

* Detección de Identificadores (Productores) duplicados. Este procedimiento es útil para la posterior agregación de las variables ambientales maximizadas.

MATCH FILES
  /FILE=*
  /BY Identificador
  /LAST=Original.
VARIABLE LABELS  Original 'Indicador de cada último caso de coincidencia como primario'.
VALUE LABELS  Original 0 'Caso duplicado' 1 'Caso primario'.
VARIABLE LEVEL  Original (ORDINAL).
EXECUTE.


* (2) Llevar las variables de la BDD de Financiamiento a la BDD ampliada de Cultivos Permanentes.
* Las variables que se llevan son (aplicadas a todas las Personas Productoras):
fina_propio_mr = ¿Tiene financiamiento propio? Monto recibido (USD)
fina_banpri_mr = ¿Tiene financiamiento de la banca privada? Monto recibido (USD)
fina_banpri_mp = ¿Tiene financiamiento de la banca privada? Monto final a pagar (USD)
fina_cooper_mr = ¿Tiene financiamiento de cooperativas o cajas de ahorro? Monto recibido (USD)
fina_cooper_mp = ¿Tiene financiamiento de cooperativas o cajas de ahorro? Monto final a pagar (USD)
fina_banpub_mr = ¿Tiene financiamiento de la banca pública? Monto recibido (USD)
fina_banpub_mp = ¿Tiene financiamiento de la banca pública? Monto final a pagar (USD)
fina_preinf_mr = ¿Tiene financiamiento de prestamistas informales? Monto recibido (USD))
fina_funong_mr = ¿Tiene financiamiento de Fundaciones u ONGs? Sí / No
fina_funong_mp = ¿Tiene financiamiento de Fundaciones u ONGs? Monto recibido (USD)
fina_costot_mr = ¿Tiene financiamiento de Fundaciones u ONGs? Monto final a pagar (USD)

* Con esas variables en la nueva BDD ampliada, se realizan procedimientos de reasignación de variables por productor único y de limpieza.
* Ya no se requiere la BDD de Financiamiento. En adelante, se trabaja únicamente con la BDD de cultivos, pero incluyendo variables ambientales
* y financieras.

* Cálculo del máximo de las variables financieras por Identificador (Productor), con el fin de tener únicamente una instancia de las variables ambientales
* por cada productor. Estas variables maximizadas son las que se agregarán en los tabulados de reporte.

SORT CASES BY Identificador (A).
AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /PRESORTED
  /BREAK=Identificador
  /fina_propio_mr_max=MAX(fina_propio_mr) 
  /fina_banpri_mr_max=MAX(fina_banpri_mr) 
  /fina_banpri_mp_max=MAX(fina_banpri_mp) 
  /fina_cooper_mr_max=MAX(fina_cooper_mr) 
  /fina_cooper_mp_max=MAX(fina_cooper_mp) 
  /fina_banpub_mr_max=MAX(fina_banpub_mr) 
  /fina_banpub_mp_max=MAX(fina_banpub_mp) 
  /fina_preinf_mr_max=MAX(fina_preinf_mr) 
  /fina_preinf_mp_max=MAX(fina_preinf_mp) 
  /fina_funong_mr_max=MAX(fina_funong_mr) 
  /fina_funong_mp_max=MAX(fina_funong_mp).

* (3) Asignación del valor "Missing" a los casos repetidos dentro de cada grupo de parcelas con el mismo Identificador (Productor).
* Al final, quedan únicamente valores de las variables ambientales y financieras para cada productor. Es decir, aparecen una sola
* vez para cada Identificador (Productor).

* Si se está trabajando actualmente con la BDD de cultivos permanentes ampliada, ejecutar la siguiente línea de código:

SORT CASES BY id (A) ea_asistec (D) ea_brindoasistec (D) plag_anasuelo (D) pa_intasuelo (D) rc_clacul (D) cp_nuevacondicion (D).

* Si se está trabajando actualmente con la BDD de cultivos transitorios ampliada, ejecutar la siguiente línea de código:

SORT CASES BY id (A) ea_asistec (D) ea_brindoasistec (D) plag_anasuelo (D) pa_intasuelo (D) ct_clacul (D) ct_nuevacondicion (D).


* Continuar con la ejecución para cualesquiera de las BDD ampliadas.

do if (Original = 0).
   COMPUTE ea_asistec_max = $SYSMIS.
   COMPUTE ea_brindoasistec_max = $SYSMIS.
   COMPUTE plag_anasuelo_max = $SYSMIS.
   COMPUTE pa_intasuelo_max = $SYSMIS.
end if.
EXECUTE.

do if (Original = 0).
   COMPUTE fina_propio_mr_max = $SYSMIS.
   COMPUTE fina_banpri_mr_max = $SYSMIS.
   COMPUTE fina_banpri_mp_max = $SYSMIS.
   COMPUTE fina_cooper_mr_max = $SYSMIS.
   COMPUTE fina_cooper_mp_max = $SYSMIS.
   COMPUTE fina_banpub_mr_max = $SYSMIS.
   COMPUTE fina_banpub_mp_max = $SYSMIS.
   COMPUTE fina_preinf_mr_max = $SYSMIS.
   COMPUTE fina_preinf_mp_max = $SYSMIS.
   COMPUTE fina_funong_mr_max = $SYSMIS.
   COMPUTE fina_funong_mp_max = $SYSMIS.
end if.
EXECUTE.

* (4) Definición de la variable "Region", la cual asocia a cada terreno una región geográfica natural del país.

RECODE ual_prov ('07', '08', '09', '12', '13', '24' = 1) ('01', '02', '03', '04', '05', '06', '10', '11', '17', '18', '23' = 2) ('14', '15', '16', '19', '21', '22' = 3) into Region.
VARIABLE LABELS Region "Región Natural".
VALUE LABELS Region 1'Costa' 2'Sierra' 3'Amazonía'.
FREQUENCIES Region. 

* (5) Definición de la variable "Tam_Parc", el cual define el tamaño de la parcela, tamaño que es función de la región geográfica en donde se encuentre la
* parcela. También depende de parámetros, valores mínimo y máximo dentro de cada categoría de tamaño de parcela ("Pequeña", "Mediana" y "Grande").

WEIGHT by fact_exp_fin.

* Ejecutar el siguiente código en el caso en que se esté trabajando con la BDD ampliada de cultivos permanentes.

DO IF (Region = 1 & range(cp_k409ha, 0.01, 10)).
   COMPUTE Tam_Parc = 1.
ELSE IF (Region = 1 & range(cp_k409ha, 10.01, 50)).
   COMPUTE Tam_Parc = 2.
ELSE IF (Region = 1 & (cp_k409ha > 50)).
   COMPUTE Tam_Parc = 3.
ELSE IF (Region = 2 & range(cp_k409ha, 0.01, 5)).
   COMPUTE Tam_Parc = 4.
ELSE IF (Region = 2 & range(cp_k409ha, 5.01, 25)).
   COMPUTE Tam_Parc = 5.
ELSE IF (Region = 2 & (cp_k409ha > 25)).
   COMPUTE Tam_Parc = 6.
ELSE IF (Region = 3 & range(cp_k409ha, 0.01, 25)).
   COMPUTE Tam_Parc = 7.
ELSE IF (Region = 3 & range(cp_k409ha, 25.01, 75)).
   COMPUTE Tam_Parc = 8.
ELSE IF (Region = 3 & (cp_k409ha > 75)).
   COMPUTE Tam_Parc = 9.
END IF.

* Ejecutar el siguiente código en el caso en que se esté trabajando con la BDD ampliada de cultivos transitorios.

DO IF (Region = 1 & range(ct_k510ha, 0.01, 10)).
   COMPUTE Tam_Parc = 1.
ELSE IF (Region = 1 & range(ct_k510ha, 10.01, 50)).
   COMPUTE Tam_Parc = 2.
ELSE IF (Region = 1 & (ct_k510ha > 50)).
   COMPUTE Tam_Parc = 3.
ELSE IF (Region = 2 & range(ct_k510ha, 0.01, 5)).
   COMPUTE Tam_Parc = 4.
ELSE IF (Region = 2 & range(ct_k510ha, 5.01, 25)).
   COMPUTE Tam_Parc = 5.
ELSE IF (Region = 2 & (ct_k510ha > 25)).
   COMPUTE Tam_Parc = 6.
ELSE IF (Region = 3 & range(ct_k510ha, 0.01, 25)).
   COMPUTE Tam_Parc = 7.
ELSE IF (Region = 3 & range(ct_k510ha, 25.01, 75)).
   COMPUTE Tam_Parc = 8.
ELSE IF (Region = 3 & (ct_k510ha > 75)).
   COMPUTE Tam_Parc = 9.
END IF.

VARIABLE LABELS Tam_Parc "Tamaño de Parcela".
VALUE LABELS Tam_Parc
1"Costa_Pequeña"
2"Costa_Mediana"
3"Costa_Grande"
4"Sierra_Pequeña"
5"Sierra_Mediana"
6"Sierra_Grande"
7"Amazonía_Pequeña"
8"Amazonía_Mediana"
9"Amazonía_Grande".

FREQUENCIES Tam_Parc.

COMPUTE Superf_posit = (cp_k409ha > 0).
EXECUTE.

FILTER BY Superf_posit.

* Generación de la variable de quintiles de superficie plantada.
RANK VARIABLES=cp_k409ha (A)
  /NTILES(5)
  /PRINT=YES
  /TIES=MEAN.

WEIGHT OFF.

* Límites en los rangos de superficies por quintil de superficie plantada (variabe Ncp_k409).
CTABLES
  /VLABELS VARIABLES=Ncp_k409 cp_k409ha DISPLAY=LABEL
  /TABLE Ncp_k409 [C] BY cp_k409ha [S][MINIMUM] + cp_k409ha [S][MAXIMUM]
  /CATEGORIES VARIABLES=Ncp_k409 ORDER=A KEY=VALUE EMPTY=EXCLUDE.

* (B) PROCESAMIENTO DEPENDIENTE DEL TIPO DE CULTIVO (Se lo realiza por separado para cultivos permanentes y transitorios).

* (6) Tabulación de las variables transportadas de las BDD Ambiental y Financiera hacia las BDD de cultivos permanentes.

WEIGHT by fact_exp_fin.
FILTER OFF.
USE ALL.

* Tabla P.1 Asistencia técnica y entidad oferente en las parcelas con cultivos permanentes, por tamaño de parcela.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc source01 CAPA_AT MAGAP INIAP GADP GADM CCOM ONGS OTRO DISPLAY=LABEL
  /TABLE Tam_Parc [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (CAPA_AT [C] + MAGAP [C] + INIAP [C] 
  + GADP [C] + GADM [C] + CCOM [C] + ONGS [C] + OTRO [C])
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 MAGAP INIAP GADP GADM CCOM ONGS OTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=CAPA_AT ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla P.1 Asistencia técnica y entidad oferente en las parcelas con cultivos permanentes, por tamaño de parcela'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie plantada.
CTABLES
  /VLABELS VARIABLES=Ncp_k409 source01 CAPA_AT MAGAP INIAP GADP GADM CCOM ONGS OTRO DISPLAY=LABEL
  /TABLE Ncp_k409 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (CAPA_AT [C] + MAGAP [C] + INIAP [C] 
  + GADP [C] + GADM [C] + CCOM [C] + ONGS [C] + OTRO [C])
  /CATEGORIES VARIABLES=Ncp_k409 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 MAGAP INIAP GADP GADM CCOM ONGS OTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=CAPA_AT ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla P.1 Asistencia técnica y entidad oferente en las parcelas con cultivos permanentes, por quintiles de superficie plantada'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.2 Asistencia técnica y entidad oferente en las parcelas con cultivos permanentes, por cultivo permanente.

CTABLES
  /VLABELS VARIABLES=cp_nclavr source01 CAPA_AT MAGAP INIAP GADP GADM CCOM ONGS OTRO DISPLAY=LABEL
  /TABLE cp_nclavr [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (CAPA_AT [C] + MAGAP [C] 
  + INIAP [C] + GADP [C] + GADM [C] + CCOM [C] + ONGS [C] + OTRO [C])
  /CATEGORIES VARIABLES=cp_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 MAGAP INIAP GADP GADM CCOM ONGS OTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=CAPA_AT ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla P.2 Asistencia técnica y entidad oferente en las parcelas con cultivos permanentes, por cultivo permanente'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.3 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos permanentes, por tamaño de parcela.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc plag_anasuelo pa_intasuelo DISPLAY=LABEL
  /TABLE Tam_Parc [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (plag_anasuelo [C] + pa_intasuelo [C])
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=plag_anasuelo pa_intasuelo ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='Tabla P.3 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos permanentes, por tamaño de parcela'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie plantada.
CTABLES
  /VLABELS VARIABLES=Ncp_k409 plag_anasuelo pa_intasuelo DISPLAY=LABEL
  /TABLE Ncp_k409 [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (plag_anasuelo [C] + pa_intasuelo [C])
  /CATEGORIES VARIABLES=Ncp_k409 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=plag_anasuelo pa_intasuelo ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='Tabla P.3 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos permanentes, por quintiles de superficie plantada'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.4 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos permanentes, por cultivo transitorio.

CTABLES
  /VLABELS VARIABLES=cp_nclavr plag_anasuelo pa_intasuelo DISPLAY=LABEL
  /TABLE cp_nclavr [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (plag_anasuelo [C] + pa_intasuelo [C])
  /CATEGORIES VARIABLES=cp_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=plag_anasuelo pa_intasuelo ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='Tabla P.4 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos permanentes, por cultivo transitorio'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.5 Financiamiento en las parcelas con cultivos permanentes, por tamaño de parcela y según fuente de financiamiento.

WEIGHT OFF.

MATCH FILES /FILE=*
  /FILE='Financiamiento'
  /RENAME (al_ncues ual_cant ual_estr ual_parr ual_prov ual_segm = d0 d1 d2 d3 d4 d5) 
  /IN source02
  /BY Identificador
  /DROP= d0 d1 d2 d3 d4 d5.
VARIABLE LABELS source02 'El registro (fila) de la BDD actual proviene de la BDD de Financiamiento'.
EXECUTE.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc source02 fina_propio_fue fina_propio_mr fina_banpri_fue fina_banpri_mr fina_cooper_fue fina_cooper_mr
 fina_banpub_fue fina_banpub_mr fina_preinf_fue fina_preinf_mr fina_funong_fue fina_funong_mr DISPLAY=LABEL
  /TABLE Tam_Parc [C] BY source02 [C] > (source02 [COUNT F40.0] + fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_propio_mr [S][SUM]
 + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_mr [S][SUM] + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
 + fina_cooper_mr [S][SUM] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_mr [S][SUM] 
 + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_preinf_mr [S][SUM] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
 + fina_funong_mr [S][SUM])
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source02 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue 
  fina_preinf_fue fina_funong_fue ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Tabla P.5 Financiamiento en las parcelas con cultivos permanentes, por tamaño de parcela y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie plantada.
CTABLES
  /VLABELS VARIABLES=Ncp_k409 source02 fina_propio_fue fina_propio_mr fina_banpri_fue fina_banpri_mr fina_cooper_fue fina_cooper_mr
 fina_banpub_fue fina_banpub_mr fina_preinf_fue fina_preinf_mr fina_funong_fue fina_funong_mr DISPLAY=LABEL
  /TABLE Ncp_k409 [C] BY source02 [C] > (source02 [COUNT F40.0] + fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_propio_mr [S][SUM]
 + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_mr [S][SUM] + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
 + fina_cooper_mr [S][SUM] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_mr [S][SUM] 
 + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_preinf_mr [S][SUM] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
 + fina_funong_mr [S][SUM])
  /CATEGORIES VARIABLES=Ncp_k409 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source02 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue 
  fina_preinf_fue fina_funong_fue ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Tabla P.5 Financiamiento en las parcelas con cultivos permanentes, por quintiles de superficie plantada y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.6 Financiamiento en las parcelas con cultivos permanentes, por cultivo permanente y según fuente de financiamiento.

CTABLES
  /VLABELS VARIABLES=cp_nclavr source02 fina_propio_fue fina_propio_mr fina_banpri_fue fina_banpri_mr fina_cooper_fue fina_cooper_mr
 fina_banpub_fue fina_banpub_mr fina_preinf_fue fina_preinf_mr fina_funong_fue fina_funong_mr DISPLAY=LABEL
  /TABLE cp_nclavr [C] BY source02 [C] > (source02 [COUNT F40.0] + fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_propio_mr [S][SUM]
 + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_mr [S][SUM] + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
 + fina_cooper_mr [S][SUM] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_mr [S][SUM] 
 + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_preinf_mr [S][SUM] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
 + fina_funong_mr [S][SUM])
  /CATEGORIES VARIABLES=cp_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source02 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue 
  fina_preinf_fue fina_funong_fue ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Tabla P.6 Financiamiento en las parcelas con cultivos permanentes, por cultivo permanente y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.7 Distribución de parcelas con cultivos permanentes que recibieron financiamiento, por tamaño de parcela y según fuente de financiamiento.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue
    DISPLAY=LABEL
  /TABLE Tam_Parc [C] BY fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue ORDER=A 
  KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla P.7 Distribución de parcelas con cultivos permanentes que recibieron financiamiento, por tamaño de parcela y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie plantada.
CTABLES
  /VLABELS VARIABLES=Ncp_k409 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue
    DISPLAY=LABEL
  /TABLE Ncp_k409 [C] BY fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Ncp_k409 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue ORDER=A 
  KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla P.7 Distribución de parcelas con cultivos permanentes que recibieron financiamiento, por quintiles de superficie plantada y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla P.8 Distribución de cultivos permanentes que recibieron financiamiento, por cultivo permanente y según fuente de financiamiento.

CTABLES
  /VLABELS VARIABLES=cp_nclavr fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue
    DISPLAY=LABEL
  /TABLE cp_nclavr [C] BY fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=cp_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue ORDER=A 
  KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla P.8 Distribución de cultivos permanentes que recibieron financiamiento, por cultivo permanente y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

*****************************************************************************************************************************************************************************************

* (7) Tabulación de las variables transportadas de las BDD Ambiental y Financiera hacia las BDD de cultivos transitorios.

DATASET NAME Transitorios.
DATASET NAME Ambientales.

DATASET ACTIVATE Transitorios.
MATCH FILES /FILE=*
  /FILE='Ambientales'
  /RENAME (al_ncues ual_cant ual_estr ual_parr ual_prov ual_segm = d0 d1 d2 d3 d4 d5) 
  /IN source01
  /BY Identificador
  /DROP= d0 d1 d2 d3 d4 d5.
VARIABLE LABELS source01 'El registro (fila) de la BDD actual proviene de la BDD de Ambientales'.
EXECUTE.

* Cálculo de la variable de asistencia técnica y capacitación, contando con todas las instituciones, por productor.
FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE MAGAP = MIN(ea_capagrmag, ea_atagrmag, ea_cappecmag, ea_atpecmag).
COMPUTE INIAP = MIN(ea_capagriniap, ea_atagriniap, ea_cappeciniap, ea_atpeciniap).
COMPUTE GADP = MIN(ea_capagrgadp, ea_atagrgadp, ea_cappecgadp, ea_atpecgadp).
COMPUTE GADM = MIN(ea_capagrgadm, ea_atagrgadm, ea_cappecgadm, ea_atpecgadm).
COMPUTE CCOM = MIN(ea_capagrcc, ea_atagrcc, ea_cappeccc, ea_atpeccc).
COMPUTE ONGS = MIN(ea_capagrongs, ea_atagrongs, ea_cappecongs, ea_atpecongs).
COMPUTE OTRO = MIN(ea_capagrotro, ea_atagrotro, ea_cappecotro, ea_atpecotro).
EXECUTE.

COMPUTE CAPA_AT = MIN(MAGAP, INIAP, GADP, GADM, CCOM, ONGS, OTRO).
VARIABLE LABELS CAPA_AT "¿Ud. ha recibido capacitación o asistencia técnica?".
VALUE LABELS CAPA_AT 1"Sí" 2"No".
FREQUENCIES CAPA_AT.

IF (Missing(CAPA_AT)) CAPA_AT = 2.
FREQUENCIES CAPA_AT.

****************************************************************************************************

COMPUTE Superf_posit = (ct_k510ha > 0).
EXECUTE.

FILTER BY Superf_posit.

* Generación de la variable de quintiles de superficie plantada.
RANK VARIABLES=ct_k510ha (A)
  /NTILES(5)
  /PRINT=YES
  /TIES=MEAN.

WEIGHT OFF.

* Límites en los rangos de superficies por quintil de superficie sembrada (variabe Nct_k510).
CTABLES
  /VLABELS VARIABLES=Nct_k510 ct_k510ha DISPLAY=LABEL
  /TABLE Nct_k510 [C] BY ct_k510ha [S][MINIMUM] + ct_k510ha [S][MAXIMUM]
  /CATEGORIES VARIABLES=Nct_k510 ORDER=A KEY=VALUE EMPTY=EXCLUDE.

**********************************************************************************************************

FILTER OFF.
USE ALL.
WEIGHT by fact_exp_fin.

* Tabla T.1 Asistencia técnica y entidad oferente en las parcelas con cultivos transitorios, por tamaño de parcela.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc source01 CAPA_AT MAGAP INIAP GADP GADM CCOM ONGS OTRO DISPLAY=LABEL
  /TABLE Tam_Parc [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (CAPA_AT [C] + MAGAP [C] + INIAP [C] 
  + GADP [C] + GADM [C] + CCOM [C] + ONGS [C] + OTRO [C])
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 MAGAP INIAP GADP GADM CCOM ONGS OTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=CAPA_AT ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla T.1 Asistencia técnica y entidad oferente en las parcelas con cultivos transitorios, por tamaño de parcela'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie sembrada.
CTABLES
  /VLABELS VARIABLES=Nct_k510 source01 CAPA_AT MAGAP INIAP GADP GADM CCOM ONGS OTRO DISPLAY=LABEL
  /TABLE Nct_k510 [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (CAPA_AT [C] + MAGAP [C] + INIAP [C] 
  + GADP [C] + GADM [C] + CCOM [C] + ONGS [C] + OTRO [C])
  /CATEGORIES VARIABLES=Nct_k510 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 MAGAP INIAP GADP GADM CCOM ONGS OTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=CAPA_AT ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla T.1 Asistencia técnica y entidad oferente en las parcelas con cultivos transitorios, por quintiles de superficie sembrada'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.2 Asistencia técnica y entidad oferente en las parcelas con cultivos transitorios, por cultivo transitorio.

CTABLES
  /VLABELS VARIABLES=ct_nclavr source01 CAPA_AT MAGAP INIAP GADP GADM CCOM ONGS OTRO DISPLAY=LABEL
  /TABLE ct_nclavr [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] BY source01 [C] > (CAPA_AT [C] + MAGAP [C] 
  + INIAP [C] + GADP [C] + GADM [C] + CCOM [C] + ONGS [C] + OTRO [C])
  /CATEGORIES VARIABLES=ct_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source01 MAGAP INIAP GADP GADM CCOM ONGS OTRO ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=CAPA_AT ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla T.2 Asistencia técnica y entidad oferente en las parcelas con cultivos transitorios, por cultivo transitorio'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.3 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos transitorios, por tamaño de parcela.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc plag_anasuelo pa_intasuelo DISPLAY=LABEL
  /TABLE Tam_Parc [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY plag_anasuelo [C] + pa_intasuelo [C]
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=plag_anasuelo pa_intasuelo ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='Tabla T.3 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos transitorios, por tamaño de parcela'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie sembrada.
CTABLES
  /VLABELS VARIABLES=Nct_k510 plag_anasuelo pa_intasuelo DISPLAY=LABEL
  /TABLE Nct_k510 [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY plag_anasuelo [C] + pa_intasuelo [C]
  /CATEGORIES VARIABLES=Nct_k510 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=plag_anasuelo pa_intasuelo ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='Tabla T.3 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos transitorios, por quintiles de superficie sembrada'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.4 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos transitorios, por cultivo transitorio.

CTABLES
  /VLABELS VARIABLES=ct_nclavr plag_anasuelo pa_intasuelo DISPLAY=LABEL
  /TABLE ct_nclavr [COUNT F40.0, ROWPCT.COUNT PCT40.1] BY plag_anasuelo [C] + pa_intasuelo [C]
  /CATEGORIES VARIABLES=ct_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=plag_anasuelo pa_intasuelo ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='Tabla T.4 Análisis de suelo e interpretación / aplicación de sus recomendaciones en cultivos transitorios, por cultivo transitorio'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.5 Financiamiento en las parcelas con cultivos transitorios, por tamaño de parcela y según fuente de financiamiento.

WEIGHT OFF.

DATASET ACTIVATE Transitorios.
MATCH FILES /FILE=*
  /FILE='Financiamiento'
  /RENAME (al_ncues ual_cant ual_estr ual_parr ual_prov ual_segm = d0 d1 d2 d3 d4 d5) 
  /IN source02
  /BY Identificador
  /DROP= d0 d1 d2 d3 d4 d5.
VARIABLE LABELS source02 'El registro (fila) de la BDD actual proviene de la BDD de Financiamiento'.
EXECUTE.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc source02 fina_propio_fue fina_propio_mr fina_banpri_fue fina_banpri_mr fina_cooper_fue fina_cooper_mr
 fina_banpub_fue fina_banpub_mr fina_preinf_fue fina_preinf_mr fina_funong_fue fina_funong_mr DISPLAY=LABEL
  /TABLE Tam_Parc [C] BY source02 [C] > (source02 [COUNT F40.0] + fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_propio_mr [S][SUM]
 + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_mr [S][SUM] + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
 + fina_cooper_mr [S][SUM] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_mr [S][SUM] 
 + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_preinf_mr [S][SUM] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
 + fina_funong_mr [S][SUM])
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source02 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue 
  fina_preinf_fue fina_funong_fue ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Tabla T.5 Financiamiento en las parcelas con cultivos transitorios, por tamaño de parcela y según fuente de financiamiento'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie sembrada.
CTABLES
  /VLABELS VARIABLES=Nct_k510 source02 fina_propio_fue fina_propio_mr fina_banpri_fue fina_banpri_mr fina_cooper_fue fina_cooper_mr
 fina_banpub_fue fina_banpub_mr fina_preinf_fue fina_preinf_mr fina_funong_fue fina_funong_mr DISPLAY=LABEL
  /TABLE Nct_k510 [C] BY source02 [C] > (source02 [COUNT F40.0] + fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_propio_mr [S][SUM]
 + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_mr [S][SUM] + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
 + fina_cooper_mr [S][SUM] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_mr [S][SUM] 
 + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_preinf_mr [S][SUM] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
 + fina_funong_mr [S][SUM])
  /CATEGORIES VARIABLES=Nct_k510 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source02 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue 
  fina_preinf_fue fina_funong_fue ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Tabla T.5 Financiamiento en las parcelas con cultivos transitorios, por quintiles de superficie sembrada y según fuente de financiamiento'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.6 Financiamiento en las parcelas con cultivos transitorios, por cultivo transitorio y según fuente de financiamiento.

CTABLES
  /VLABELS VARIABLES=ct_nclavr source02 fina_propio_fue fina_propio_mr fina_banpri_fue fina_banpri_mr fina_cooper_fue fina_cooper_mr
 fina_banpub_fue fina_banpub_mr fina_preinf_fue fina_preinf_mr fina_funong_fue fina_funong_mr DISPLAY=LABEL
  /TABLE ct_nclavr [C] BY source02 [C] > (source02 [COUNT F40.0] + fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_propio_mr [S][SUM]
 + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_mr [S][SUM] + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
 + fina_cooper_mr [S][SUM] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_mr [S][SUM] 
 + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_preinf_mr [S][SUM] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
 + fina_funong_mr [S][SUM])
  /CATEGORIES VARIABLES=ct_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=source02 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue 
  fina_preinf_fue fina_funong_fue ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /TITLES
    TITLE='Tabla T.6 Financiamiento en las parcelas con cultivos transitorios, por cultivo transitorio y según fuente de financiamiento'
    'CULTIVOS TRANSITORIOS'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.7 Distribución de parcelas con cultivos transitorios que recibieron financiamiento, por tamaño de parcela y según fuente de financiamiento.

* Desagregado por tamaño de parcela zonificado.
CTABLES
  /VLABELS VARIABLES=Tam_Parc fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue
    DISPLAY=LABEL
  /TABLE Tam_Parc [C] BY fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Tam_Parc ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue ORDER=A 
  KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla T.7 Distribución de parcelas con cultivos transitorios que recibieron financiamiento, por tamaño de parcela y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.

* Desagregado por quintiles de superficie sembrada.
CTABLES
  /VLABELS VARIABLES=Nct_k510 fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue
    DISPLAY=LABEL
  /TABLE Nct_k510 [C] BY fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=Nct_k510 ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue ORDER=A 
  KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla T.7 Distribución de parcelas con cultivos transitorios que recibieron financiamiento, por quintiles de superficie sembrada y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


* Tabla T.8 Distribución de cultivos transitorios que recibieron financiamiento, por cultivo transitorio y según fuente de financiamiento.

CTABLES
  /VLABELS VARIABLES=ct_nclavr fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue
    DISPLAY=LABEL
  /TABLE ct_nclavr [C] BY fina_propio_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpri_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_cooper_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_banpub_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] 
  + fina_preinf_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1] + fina_funong_fue [C][COUNT F40.0, ROWPCT.COUNT PCT40.1]
  /CATEGORIES VARIABLES=ct_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=fina_propio_fue fina_banpri_fue fina_cooper_fue fina_banpub_fue fina_preinf_fue fina_funong_fue ORDER=A 
  KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='Tabla T.8 Distribución de cultivos transitorios que recibieron financiamiento, por cultivo transitorio y según fuente de financiamiento'
    'CULTIVOS PERMANENTES'
    CAPTION='Elaboración: INEC' 'Fuente: Encuesta de Superficie y Producción Agropecuaria Continua 2020'.


**** FIN DE LA SINTAXIS DE CÁLCULO DE ASISTENCIA TÉCNICA, ANÁLISIS DE SUELO Y FINANCIAMIENTO EN CULTIVOS PERMANENTES Y TRANSITORIOS *****
**** ESP

