* Encoding: UTF-8.

**************************************************************************************************************
*** SINTAXIS PARA EL CLCULO DE LOS ESTADSTICOS, TABULADOS E INDICADORES
*** DEL MDULO DE INFORMACIN AMBIENTAL EN AGRICULTURA DE LA ENCUESTA
*** DE SUPERFICIE Y PRODUCCIN AGROPECUARIA CONTINUA - ESPAC 2020.
*** REALIZADA POR: RAMIRO BENAVIDES - DEAGA.
*** 02 DE MAYO DE 2016
*** ACTUALIZACIN: CARLOS PILATAXI - DEAGA - 2021***  
**************************************************************************************************************

* TABLA 37.4 SUPERFICIE AGROPECUARIA BAJO RIEGO EN FLORES PERMANENTES.
*** ABRIR BASE DE FLORES PERMANENTES (fpnac2020.sav) ***.

DATASET NAME flores_perm.

WEIGHT OFF.
FILTER OFF.
USE ALL.

COMPUTE flores_perm_riego = (fp_riego = 1). /* Filtra flores permanentes con alguna clase de riego.
FREQUENCIES flores_perm_riego.

WEIGHT BY fact_exp_fin.

***** TABLA 37.4 SUPERFICIE AGROPECUARIA BAJO RIEGO EN FLORES PERMANENTES.

CTABLES
  /VLABELS VARIABLES=fp_riego fp_k706ha DISPLAY=LABEL
  /TABLE fp_riego BY fp_k706ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=fp_riego ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO EN FLORES PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2017-2020'.

WEIGHT OFF.
FILTER OFF.
USE ALL.


* TABLA 38.4 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN FLORES PERMANENTES.

*** ABRIR BASE DE FLORES PERMANENTES (fpnac2020.sav) ***.

DATASET ACTIVATE flores_perm.

FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE sup_riego_surc = fp_porc_surc * fp_k706ha / 100. /* Superficie de flores permanentes regada por surcos-inundacin.
COMPUTE sup_riego_aspe = fp_porc_aspe * fp_k706ha / 100.  /* Superficie de flores permanentes regada por aspersin.
COMPUTE sup_riego_micr = fp_porc_micr * fp_k706ha / 100.  /* Superficie de flores permanentes regada por microaspersin.
COMPUTE sup_riego_gote = fp_porc_gote * fp_k706ha / 100.  /* Superficie de flores permanentes regada por goteo.
COMPUTE sup_riego_nebu = fp_porc_nebu * fp_k706ha / 100. /* Superficie de flores permanentes regada por nebulizacin.
COMPUTE sup_riego_otro = fp_porc_otro * fp_k706ha / 100.  /* Superficie de flores permanentes regada por otra tecnologa.
EXECUTE.

WEIGHT BY fact_exp_fin. /* Toda superficie debe expandirse con este factor de expansin.

FILTER BY flores_perm_riego.


***** TABLA 38.4 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN FLORES PERMANENTES.

CTABLES
  /VLABELS VARIABLES=sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro fp_riego 
    DISPLAY=LABEL
  /TABLE sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [SUM] + sup_riego_otro [SUM] BY fp_riego
  /CATEGORIES VARIABLES=fp_riego [1] EMPTY=INCLUDE
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO, POR MTODO DE RIEGO EN FLORES PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

SPLIT FILE OFF.
WEIGHT OFF.

*****************************************************************************************************************************************************************************************************************

* TABLA 37.5 SUPERFICIE AGROPECUARIA BAJO RIEGO EN FLORES TRANSITORIAS*********
*** ABRIR BASE DE FLORES TRANSITORIAS (ftnac2020.sav) ***.

DATASET NAME flores_tran.

WEIGHT OFF.
FILTER OFF.
USE ALL.

COMPUTE flores_tran_riego = (ft_riego = 1). /* Filtra flores transitorias con alguna clase de riego.
FREQUENCIES flores_tran_riego.

WEIGHT BY fact_exp_fin.

***** TABLA 37.5 SUPERFICIE AGROPECUARIA BAJO RIEGO EN FLORES TRANSITORIAS.

CTABLES
  /VLABELS VARIABLES=ft_riego ft_k720ha DISPLAY=LABEL
  /TABLE ft_riego BY ft_k720ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=ft_riego ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO EN FLORES TRANSITORIAS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2017-2020'.

WEIGHT OFF.
FILTER OFF.
USE ALL.


* TABLA 38.5 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN FLORES TRANSITORIAS.

*** ABRIR BASE DE FLORES TRANSITORIAS (ftnac2020.sav) ***.

DATASET ACTIVATE flores_tran.

FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE sup_riego_surc = ft_porc_surc * ft_k720ha / 100. /* Superficie de flores transitorias regada por surcos-inundacin.
COMPUTE sup_riego_aspe = ft_porc_aspe * ft_k720ha / 100.  /* Superficie de flores transitorias regada por aspersin.
COMPUTE sup_riego_micr = ft_porc_micr * ft_k720ha / 100.  /* Superficie de flores transitorias regada por microaspersin.
COMPUTE sup_riego_gote = ft_porc_gote * ft_k720ha / 100.  /* Superficie de flores transitorias regada por goteo.
COMPUTE sup_riego_nebu = ft_porc_nebu * ft_k720ha / 100. /* Superficie de flores transitorias regada por nebulizacin.
COMPUTE sup_riego_otro = ft_porc_otro * ft_k720ha / 100.  /* Superficie de flores transitorias regada por otra tecnologa.
EXECUTE.

WEIGHT BY fact_exp_fin. /* Toda superficie debe expandirse con este factor de expansin.

VARIABLE LEVEL sup_riego_surc (SCALE).
VARIABLE LEVEL sup_riego_nebu (SCALE).
VARIABLE LEVEL sup_riego_otro (SCALE).

SPLIT FILE BY ft_riego.

***** TABLA 38.5 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN FLORES TRANSITORIAS.

CTABLES
  /VLABELS VARIABLES=sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro ft_riego 
    DISPLAY=LABEL
  /TABLE sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [SUM] + sup_riego_otro [SUM] BY ft_riego
  /CATEGORIES VARIABLES=ft_riego [1] EMPTY=INCLUDE
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO, POR MTODO DE RIEGO EN FLORES TRANSITORIAS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2017-2020'.

SPLIT FILE OFF.
WEIGHT OFF.

