* Encoding: UTF-8.

**************************************************************************************************************
*** SINTAXIS PARA EL CLCULO DE LOS ESTADSTICOS, TABULADOS E INDICADORES
*** DEL MDULO DE INFORMACIN AMBIENTAL EN AGRICULTURA DE LA ENCUESTA
*** DE SUPERFICIE Y PRODUCCIN AGROPECUARIA CONTINUA - ESPAC 2020.
*** REALIZADA POR: RAMIRO BENAVIDES - DEAGA.
*** 02 DE MAYO DE 2016
*** ACTUALIZACIN: CARLOS PILATAXI - DEAGA - 2021***  
**************************************************************************************************************


* (0) PREMBULO: CLCULO NO PUBLICADO DE LA SUPERFICIE AGROPECUARIA DEL ECUADOR.

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav)***.

DATASET CLOSE ambientales.
DATASET CLOSE caracteristicas.


DATASET NAME cpnac2020.

WEIGHT OFF.
FILTER OFF.
COMPUTE cultiv_perm = (rc_clacul >= 400 & rc_clacul <= 499). /* Los cultivos permanentes estn en este rango de productos. 
FREQUENCIES cultiv_perm.

FILTER BY cultiv_perm.
WEIGHT BY fact_exp_fin.

DESCRIPTIVES VARIABLES=cp_k409ha
  /STATISTICS=MEAN SUM STDDEV MIN MAX.


*** Se obtuvo 1.504.694ha. de cultivos permanentes_2020.
* SECCIN 1. CULTIVOS.

* TABLAS 1 y 2: SUPERFICIE PRODUCTIVA PERDIDA A NIVEL NACIONAL (ha).

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET NAME cpnac2020.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

RENAME VARIABLES (nuevacondicion = cp_nuevacondicion).
RENAME VARIABLES (superdida = cp_superdida).

FREQUENCIES cp_nuevacondicion. /* Condicin del cultivo permanente: 1 = Solo; 2 = Asociado; 3 = Invernadero.
FREQUENCIES cp_k412. /* Razn principal de prdida: 1 = Sequa; 2 = Helada; 3 = Plagas; 4 = Enfermedades; 5 = Inundacin; 6 = Otra.

WEIGHT BY fact_exp_fin.

***** TABLA 1. SUPERFICIE PERDIDA EN CULTIVOS PERMANENTES, POR FORMA DE SIEMBRA O PLANTACIN Y SEGN DIFERENTES CAUSAS DE PRDIDA

FILTER BY cultiv_perm.

CTABLES
  /VLABELS VARIABLES=cp_nuevacondicion cp_k412 cp_superdida DISPLAY=LABEL
  /TABLE cp_nuevacondicion BY cp_k412 > cp_superdida [SUM, ROWPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=cp_nuevacondicion ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=cp_k412 [1, 2, 3, 4, 5, 6] EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE=' SUPERFICIE PERDIDA EN CULTIVOS PERMANENTES, POR FORMA DE SIEMBRA O PLANTACIN Y SEGN DIFERENTES CAUSAS DE PRDIDA'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 5. SUPERFICIE PLANTADA POR FORMA DE SIEMBRA O PLANTACIN Y SEGN TIPO DE SEMILLA USADA EN CULTIVOS PERMANENTES
*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET ACTIVATE permanentes.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FREQUENCIES cp_k408. /* Semilla de ms uso: 1 = Comn; 2 = Mejorada; 3 = Hbrida nacional; 4 = Hbrida internacional.

RECODE cp_k408 (SYSMIS = 1) (ELSE = COPY) INTO cp_k408_R.
VALUE LABELS cp_k408_R 1'Comn' 2'Mejorada' 3'Hbrida nacional' 4'Hbrida internacional'.

FILTER BY cultiv_perm.

WEIGHT BY fact_exp_fin.

***** TABLA 5. SUPERFICIE PLANTADA POR FORMA DE SIEMBRA O PLANTACIN Y SEGN TIPO DE SEMILLA USADA EN CULTIVOS PERMANENTES.

CTABLES
  /VLABELS VARIABLES=cp_nuevacondicion cp_k408_R cp_k409ha DISPLAY=LABEL
  /TABLE cp_nuevacondicion [C] BY cp_k408_R > cp_k409ha [SUM]
  /CATEGORIES VARIABLES=cp_nuevacondicion cp_k408_R ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
   /TITLES
    TITLE='SUPERFICIE PLANTADA POR FORMA DE SIEMBRA O PLANTACIN Y SEGN TIPO DE SEMILLA USADA EN CULTIVOS PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.


* TABLA 7. SUPERFICIE PLANTADA O SEMBRADA, POR USO DE INSUMOS AGRCOLAS (ORGNICOS Y QUMICOS)

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET ACTIVATE permanentes.


***1 RECOD****

USE ALL.

RECODE cp_forg (SYSMIS=2) (ELSE=Copy) INTO cp_forg_2.
EXECUTE.

RECODE cp_fqui (SYSMIS=2) (ELSE=Copy) INTO cp_fqui_2.
EXECUTE.

RECODE cp_porg (SYSMIS=2) (ELSE=Copy) INTO cp_porg_2.
EXECUTE.

RECODE cp_pqui (SYSMIS=2) (ELSE=Copy) INTO cp_pqui_2.
EXECUTE.

***2 CALCULAR TABULADO****

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

COMPUTE ORG = ((cp_forg_2 = 1 OR cp_porg_2 = 1) AND (cp_fqui_2 = 2 AND cp_pqui_2 = 2)). /* Uso orgnico puro.
COMPUTE QUI = ((cp_fqui_2 = 1  OR cp_pqui_2 = 1) AND (cp_forg_2 = 2 AND cp_porg_2 = 2)). /* Uso qumico puro.
COMPUTE NIN = (cp_forg_2 = 2 AND cp_porg_2 = 2 AND cp_fqui_2 = 2 AND cp_pqui_2 = 2). /* Uso sin agrosustancias.
COMPUTE TOD = ~(ORG = 1 OR QUI = 1 OR NIN = 1). /* Uso con todas las agrosustancias.
FREQUENCIES ORG QUI NIN TOD.


VARIABLE LABELS ORG "Uso de insumos orgnicos".
VARIABLE LABELS QUI "Uso de insumos qumicos".
VARIABLE LABELS TOD "Uso de insumos orgnicos y qumicos".
VARIABLE LABELS NIN "No usan ningn tipo de insumo".
VALUE LABELS ORG QUI NIN TOD 0'No' 1'S'.

FILTER BY cultiv_perm.

WEIGHT BY fact_exp_fin.

**** TABLA 7A. SUPERFICIE PLANTADA POR USO DE INSUMOS AGRCOLAS (ORGNICOS Y QUMICOS) EN CULTIVOS PERMANENTES.

CTABLES
  /VLABELS VARIABLES=ORG QUI TOD NIN cp_k409ha DISPLAY=LABEL
  /TABLE ORG + QUI + TOD + NIN BY cp_k409ha [SUM]
  /CATEGORIES VARIABLES=ORG [1] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=TOD [1] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=NIN [1] EMPTY=EXCLUDE
   /TITLES
    TITLE='SUPERFICIE PLANTADA (ha) POR USO DE INSUMOS AGRCOLAS (ORGNICOS Y QUMICOS) EN CULTIVOS PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.


*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 8. SUPERFICIE PLANTADA POR CONDICIN DE CULTIVO Y SEGN TIPO DE FERTILIZANTE O FITOSANITARIO EN CULTIVOS PERMANENTES.

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET ACTIVATE permanentes.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FILTER BY cultiv_perm.

WEIGHT BY fact_exp_fin.

***** TABLA 8. SUPERFICIE PLANTADA POR CONDICIN DE CULTIVO Y SEGN TIPO DE FERTILIZANTE O FITOSANITARIO EN CULTIVOS PERMANENTES.

CTABLES
  /VLABELS VARIABLES=cp_k404 cp_k409ha cp_forg_2 cp_fqui_2 cp_porg_2 cp_pqui_2 DISPLAY=LABEL
  /TABLE cp_k404 [C] BY cp_k409ha [S][SUM] > (cp_forg_2 [C] + cp_fqui_2 [C]) + cp_k409ha [S][SUM] > (cp_porg_2 [C] + cp_pqui_2 [C])
  /CATEGORIES VARIABLES=cp_k404 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=cp_forg_2 cp_fqui_2 cp_porg_2 cp_pqui_2 [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE PLANTADA (ha) POR CONDICIN DE CULTIVO Y SEGN TIPO DE FERTILIZANTE O FITOSANITARIO'  'C. PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.


*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET ACTIVATE permanentes.

FILTER BY cultiv_perm.

WEIGHT BY fact_exp_fin.

***** TABLA 10, FILA 2: SUPERFICIE PLANTADA (ha) EN CULTIVOS PERMANENTES SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

CTABLES
  /VLABELS VARIABLES=ORG cp_k409ha QUI DISPLAY=LABEL
  /TABLE BY ORG [C] > cp_k409ha [S][SUM] + QUI [C] > cp_k409ha [S][SUM]
  /CATEGORIES VARIABLES=ORG [1] EMPTY=INCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE PLANTADA (ha) SEGN USO DE INSUMOS ORGNICOS O QUMICOS'  'Cultivos Permanentes'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 12. SUPERFICIE PLANTADA EN CULTIVOS PERMANENTES POR CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET ACTIVATE permanentes.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

RECODE rc_clacul (407 = 1) (411 = 2) (419 = 3) (456 = 4) (ELSE = 5) INTO Permanentes_12.
VALUE LABELS Permanentes_12 1'Banano (fruta fresca)' 2'Cacao (almendra seca)' 3'Caa de azcar para azcar' 4'Palma africana (fruta fresca)' 5'Otros permanentes'.

FILTER BY cultiv_perm.

WEIGHT BY fact_exp_fin.

***** TABLA 12. SUPERFICIE PLANTADA EN CULTIVOS PERMANENTES POR CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

CTABLES
  /VLABELS VARIABLES=Permanentes_12 ORG cp_k409ha QUI DISPLAY=LABEL
  /TABLE Permanentes_12 [C] BY ORG [C] > cp_k409ha [S][SUM] + QUI [C] > cp_k409ha [S][SUM]
  /CATEGORIES VARIABLES=Permanentes_12 EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=ORG [1] EMPTY=INCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE PLANTADA (ha) EN CULTIVOS PERMANENTES POR CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS'
    'Cultivos Permanentes'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

*** GUARDAR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

***** TABLA 37.1 SUPERFICIE AGROPECUARIA BAJO RIEGO EN CULTIVOS PERMANENTES.

CTABLES
  /VLABELS VARIABLES=cp_riego cp_k409ha DISPLAY=LABEL
  /TABLE cp_riego BY cp_k409ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=cp_riego ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO EN CULTIVOS PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

WEIGHT OFF.
FILTER OFF.
USE ALL.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 38. SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO Y SEGN TIPO DE CULTIVO.

* TABLA 38.1 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN CULTIVOS PERMANENTES.

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

DATASET ACTIVATE permanentes.

FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE sup_riego_surc = cp_porc_surc * cp_k409ha / 100. /* Superficie de cultivos permanentes regada por surcos-inundacin.
COMPUTE sup_riego_aspe = cp_porc_aspe * cp_k409ha / 100.  /* Superficie de cultivos permanentes regada por aspersin.
COMPUTE sup_riego_micr = cp_porc_micr * cp_k409ha / 100.  /* Superficie de cultivos permanentes regada por microaspersin.
COMPUTE sup_riego_gote = cp_porc_gote * cp_k409ha / 100.  /* Superficie de cultivos permanentes regada por goteo.
COMPUTE sup_riego_nebu = cp_porc_nebu * cp_k409ha / 100. /* Superficie de cultivos permanentes regada por nebulizacin.
COMPUTE sup_riego_otro = cp_porc_otro * cp_k409ha / 100.  /* Superficie de cultivos permanentes regada por otra tecnologa.
EXECUTE.

WEIGHT BY fact_exp_fin. /* Toda superficie debe expandirse con este factor de expansin.

FILTER BY cultiv_perm_riego.

***** TABLA 38.1 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN CULTIVOS PERMANENTES.

CTABLES
  /VLABELS VARIABLES=sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro cp_riego 
    DISPLAY=LABEL
  /TABLE sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [SUM] + sup_riego_otro [SUM] BY cp_riego
  /CATEGORIES VARIABLES=cp_riego [1] EMPTY=INCLUDE
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO, POR MTODO DE RIEGO EN CULTIVOS PERMANENTES'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.


* TABLA 39. SUPERFICIE BAJO RIEGO POR TIPO DE CULTIVO PERMANENTE Y SEGN MTODO DE RIEGO.

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ***.

WEIGHT OFF.
FILTER OFF.
USE ALL.

FILTER BY cultiv_perm.
WEIGHT BY fact_exp_fin.

***** TABLA 39. SUPERFICIE BAJO RIEGO POR TIPO DE CULTIVO PERMANENTE Y SEGN MTODO DE RIEGO.

CTABLES
  /VLABELS VARIABLES=cp_nclavr sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro DISPLAY=LABEL
  /TABLE cp_nclavr[C] BY sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [S][SUM] + sup_riego_otro [SUM]
  /CATEGORIES VARIABLES=Permanentes_12 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='SUPERFICIE BAJO RIEGO, POR TIPO DE CULTIVO PERMANENTE Y SEGN MTODO DE RIEGO'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.
USE ALL.
WEIGHT OFF.

*** ABRIR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav)***.

DATASET ACTIVATE permanentes.

*** CERRAR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ****

DATASET CLOSE transitorios.

FILTER OFF.
USE ALL.
SPLIT FILE OFF.
WEIGHT OFF.

* Transformacin a Kilogramos. Litros - NPK  
* MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (cp_umed_npk_fq = 1).
    COMPUTE NPK_Masa=cp_cantidad_npk_fq * 0.453592.
ELSE IF (cp_umed_npk_fq = 2).
    COMPUTE NPK_Masa=cp_cantidad_npk_fq .
ELSE IF (cp_umed_npk_fq = 3).
    COMPUTE NPK_Masa= cp_cantidad_npk_fq * 45.359237.
ELSE IF (cp_umed_npk_fq = 4).
    COMPUTE NPK_Masa=cp_cantidad_npk_fq * 1000.
ELSE IF (cp_umed_npk_fq = 5).
    COMPUTE NPK_Volum=cp_cantidad_npk_fq .
END IF.

* Transformacin a Kilogramos. Litros -  NITROGENADOS 
* MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (cp_umed_nit_fq = 1).
    COMPUTE Nitr_Masa=cp_cantidad_nit_fq * 0.453592.
ELSE IF (cp_umed_nit_fq = 2).
    COMPUTE Nitr_Masa=cp_cantidad_nit_fq .
ELSE IF (cp_umed_nit_fq = 3).
    COMPUTE Nitr_Masa=cp_cantidad_nit_fq * 45.359237.
ELSE IF (cp_umed_nit_fq = 4).
    COMPUTE Nitr_Masa=cp_cantidad_nit_fq * 1000.
ELSE IF (cp_umed_nit_fq = 5).
    COMPUTE Nitr_Volum=cp_cantidad_nit_fq .
END IF.

* Transformacin a Kilogramos. Litros -  FOSFATADOS 
* MASA - VOLUMEN   /  Kilogramos - Litros"

DO IF (cp_umed_fq = 1).
    COMPUTE Fosf_Masa=cp_cantidad_fq * 0.453592.
ELSE IF (cp_umed_fq = 2).
    COMPUTE Fosf_Masa=cp_cantidad_fq .
ELSE IF (cp_umed_fq = 3).
    COMPUTE Fosf_Masa=cp_cantidad_fq * 45.359237.
ELSE IF (cp_umed_fq = 4).
    COMPUTE Fosf_Masa=cp_cantidad_fq * 1000.
ELSE IF (cp_umed_fq = 5).
    COMPUTE Fosf_Volum=cp_cantidad_fq .
END IF.

* Transformacin a Kilogramos. Litros -  POTASICOS 
*  MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (cp_umed_pot_fq = 1).
    COMPUTE Pot_Masa=cp_cantidad_pot_fq * 0.453592.
ELSE IF (cp_umed_pot_fq = 2).
    COMPUTE Pot_Masa=cp_cantidad_pot_fq .
ELSE IF (cp_umed_pot_fq = 3).
    COMPUTE Pot_Masa=cp_cantidad_pot_fq * 45.359237.
ELSE IF (cp_umed_pot_fq = 4).
    COMPUTE Pot_Masa=cp_cantidad_pot_fq * 1000.
ELSE IF (cp_umed_pot_fq = 5).
    COMPUTE Pot_Volum=cp_cantidad_pot_fq .
END IF.

* Determinacin de filtros para superficies con cantidades positivas de fertilizantes.

WEIGHT OFF.

COMPUTE Fil_NPK_Masa = (NPK_Masa > 0).
COMPUTE Fil_NPK_Volum = (NPK_Volum > 0).
COMPUTE Fil_Nitr_Masa = (Nitr_Masa > 0).
COMPUTE Fil_Nitr_Volum = (Nitr_Volum > 0).
COMPUTE Fil_Fosf_Masa = (Fosf_Masa > 0).
COMPUTE Fil_Fosf_Volum = (Fosf_Volum > 0).
COMPUTE Fil_Pot_Masa = (Pot_Masa > 0).
COMPUTE Fil_Pot_Volum = (Pot_Volum > 0).

* Determinacin de filtros para unicidad de superficies con cantidades positivas de fertilizantes.

COMPUTE Sup_MASA = (Fil_NPK_Masa | Fil_Nitr_Masa | Fil_Fosf_Masa | Fil_Pot_Masa).
COMPUTE Sup_VOL = (Fil_NPK_Volum | Fil_Nitr_Volum | Fil_Fosf_Volum | Fil_Pot_Volum).

* Determinacin de totales de superficie donde se aplic fertilizantes slidos (masa) y lquidos (volumen).

COMPUTE Suma_Fert_Masa = SUM.1(NPK_Masa, Nitr_Masa, Fosf_Masa, Pot_Masa).
COMPUTE Suma_Fert_Vol = SUM.1(NPK_Volum, Nitr_Volum, Fosf_Volum, Pot_Volum).

* Determinacin de variables contenedoras de los cultivos permanentes para publicacin de intensidades de fertilizantes.

IF (rc_clacul = 402) Cultiv_P = 2.
IF (rc_clacul = 407) Cultiv_P = 3.
IF (rc_clacul = 411) Cultiv_P = 4.
IF (rc_clacul = 416) Cultiv_P = 5.
IF (rc_clacul = 419) Cultiv_P = 6.
IF (rc_clacul = 420) Cultiv_P = 7.
IF (rc_clacul = 440) Cultiv_P = 8.
IF (rc_clacul = 444) Cultiv_P = 9.
IF (rc_clacul = 446) Cultiv_P = 10.
IF (rc_clacul = 450) Cultiv_P = 11.
IF (rc_clacul = 453) Cultiv_P = 12.
IF (rc_clacul = 456) Cultiv_P = 13.
IF (rc_clacul = 457) Cultiv_P = 14.
IF (rc_clacul = 464) Cultiv_P = 15.
IF (rc_clacul = 466) Cultiv_P = 16.
IF (rc_clacul = 472) Cultiv_P = 17.

IF (rc_clacul = 400) Cultiv_P = 18.
IF (rc_clacul = 401) Cultiv_P = 18.
IF RANGE(rc_clacul, 403, 406, 408, 410, 412, 415) Cultiv_P = 18.
IF (rc_clacul = 417) Cultiv_P = 18.
IF (rc_clacul = 418) Cultiv_P = 18.
IF RANGE(rc_clacul, 421, 439, 441, 443) Cultiv_P = 18.
IF (rc_clacul = 445) Cultiv_P = 18.
IF RANGE(rc_clacul, 447, 449) Cultiv_P = 18.
IF (rc_clacul = 451) Cultiv_P = 18.
IF (rc_clacul = 452) Cultiv_P = 18.
IF (rc_clacul = 454) Cultiv_P = 18.
IF (rc_clacul = 455) Cultiv_P = 18.
IF RANGE(rc_clacul, 458, 463) Cultiv_P = 18.
IF (rc_clacul = 465) Cultiv_P = 18.
IF RANGE(rc_clacul, 468, 471, 473, 477, 480, 497) Cultiv_P = 18.
IF (rc_clacul = 499) Cultiv_P = 18.
IF (RANGE(rc_clacul, 400, 499) & ~ANY(rc_clacul, 467, 478, 479, 498)) NACIONAL = 1.

VALUE LABELS Cultiv_P
2"AGUACATE"
3"BANANO"
4"CACAO CCN51 (ALMENDRA SECA)"
5"CAF ARBIGO (GRANO ORO)"
6"CAA DE AZCAR / AZCAR"
7"CAA DE AZCAR / OTROS USOS"
8"LIMON"
9"MANGO"
10"MARACUY"
11"NARANJA"
12"ORITO"
13"PALMA AFRICANA"
14"PALMITO"
15"PIA"
16"PLTANO"
17"TOMATE DE RBOL"
18"OTROS PERMANENTES".
EXECUTE.

WEIGHT BY fact_exp_fin.

* TABLA C. Cantidades de masa (kg) y volumen (l) aplicados a los cultivos permanentes, por ciertos cultivos transitorios y segn clase de fertilizante qumico.

CTABLES
  /VLABELS VARIABLES=NACIONAL Cultiv_P Fil_NPK_Masa NPK_Masa Fil_NPK_Volum NPK_Volum Fil_Nitr_Masa Nitr_Masa Fil_Nitr_Volum Nitr_Volum
    Fil_Fosf_Masa Fosf_Masa Fil_Fosf_Volum Fosf_Volum Fil_Pot_Masa Pot_Masa Fil_Pot_Volum Pot_Volum Suma_Fert_Masa Suma_Fert_Vol DISPLAY=LABEL
  /TABLE NACIONAL + Cultiv_P BY Fil_NPK_Masa > NPK_Masa [SUM] + Fil_NPK_Volum > NPK_Volum [SUM] + Fil_Nitr_Masa > Nitr_Masa [SUM] 
    + Fil_Nitr_Volum > Nitr_Volum [SUM] + Fil_Fosf_Masa > Fosf_Masa [SUM] + Fil_Fosf_Volum > Fosf_Volum [SUM] + Fil_Pot_Masa > Pot_Masa [SUM] 
    + Fil_Pot_Volum > Pot_Volum [SUM] + Suma_Fert_Masa [SUM] + Suma_Fert_Vol [SUM]
  /CATEGORIES VARIABLES=NACIONAL Fil_NPK_Masa Fil_NPK_Volum Fil_Nitr_Masa Fil_Nitr_Volum Fil_Fosf_Masa Fil_Fosf_Volum Fil_Pot_Masa
    Fil_Pot_Volum ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=Cultiv_P ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='MASA (kg) Y VOLUMEN (l) USADOS DE FERTILIZANTES, POR CIERTOS CULTIVOS PERMANENTES Y SEGN CLASE DE FERTILIZANTE QUMICO'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

* TABLA D. Superficie con aplicacin de fertilizantes, por ciertos cultivos permanentes y segn clase de fertilizante qumico (en masa y volumen).

CTABLES
  /VLABELS VARIABLES=NACIONAL Cultiv_P cp_k409ha Fil_NPK_Masa Fil_NPK_Volum Fil_Nitr_Masa Fil_Nitr_Volum Fil_Fosf_Masa Fil_Fosf_Volum
    Fil_Pot_Masa Fil_Pot_Volum Sup_MASA Sup_VOL DISPLAY=LABEL
  /TABLE NACIONAL [C] + Cultiv_P [C] BY cp_k409ha [SUM] > (Fil_NPK_Masa [C] + Fil_NPK_Volum [C] + Fil_Nitr_Masa [C] + Fil_Nitr_Volum [C]
   + Fil_Fosf_Masa [C] + Fil_Fosf_Volum [C] + Fil_Pot_Masa [C] + Fil_Pot_Volum [C] + Sup_MASA + Sup_VOL)
  /CATEGORIES VARIABLES=NACIONAL Fil_NPK_Masa Fil_NPK_Volum Fil_Nitr_Masa Fil_Nitr_Volum Fil_Fosf_Masa Fil_Fosf_Volum Fil_Pot_Masa
   Fil_Pot_Volum Sup_MASA Sup_VOL ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=Cultiv_P ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE CON APLICACIN DE FERTILIZANTES, POR CIERTOS CULTIVOS PERMANENTES Y SEGN CLASE DE FERTILIZANTE QUMICO' '(ha)'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

* ############################################################################################################
*** NOTA IMPORTANTE: PARA OBTENER LA TABLA 49, SE DEBE DIVIDIR (CELDA A CELDA) LA TABLA C PARA LA TABLA D.
* ############################################################################################################

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

*** GUARDAR BASE DE CULTIVOS PERMANENTES (cpnac2020.sav) ****






