* Encoding: UTF-8.

**************************************************************************************************************
*** SINTAXIS PARA EL CLCULO DE LOS ESTADSTICOS, TABULADOS E INDICADORES CULTIVOS TRANSITORIOS
*** DEL MDULO DE INFORMACIN AMBIENTAL EN AGRICULTURA DE LA ENCUESTA
*** DE SUPERFICIE Y PRODUCCIN AGROPECUARIA CONTINUA - ESPAC 2020.
*** REALIZADA POR: RAMIRO BENAVIDES - DEAGA.
*** 02 DE MAYO DE 2016
*** ACTUALIZACIN: CARLOS PILATAXI - DEAGA - 2021***  
**************************************************************************************************************

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.

WEIGHT OFF.
FILTER OFF.
COMPUTE cultiv_tran = (rc_clacul >= 500 & rc_clacul <= 599). /* Los cultivos transitorios estn en este rango de productos. 
FREQUENCIES cultiv_tran.

USE ALL.
FILTER BY cultiv_tran.
WEIGHT BY fact_exp_fin.

DESCRIPTIVES VARIABLES=ct_k510ha
  /STATISTICS=MEAN SUM STDDEV MIN MAX.

*** Se obtuvo 957.371 ha de cultivos transitorios_2020.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

RENAME VARIABLES (superdida = ct_superdida).

FREQUENCIES ct_nuevacondicion. /* Condicin del cultivo transitorio: 1 = Solo; 2 = Asociado; 3 = Invernadero.
VALUE LABELS ct_k512 1'Sequa' 2'Helada' 3'Plagas' 4'Enfermedades' 5'Inundacin' 6'Otra'.
FREQUENCIES ct_k512. /* Razn principal de prdida: 1 = Sequa; 2 = Helada; 3 = Plagas; 4 = Enfermedades; 5 = Inundacin; 6 = Otra.

WEIGHT BY fact_exp_fin.

***** TABLA 2. SUPERFICIE PERDIDA EN CULTIVOS TRANSITORIOS, POR FORMA DE SIEMBRA O PLANTACIN Y SEGN DIFERENTES CAUSAS DE PRDIDA

FILTER BY cultiv_tran.

CTABLES
  /VLABELS VARIABLES=ct_nuevacondicion ct_k512 ct_superdida DISPLAY=LABEL
  /TABLE ct_nuevacondicion BY ct_k512 > ct_superdida [SUM, ROWPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=ct_nuevacondicion ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=ct_k512 [1, 2, 3, 4, 5, 6] EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE=' SUPERFICIE PERDIDA EN CULTIVOS TRANSITORIOS, POR FORMA DE SIEMBRA O PLANTACIN Y SEGN DIFERENTES CAUSAS DE PRDIDA'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 3. SUPERFICIE DONDE SE PRACTIC LA QUEMA EN EL TERRENO PARA LA PREPARACIN DEL SUELO EN CULTIVOS TRANSITORIOS.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FREQUENCIES ct_k510ha. /* Superficie sembrada (ha) en cultivos transitorios.
FREQUENCIES ct_prepa_suelo. /* Terrenos donde se practic la quema para la preparacin del suelo.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 3. SUPERFICIE DONDE SE PRACTIC LA QUEMA EN EL TERRENO PARA LA PREPARACIN DEL SUELO EN CULTIVOS TRANSITORIOS.

CTABLES
  /VLABELS VARIABLES=ct_prepa_suelo ct_k510ha DISPLAY=LABEL
  /TABLE ct_prepa_suelo BY ct_k510ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=ct_prepa_suelo ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
   /TITLES
    TITLE=' SUPERFICIE DONDE SE PRACTIC LA QUEMA EN EL TERRENO PARA LA PREPARACIN DEL SUELO EN CULTIVOS TRANSITORIOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.

**** TABLA 3.1. SUPERFICIE DONDE SE PRACTIC LA QUEMA EN EL TERRENO PARA LA PREPARACIN DEL SUELO EN CULTIVOS TRANSITORIOS POR PROVINCIA.

DATASET ACTIVATE ctnac2020.sav.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=ual_prov ct_k510ha ct_prepa_suelo DISPLAY=LABEL
  /TABLE ual_prov [C] BY ct_k510ha [S][SUM] > ct_prepa_suelo [C]
  /CATEGORIES VARIABLES=ual_prov ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=ct_prepa_suelo ORDER=A KEY=VALUE EMPTY=EXCLUDE.



**** TABLA 3.2. SUPERFICIE DONDE SE PRACTIC LA QUEMA EN EL TERRENO PARA LA PREPARACIN DEL SUELO EN CULTIVOS TRANSITORIOS POR CULTIVO.


FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=ct_nclavr ct_k510ha ct_prepa_suelo DISPLAY=LABEL
  /TABLE ct_nclavr [C] BY ct_k510ha [S][SUM] > ct_prepa_suelo [C]
  /CATEGORIES VARIABLES=ct_nclavr ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=ct_prepa_suelo ORDER=A KEY=VALUE EMPTY=EXCLUDE.


*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 4. SUPERFICIE SEMBRADA EN CULTIVOS TRANSITORIOS, POR TIPO DE MAQUINARIA USADA PARA LA PREPARACIN DEL SUELO.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FREQUENCIES ct_presueuti. /* Tipo de maquinaria usada para la preparacin del suelo.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 4. SUPERFICIE SEMBRADA EN CULTIVOS TRANSITORIOS, POR TIPO DE MAQUINARIA USADA PARA LA PREPARACIN DEL SUELO.

CTABLES
  /VLABELS VARIABLES=ct_presueuti ct_k510ha DISPLAY=LABEL
  /TABLE ct_presueuti BY ct_k510ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=ct_presueuti ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
   /TITLES
    TITLE=' SUPERFICIE SEMBRADA EN CULTIVOS TRANSITORIOS, POR TIPO DE MAQUINARIA USADA PARA LA PREPARACIN DEL SUELO'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.

* TABLA 6. SUPERFICIE SEMBRADA POR FORMA DE SIEMBRA O PLANTACIN Y SEGN TIPO DE SEMILLA USADA EN CULTIVOS TRANSITORIOS
*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav)  ***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FREQUENCIES ct_k506. /* Semilla de ms uso: 1 = Comn; 2 = Mejorada; 3 = Certificada; 4 = Hbrida nacional; 5 = Hbrida internacional.

RECODE ct_k506 (SYSMIS = 1) (ELSE = COPY) INTO ct_k506_R.
VALUE LABELS ct_k506_R 1'Comn' 2'Mejorada' 3'Certificada' 4'Hbrida nacional' 5'Hbrida internacional'.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 6. SUPERFICIE SEMBRADA POR FORMA DE SIEMBRA O PLANTACIN Y SEGN TIPO DE SEMILLA USADA EN CULTIVOS TRANSITORIOS.

CTABLES
  /VLABELS VARIABLES=ct_nuevacondicion ct_k506_R ct_k510ha DISPLAY=LABEL
  /TABLE ct_nuevacondicion [C] BY ct_k506_R > ct_k510ha [SUM]
  /CATEGORIES VARIABLES=ct_nuevacondicion ct_k506_R ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=AFTER
   /TITLES
    TITLE='SUPERFICIE SEMBRADA POR FORMA DE SIEMBRA O PLANTACIN Y SEGN TIPO DE SEMILLA USADA EN CULTIVOS TRANSITORIOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 7. SUPERFICIE PLANTADA O SEMBRADA, POR USO DE INSUMOS AGRCOLAS (ORGNICOS Y QUMICOS)

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

***1 RECOD****

RECODE ct_forg (SYSMIS=2) (ELSE=Copy) INTO ct_forg_2.
EXECUTE.

RECODE ct_fqui (SYSMIS=2) (ELSE=Copy) INTO ct_fqui_2.
EXECUTE.

RECODE ct_porg (SYSMIS=2) (ELSE=Copy) INTO ct_porg_2.
EXECUTE.

RECODE ct_pqui (SYSMIS=2) (ELSE=Copy) INTO ct_pqui_2.
EXECUTE.

***2 CALCULAR TABULADO****

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

COMPUTE ORG = ((ct_forg_2 = 1 OR ct_porg_2 = 1) AND (ct_fqui_2 = 2 AND ct_pqui_2 = 2)). /* Uso orgnico puro.
COMPUTE QUI = ((ct_fqui_2 = 1 OR ct_pqui_2 = 1) AND (ct_forg_2 = 2 AND ct_porg_2 = 2)). /* Uso qumico puro.
COMPUTE NIN = (ct_forg_2 = 2 AND ct_porg_2 = 2 AND ct_fqui_2 = 2 AND ct_pqui_2 = 2). /* Uso sin agrosustancias.
COMPUTE TOD = ~(ORG = 1 OR QUI = 1 OR NIN = 1). /* Uso con todas las agrosustancias.
FREQUENCIES ORG QUI NIN TOD.

VARIABLE LABELS ORG "Uso de insumos orgnicos".
VARIABLE LABELS QUI "Uso de insumos qumicos".
VARIABLE LABELS TOD "Uso de insumos orgnicos y qumicos".
VARIABLE LABELS NIN "No usan ningn tipo de insumo".
VALUE LABELS ORG QUI NIN TOD 0'No' 1'S'.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 7B. SUPERFICIE SEMBRADA POR USO DE INSUMOS AGRCOLAS (ORGNICOS Y QUMICOS) EN CULTIVOS TRANSITORIOS.

CTABLES
  /VLABELS VARIABLES=ORG QUI TOD NIN ct_k510ha DISPLAY=LABEL
  /TABLE ORG + QUI + TOD + NIN BY ct_k510ha [SUM]
  /CATEGORIES VARIABLES=ORG [1] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=TOD [1] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=NIN [1] EMPTY=EXCLUDE
  /TITLES
    TITLE='SUPERFICIE SEMBRADA (ha) POR USO DE INSUMOS AGRCOLAS (ORGNICOS Y QUMICOS) EN CULTIVOS TRANSITORIOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.


* TABLA 9. SUPERFICIE SEMBRADA POR CONDICIN DE CULTIVO Y SEGN TIPO DE FERTILIZANTE O FITOSANITARIO EN CULTIVOS TRANSITORIOS.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 9. SUPERFICIE SEMBRADA POR CONDICIN DE CULTIVO Y SEGN TIPO DE FERTILIZANTE O FITOSANITARIO EN CULTIVOS TRANSITORIOS.

CTABLES
  /VLABELS VARIABLES=ct_nuevacondicion ct_k510ha ct_forg_2 ct_fqui_2 ct_porg_2 ct_pqui_2 DISPLAY=LABEL
  /TABLE ct_nuevacondicion [C] BY ct_k510ha [S][SUM] > (ct_forg_2 [C] + ct_fqui_2 [C]) + ct_k510ha [S][SUM] > (ct_porg_2 [C] + ct_pqui_2 [C])
  /CATEGORIES VARIABLES=ct_nuevacondicion ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=ct_forg_2 ct_fqui_2 ct_porg_2 ct_pqui_2 [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE SEMBRADA (ha) POR CONDICIN DE CULTIVO Y SEGN TIPO DE FERTILIZANTE O FITOSANITARIO'  'C. TRANSITORIOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2017-2020'.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 10. SUPERFICIE PLANTADA O SEMBRADA POR TIPO DE CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS
*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 10, FILA 3: SUPERFICIE SEMBRADA (ha) EN CULTIVOS TRANSITORIOS SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

CTABLES
  /VLABELS VARIABLES=ORG ct_k510ha QUI DISPLAY=LABEL
  /TABLE BY ORG [C] > ct_k510ha [S][SUM] + QUI [C] > ct_k510ha [S][SUM]
  /CATEGORIES VARIABLES=ORG [1] EMPTY=INCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE SEMBRADA (ha) SEGN USO DE INSUMOS ORGNICOS O QUMICOS'  'Cultivos Transitorios'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 13. SUPERFICIE SEMBRADA EN CULTIVOS TRANSITORIOS POR CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

RECODE rc_clacul (507 = 1) (548 = 2) (561 = 3) (573 = 4) (ELSE = 5) INTO Transitorios_13.
VALUE LABELS Transitorios_13 1'Arroz (en cscara)' 2'Maz duro seco (grano seco)' 3'Papa (tubrculo fresco)' 4'Soya' 5'Otros transitorios'.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 13. SUPERFICIE SEMBRADA EN CULTIVOS TRANSITORIOS POR CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

CTABLES
  /VLABELS VARIABLES=Transitorios_13 ORG ct_k510ha QUI DISPLAY=LABEL
  /TABLE Transitorios_13 [C] BY ORG [C] > ct_k510ha [S][SUM] + QUI [C] > ct_k510ha [S][SUM]
  /CATEGORIES VARIABLES=Transitorios_13 EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=ORG [1] EMPTY=INCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE SEMBRADA (ha) EN CULTIVOS TRANSITORIOS POR CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS'
    'Cultivos Transitorios'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

*** GUARDAR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

 SECCIN V. AGUA.

* TABLA 37. SUPERFICIE AGROPECUARIA BAJO RIEGO, SEGN TIPO DE CULTIVO

* TABLA 37.2 PARA CULTIVOS TRANSITORIOS NICAMENTE.
*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET NAME ctnac2020.sav.

WEIGHT OFF.
FILTER OFF.
USE ALL.

COMPUTE cultiv_tran_riego = (cultiv_tran = 1 & ct_riego = 1). /* Filtra cultivos transitorios con alguna clase de riego.
FREQUENCIES cultiv_tran_riego.

FILTER BY cultiv_tran.

WEIGHT BY fact_exp_fin.

***** TABLA 37.2 SUPERFICIE AGROPECUARIA BAJO RIEGO EN CULTIVOS TRANSITORIOS.

CTABLES
  /VLABELS VARIABLES=ct_riego ct_k510ha DISPLAY=LABEL
  /TABLE ct_riego BY ct_k510ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=ct_riego ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO EN CULTIVOS TRANSITORIOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

WEIGHT OFF.
FILTER OFF.
USE ALL.

* TABLA 38. SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO Y SEGN TIPO DE CULTIVO.

 TABLA 38.2 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN CULTIVOS TRANSITORIOS.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE sup_riego_surc = ct_porc_surc * ct_k510ha / 100. /* Superficie de cultivos transitorios regada por surcos-inundacin.
COMPUTE sup_riego_aspe = ct_porc_aspe * ct_k510ha / 100.  /* Superficie de cultivos transitorios regada por aspersin.
COMPUTE sup_riego_micr = ct_porc_micr * ct_k510ha / 100.  /* Superficie de cultivos transitorios regada por microaspersin.
COMPUTE sup_riego_gote = ct_porc_gote * ct_k510ha / 100.  /* Superficie de cultivos transitorios regada por goteo.
COMPUTE sup_riego_nebu = ct_porc_nebu * ct_k510ha / 100. /* Superficie de cultivos transitorios regada por nebulizacin.
COMPUTE sup_riego_otro = ct_porc_otro * ct_k510ha / 100.  /* Superficie de cultivos transitorios regada por otra tecnologa.
EXECUTE.

WEIGHT BY fact_exp_fin. /* Toda superficie debe expandirse con este factor de expansin.

FILTER BY cultiv_tran_riego.

***** TABLA 36.2 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN CULTIVOS TRANSITORIOS.

CTABLES
  /VLABELS VARIABLES=sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro ct_riego 
    DISPLAY=LABEL
  /TABLE sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [SUM] + sup_riego_otro [SUM] BY ct_riego
  /CATEGORIES VARIABLES=ct_riego [1] EMPTY=INCLUDE
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO, POR MTODO DE RIEGO EN CULTIVOS TRANSITORIOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.
USE ALL.
WEIGHT OFF.

* TABLA 40. SUPERFICIE BAJO RIEGO, POR TIPO DE CULTIVO TRANSITORIO Y SEGN MTODO DE RIEGO.

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ***.

DATASET ACTIVATE ctnac2020.sav.
WEIGHT OFF.
FILTER OFF.
USE ALL.

FILTER BY cultiv_tran.
WEIGHT BY fact_exp_fin.

***** TABLA 40. SUPERFICIE BAJO RIEGO, POR TIPO DE CULTIVO TRANSITORIO Y SEGN MTODO DE RIEGO.

CTABLES
  /VLABELS VARIABLES=ct_nclavr sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro DISPLAY=LABEL
  /TABLE ct_nclavr [C] BY sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [S][SUM] + sup_riego_otro [SUM]
  /CATEGORIES VARIABLES=Transitorios_13 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='SUPERFICIE BAJO RIEGO, POR TIPO DE CULTIVO TRANSITORIO Y SEGN MTODO DE RIEGO'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

FILTER OFF.
USE ALL.
WEIGHT OFF.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.
***** TABLA 48. INTENSIDAD DE USO DE FERTILIZANTES POR CULTIVOS TRANSITORIOS (kg / ha y l / ha)

*** ABRIR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav)***.

DATASET ACTIVATE ctnac2020.sav.

FILTER OFF.
USE ALL.
SPLIT FILE OFF.
WEIGHT OFF.

* Transformacin a Kilogramos. Litros -  NPK
* MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (ct_umed_npk_fq = 1).
    COMPUTE NPK_Masa=ct_cantidad_npk_fq * 0.453592.
ELSE IF (ct_umed_npk_fq = 2).
    COMPUTE NPK_Masa=ct_cantidad_npk_fq .
ELSE IF (ct_umed_npk_fq = 3).
    COMPUTE NPK_Masa=ct_cantidad_npk_fq * 45.359237.
ELSE IF (ct_umed_npk_fq = 4).
    COMPUTE NPK_Masa=ct_cantidad_npk_fq * 1000.
ELSE IF (ct_umed_npk_fq = 5).
    COMPUTE NPK_Volum=ct_cantidad_npk_fq .
END IF.

* Transformacin a Kilogramos. Litros -  NITROGENADOS 
* MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (ct_umed_nit_fq = 1).
    COMPUTE Nitr_Masa=ct_cantidad_nit_fq * 0.453592.
ELSE IF (ct_umed_nit_fq = 2).
    COMPUTE Nitr_Masa=ct_cantidad_nit_fq .
ELSE IF (ct_umed_nit_fq = 3).
    COMPUTE Nitr_Masa=ct_cantidad_nit_fq * 45.359237.
ELSE IF (ct_umed_nit_fq = 4).
    COMPUTE Nitr_Masa=ct_cantidad_nit_fq * 1000.
ELSE IF (ct_umed_nit_fq = 5).
    COMPUTE Nitr_Volum=ct_cantidad_nit_fq .
END IF.

* Transformacin a Kilogramos. Litros -  FOSFATADOS 
* MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (ct_umed_fq = 1).
    COMPUTE Fosf_Masa=ct_cantidad_fq * 0.453592.
ELSE IF (ct_umed_fq = 2).
    COMPUTE Fosf_Masa=ct_cantidad_fq .
ELSE IF (ct_umed_fq = 3).
    COMPUTE Fosf_Masa=ct_cantidad_fq * 45.359237.
ELSE IF (ct_umed_fq = 4).
    COMPUTE Fosf_Masa=ct_cantidad_fq * 1000.
ELSE IF (ct_umed_fq = 5).
    COMPUTE Fosf_Volum=ct_cantidad_fq .
END IF.

* Transformacin a Kilogramos. Litros -  POTASICOS 
* MASA - VOLUMEN   /  Kilogramos - Litros

DO IF (ct_umed_pot_fq = 1).
    COMPUTE Pot_Masa=ct_cantidad_pot_fq * 0.453592.
ELSE IF (ct_umed_pot_fq = 2).
    COMPUTE Pot_Masa=ct_cantidad_pot_fq .
ELSE IF (ct_umed_pot_fq = 3).
    COMPUTE Pot_Masa=ct_cantidad_pot_fq * 45.359237.
ELSE IF (ct_umed_pot_fq = 4).
    COMPUTE Pot_Masa=ct_cantidad_pot_fq * 1000.
ELSE IF (ct_umed_pot_fq = 5).
    COMPUTE Pot_Volum=ct_cantidad_pot_fq .
END IF.

* Determinacin de filtros para superficies con cantidades positivas de fertilizantes.

WEIGHT OFF.

COMPUTE Fil_NPK_Masa = (NPK_Masa > 0).
COMPUTE Fil_NPK_Volum = (NPK_Volum > 0).
COMPUTE Fil_Nitr_Masa = (Nitr_Masa > 0).
COMPUTE Fil_Nitr_Volum = (Nitr_Volum > 0).
COMPUTE Fil_Fosf_Masa = (Fosf_Masa > 0).
COMPUTE Fil_Fosf_Volum = (Fosf_Volum > 0).
COMPUTE Fil_Pot_Masa = (Pot_Masa > 0).
COMPUTE Fil_Pot_Volum = (Pot_Volum > 0).

* Determinacin de filtros para unicidad de superficies con cantidades positivas de fertilizantes.

COMPUTE Sup_MASA = (Fil_NPK_Masa | Fil_Nitr_Masa | Fil_Fosf_Masa | Fil_Pot_Masa).
COMPUTE Sup_VOL = (Fil_NPK_Volum | Fil_Nitr_Volum | Fil_Fosf_Volum | Fil_Pot_Volum).

* Determinacin de totales de superficie donde se aplic fertilizantes slidos (masa) y lquidos (volumen).

COMPUTE Suma_Fert_Masa = SUM.1(NPK_Masa, Nitr_Masa, Fosf_Masa, Pot_Masa).
COMPUTE Suma_Fert_Vol = SUM.1(NPK_Volum, Nitr_Volum, Fosf_Volum, Pot_Volum).

* Determinacin de variables contenedoras de los cultivos transitorios para publicacin de intensidades de fertilizantes.

IF (rc_clacul = 507) Cultiv_T = 2.
IF (rc_clacul = 509) Cultiv_T = 3.
IF (rc_clacul = 511) Cultiv_T = 4.
IF (rc_clacul = 516) Cultiv_T = 5.
IF (rc_clacul = 519) Cultiv_T = 6.
IF (rc_clacul = 520) Cultiv_T = 7.
IF (rc_clacul = 530) Cultiv_T = 8.
IF (rc_clacul = 532) Cultiv_T = 9.
IF (rc_clacul = 537) Cultiv_T = 10.
IF (rc_clacul = 539) Cultiv_T = 11.
IF (rc_clacul = 547) Cultiv_T = 12.
IF (rc_clacul = 548) Cultiv_T = 13.
IF (rc_clacul = 550) Cultiv_T = 14.
IF (rc_clacul = 551) Cultiv_T = 15.
IF (rc_clacul = 554) Cultiv_T = 16.
IF (rc_clacul = 561) Cultiv_T = 17.
IF (rc_clacul = 567) Cultiv_T = 18.
IF (rc_clacul = 573) Cultiv_T = 19.
IF (rc_clacul = 575) Cultiv_T = 20.
IF (rc_clacul = 576) Cultiv_T = 21.
IF (rc_clacul = 577) Cultiv_T = 22.
IF (rc_clacul = 579) Cultiv_T = 23.

IF RANGE(rc_clacul, 500, 506) Cultiv_T = 24.
IF (rc_clacul = 508) Cultiv_T = 24.
IF (rc_clacul = 510) Cultiv_T = 24.
IF RANGE(rc_clacul, 512, 515) Cultiv_T = 24.
IF (rc_clacul = 517) Cultiv_T = 24.
IF (rc_clacul = 518) Cultiv_T = 24.
IF RANGE(rc_clacul, 521, 529) Cultiv_T = 24.
IF (rc_clacul = 531) Cultiv_T = 24.
IF RANGE(rc_clacul, 533, 536) Cultiv_T = 24.
IF (rc_clacul = 538) Cultiv_T = 24.
IF RANGE(rc_clacul, 540, 546) Cultiv_T = 24.
IF (rc_clacul = 549) Cultiv_T = 24.
IF (rc_clacul = 552) Cultiv_T = 24.
IF (rc_clacul = 553) Cultiv_T = 24.
IF RANGE(rc_clacul, 555, 560, 562, 566) Cultiv_T = 24.
IF RANGE(rc_clacul, 568, 572) Cultiv_T = 24.
IF (rc_clacul = 574) Cultiv_T = 24.
IF (rc_clacul = 578) Cultiv_T = 24.
IF RANGE(rc_clacul, 580, 583) Cultiv_T = 24.
IF RANGE(rc_clacul, 586, 597) Cultiv_T = 24.
IF (rc_clacul = 599) Cultiv_T = 24.

IF (RANGE(rc_clacul, 500, 599) & ~ANY(rc_clacul, 584, 585, 598)) NACIONAL = 1.

VALUE LABELS Cultiv_T
2"ARROZ (EN CSCARA)"
3"ARVEJA SECA (GRANO SECO)"
4"ARVEJA TIERNA (VAINA)"
5"BROCOLI (REPOLLO)"
6"CEBADA (GRANO SECO)"
7"CEBOLLA BLANCA (TALLO FRESCO)"
8"FRJOL SECO (GRANO SECO)"
9"FRJOL TIERNO (VAINA)"
10"HABA SECA (GRANO SECO)"
11"HABA TIERNA (VAINA)"
12"MAZ DURO CHOCLO (CHOCLO)"
13"MAZ DURO SECO (GRANO SECO)"
14"MAZ SUAVE CHOCLO (CHOCLO)"
15"MAZ SUAVE SECO (GRANO SECO)"
16"MAN (GRANO DESCASCARADO)"
17"PAPA"
18"QUINUA"
19"SOYA"
20"TABACO"
21"TOMATE RIN"
22"TRIGO"
23"YUCA"
24"OTROS TRANSITORIOS".
EXECUTE.

WEIGHT BY fact_exp_fin.

* TABLA A. Cantidades de masa (kg) y volumen (l) aplicados a los cultivos transitorios, por ciertos cultivos transitorios y segn clase de fertilizante qumico.

CTABLES
  /VLABELS VARIABLES=NACIONAL Cultiv_T Fil_NPK_Masa NPK_Masa Fil_NPK_Volum NPK_Volum Fil_Nitr_Masa Nitr_Masa Fil_Nitr_Volum Nitr_Volum
    Fil_Fosf_Masa Fosf_Masa Fil_Fosf_Volum Fosf_Volum Fil_Pot_Masa Pot_Masa Fil_Pot_Volum Pot_Volum Suma_Fert_Masa Suma_Fert_Vol DISPLAY=LABEL
  /TABLE NACIONAL + Cultiv_T BY Fil_NPK_Masa > NPK_Masa [SUM] + Fil_NPK_Volum > NPK_Volum [SUM] + Fil_Nitr_Masa > Nitr_Masa [SUM] 
    + Fil_Nitr_Volum > Nitr_Volum [SUM] + Fil_Fosf_Masa > Fosf_Masa [SUM] + Fil_Fosf_Volum > Fosf_Volum [SUM] + Fil_Pot_Masa > Pot_Masa [SUM] 
    + Fil_Pot_Volum > Pot_Volum [SUM] + Suma_Fert_Masa [SUM] + Suma_Fert_Vol [SUM]
  /CATEGORIES VARIABLES=NACIONAL Fil_NPK_Masa Fil_NPK_Volum Fil_Nitr_Masa Fil_Nitr_Volum Fil_Fosf_Masa Fil_Fosf_Volum Fil_Pot_Masa
    Fil_Pot_Volum ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=Cultiv_T ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='MASA (kg) Y VOLUMEN (l) USADOS DE FERTILIZANTES, POR CIERTOS CULTIVOS TRANSITORIOS Y SEGN CLASE DE FERTILIZANTE QUMICO'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

* TABLA B. Superficie con aplicacin de fertilizantes, por ciertos cultivos transitorios y segn clase de fertilizante qumico (en masa y volumen).

CTABLES
  /VLABELS VARIABLES=NACIONAL Cultiv_T ct_k510ha Fil_NPK_Masa Fil_NPK_Volum Fil_Nitr_Masa Fil_Nitr_Volum Fil_Fosf_Masa Fil_Fosf_Volum
    Fil_Pot_Masa Fil_Pot_Volum Sup_MASA Sup_VOL DISPLAY=LABEL
  /TABLE NACIONAL [C] + Cultiv_T [C] BY ct_k510ha [SUM] > (Fil_NPK_Masa [C] + Fil_NPK_Volum [C] + Fil_Nitr_Masa [C] + Fil_Nitr_Volum [C]
   + Fil_Fosf_Masa [C] + Fil_Fosf_Volum [C] + Fil_Pot_Masa [C] + Fil_Pot_Volum [C] + Sup_MASA + Sup_VOL)
  /CATEGORIES VARIABLES=NACIONAL Fil_NPK_Masa Fil_NPK_Volum Fil_Nitr_Masa Fil_Nitr_Volum Fil_Fosf_Masa Fil_Fosf_Volum Fil_Pot_Masa
   Fil_Pot_Volum Sup_MASA Sup_VOL ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=Cultiv_T ORDER=A KEY=VALUE EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE CON APLICACIN DE FERTILIZANTES, POR CIERTOS CULTIVOS TRANSITORIOS Y SEGN CLASE DE FERTILIZANTE QUMICO' '(ha)'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

* ############################################################################################################
*** NOTA IMPORTANTE: PARA OBTENER LA TABLA 48, SE DEBE DIVIDIR (CELDA A CELDA) LA TABLA A PARA LA TABLA B.
* ############################################################################################################

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

*** GUARDAR BASE DE CULTIVOS TRANSITORIOS (ctnac2020.sav) ****

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.











