* Encoding: UTF-8.

**************************************************************************************************************
*** SINTAXIS PARA EL CLCULO DE LOS ESTADSTICOS, TABULADOS E INDICADORES
*** DEL MDULO DE INFORMACIN AMBIENTAL EN AGRICULTURA DE LA ENCUESTA
*** DE SUPERFICIE Y PRODUCCIN AGROPECUARIA CONTINUA - ESPAC 2020.
*** REALIZADA POR: RAMIRO BENAVIDES - DEAGA.
*** 02 DE MAYO DE 2016
*** ACTUALIZACIN: CARLOS PILATAXI - DEAGA - 2021***  
**************************************************************************************************************

*** ABRIR BASE DE PASTOS CULTIVADOS (pcnac2020.sav)***.

DATASET NAME pastos.

WEIGHT OFF.
FILTER OFF.
COMPUTE pastos_cultiv = (rc_clacul >= 751 & rc_clacul <= 780). /* Los pastos cultivados estn en este rango de productos. 
FREQUENCIES pastos_cultiv.

FILTER BY pastos_cultiv.
WEIGHT BY fact_exp_fin.

DESCRIPTIVES VARIABLES=cp_k409ha
  /STATISTICS=MEAN SUM STDDEV MIN MAX.

*** Se obtuvo 2.065.699 ha. de pastos cultivados, EN LA BASE DE PASTOS CULTIVADOS_2020.

*------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 10. SUPERFICIE PLANTADA O SEMBRADA POR TIPO DE CULTIVO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS

*** ABRIR BASE DE PASTOS CULTIVADOS (pcnac2020.sav) ***.

***1 RECOD****

RECODE cp_forg (SYSMIS=2) (ELSE=Copy) INTO cp_forg_2.
EXECUTE.

RECODE cp_fqui (SYSMIS=2) (ELSE=Copy) INTO cp_fqui_2.
EXECUTE.

RECODE cp_porg (SYSMIS=2) (ELSE=Copy) INTO cp_porg_2.
EXECUTE.

RECODE cp_pqui (SYSMIS=2) (ELSE=Copy) INTO cp_pqui_2.
EXECUTE.

***2 CALCULAR TABULADO****

DATASET ACTIVATE pastos.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

COMPUTE ORG = ((cp_forg_2 = 1 OR cp_porg_2 = 1) AND (cp_fqui_2 = 2 AND cp_pqui_2 = 2)). /* Uso orgnico puro.
COMPUTE QUI = ((cp_fqui_2 = 1  OR cp_pqui_2 = 1) AND (cp_forg_2 = 2 AND cp_porg_2 = 2)). /* Uso qumico puro.
COMPUTE NIN = (cp_forg_2 = 2 AND cp_porg_2 = 2 AND cp_fqui_2 = 2 AND cp_pqui_2 = 2). /* Uso sin agrosustancias.
COMPUTE TOD = ~(ORG = 1 OR QUI = 1 OR NIN = 1). /* Uso con todas las agrosustancias.
FREQUENCIES ORG QUI NIN TOD.

VARIABLE LABELS ORG "Uso de insumos orgnicos".
VARIABLE LABELS QUI "Uso de insumos qumicos".
VARIABLE LABELS TOD "Uso de insumos orgnicos y qumicos".
VARIABLE LABELS NIN "No usan ningn tipo de insumo".
VALUE LABELS ORG QUI NIN TOD 0'No' 1'S'.

FILTER BY pastos_cultiv.

WEIGHT BY fact_exp_fin.

***** TABLA 10, FILA 1: SUPERFICIE PLANTADA (ha) EN PASTOS CULTIVADOS SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

CTABLES
  /VLABELS VARIABLES=ORG cp_k409ha QUI DISPLAY=LABEL
  /TABLE BY ORG [C] > cp_k409ha [S][SUM] + QUI [C] > cp_k409ha [S][SUM]
  /CATEGORIES VARIABLES=ORG [1] EMPTY=INCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE PLANTADA (ha) SEGN USO DE INSUMOS ORGNICOS O QUMICOS'  'Pastos Cultivados'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2017-2020'.



*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 11. SUPERFICIE PLANTADA EN PASTOS CULTIVADOS POR TIPO DE PASTO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS

*** ABRIR BASE DE PASTOS CULTIVADOS (pcnac2020.sav) ***.

DATASET ACTIVATE pastos.

FILTER OFF.
USE ALL.
WEIGHT OFF.
SPLIT FILE OFF.

RECODE rc_clacul (767 = 1) (754 = 2) (763 = 3) (752 = 4) (766 = 5) (ELSE = 6) INTO Pastos_11.
VALUE LABELS Pastos_11 1'Saboya' 2'Gramalote' 3'Pasto miel (chilena)' 4'Brachiaria' 5'Raygras' 6'Otros pastos cultivados'.

FILTER BY pastos_cultiv.

WEIGHT BY fact_exp_fin.

***** TABLA 11. SUPERFICIE PLANTADA EN PASTOS CULTIVADOS POR TIPO DE PASTO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS.

CTABLES
  /VLABELS VARIABLES=Pastos_11 ORG cp_k409ha QUI DISPLAY=LABEL
  /TABLE Pastos_11 [C] BY ORG [C] > cp_k409ha [S][SUM] + QUI [C] > cp_k409ha [S][SUM]
  /CATEGORIES VARIABLES=Pastos_11 EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /CATEGORIES VARIABLES=ORG [1] EMPTY=INCLUDE
  /CATEGORIES VARIABLES=QUI [1] EMPTY=INCLUDE
  /TITLES
    TITLE='SUPERFICIE PLANTADA (ha) EN PASTOS CULTIVADOS POR TIPO DE PASTO Y SEGN USO DE INSUMOS ORGNICOS O QUMICOS'
    'Pastos Cultivados'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

*** GUARDAR BASE DE PASTOS CULTIVADOS (pcnac2020.sav) ***.

*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------.

* TABLA 37.3 SUPERFICIE AGROPECUARIA BAJO RIEGO EN PASTOS CULTIVADOS.
*** ABRIR BASE DE PASTOS CULTIVADOS (pcnac2020.sav) ***.

DATASET NAME pastos.

WEIGHT OFF.
FILTER OFF.
USE ALL.

COMPUTE pastos_cultiv_riego = (pastos_cultiv = 1 & cp_riego = 1). /* Filtra pastos cultivados con alguna clase de riego.
FREQUENCIES pastos_cultiv_riego.

FILTER BY pastos_cultiv.

WEIGHT BY fact_exp_fin.

***** TABLA 37.3 SUPERFICIE AGROPECUARIA BAJO RIEGO EN PASTOS CULTIVADOS.

CTABLES
  /VLABELS VARIABLES=cp_riego cp_k409ha DISPLAY=LABEL
  /TABLE cp_riego BY cp_k409ha [SUM, COLPCT.SUM PCT40.1]
  /CATEGORIES VARIABLES=cp_riego ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO EN PASTOS CULTIVADOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2017-2020'.

WEIGHT OFF.
FILTER OFF.
USE ALL.


* TABLA 38.3 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN PASTOS CULTIVADOS.

*** ABRIR BASE DE PASTOS CULTIVADOS (pcnac2020.sav) ***.

DATASET ACTIVATE pastos.

FILTER OFF.
USE ALL.
WEIGHT OFF.

COMPUTE sup_riego_surc = cp_porc_surc * cp_k409ha / 100. /* Superficie de pastos cultivados regada por surcos-inundacin.
COMPUTE sup_riego_aspe = cp_porc_aspe * cp_k409ha / 100.  /* Superficie de pastos cultivados regada por aspersin.
COMPUTE sup_riego_micr = cp_porc_micr * cp_k409ha / 100.  /* Superficie de pastos cultivados regada por microaspersin.
COMPUTE sup_riego_gote = cp_porc_gote * cp_k409ha / 100.  /* Superficie de pastos cultivados regada por goteo.
COMPUTE sup_riego_nebu = cp_porc_nebu * cp_k409ha / 100. /* Superficie de pastos cultivados regada por nebulizacin.
COMPUTE sup_riego_otro = cp_porc_otro * cp_k409ha / 100.  /* Superficie de pastos cultivados regada por otra tecnologa.
EXECUTE.

WEIGHT BY fact_exp_fin. /* Toda superficie debe expandirse con este factor de expansin.

FILTER BY pastos_cultiv.

***** TABLA 38.3 SUPERFICIE BAJO RIEGO, POR MTODO DE RIEGO EN PASTOS CULTIVADOS.

CTABLES
  /VLABELS VARIABLES=sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro cp_riego 
    DISPLAY=LABEL
  /TABLE sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [SUM] + sup_riego_otro [SUM] BY cp_riego
  /CATEGORIES VARIABLES=cp_riego [1] EMPTY=INCLUDE
 /TITLES
    TITLE='SUPERFICIE AGROPECUARIA BAJO RIEGO, POR MTODO DE RIEGO EN PASTOS CULTIVADOS'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

SPLIT FILE OFF.
WEIGHT OFF.

** ABRIR BASE DE PASTOS CULTIVADOS (pcnac2020.sav) ***.

DATASET ACTIVATE pastos.

WEIGHT OFF.
FILTER OFF.
USE ALL.

FILTER BY pastos_cultiv.
WEIGHT BY fact_exp_fin.

***** TABLA 41. SUPERFICIE BAJO RIEGO POR TIPO DE PASTO CULTIVADO Y SEGN MTODO DE RIEGO.

CTABLES
  /VLABELS VARIABLES=Pastos_11 sup_riego_surc sup_riego_aspe sup_riego_micr sup_riego_gote sup_riego_nebu sup_riego_otro DISPLAY=LABEL
  /TABLE Pastos_11 [C] BY sup_riego_surc [SUM] + sup_riego_aspe [SUM] + sup_riego_micr [SUM] + sup_riego_gote [SUM] + sup_riego_nebu [S][SUM] + sup_riego_otro [SUM]
  /CATEGORIES VARIABLES=Pastos_11 ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=AFTER
  /TITLES
    TITLE='SUPERFICIE BAJO RIEGO, POR TIPO DE PASTO CULTIVADO Y SEGN MTODO DE RIEGO'
    CAPTION='Elaboracin: INEC' 'Fuente: Encuesta de Superficie y Produccin Agropecuaria Continua 2020'.

SPLIT FILE OFF.
WEIGHT OFF.




