* Encoding: UTF-8.
*************************************************************************************************************************************************.
******************************INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS****************************************************.
***********************************SINTAXIS CUADROS VEHCULOS**********************************************************************.
*************************************************************************************************************************************************.

**TEMA: TABULADOS VEHCULOS 2018.
**DIRECCIN DE ESTADSTICAS ECONMICAS.
**UNIDAD DE GESTIN DE ESTADSTICAS ESTRUCTURALES - GESE.
**FECHA: 05/09/2019.


**************CUADRO N.- 1.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA SERVICIO DISPLAY=LABEL
  /TABLE PROVINCIA [COUNT F40.0] BY SERVICIO
  /CATEGORIES VARIABLES=PROVINCIA SERVICIO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES 
    POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN USO, ao 2018'
 'POR PROVINCIAS'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 2.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE SERVICIO DISPLAY=LABEL
  /TABLE CLASE BY SERVICIO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE SERVICIO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN USO, ao 2018'
 'POR CLASE'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 3.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MODELO SERVICIO DISPLAY=LABEL
  /TABLE MODELO [C] BY SERVICIO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=SERVICIO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN SERVICIO, ao 2018'
 'POR MODELO'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 4.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA CLASE DISPLAY=LABEL
  /TABLE PROVINCIA [COUNT F40.0] BY CLASE
  /CATEGORIES VARIABLES=PROVINCIA CLASE ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN CLASE, ao 2018'
 'POR PROVINCIA'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 5.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE MODELO DISPLAY=LABEL
  /TABLE CLASE BY MODELO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN MODELO, ao 2018'
 'POR CLASE'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 6.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=MARCA MODELO DISPLAY=LABEL
  /TABLE MARCA BY MODELO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=MARCA ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN MODELO, ao 2018'
 'POR MARCA'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 7.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA MODELO DISPLAY=LABEL
  /TABLE PROVINCIA BY MODELO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=PROVINCIA  EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=MODELO [1, OTHERNM] EMPTY=exclude TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN MODELO, ao 2018'
 'POR PROVINCIA'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 8.

* Tablas personalizadas.

CTABLES
  /VLABELS VARIABLES=MARCA CLASE DISPLAY=BOTH
  /TABLE MARCA [C][COUNT F40.0] BY CLASE [C]
  /CATEGORIES VARIABLES=MARCA ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=CLASE ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN CLASE, ao 2018'
 'POR MARCA'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 9.

***FILTRO PARA VEHCULOS CON PASAJEROS.

USE ALL.
COMPUTE filpasajero=(CLASE= 1  |  CLASE=2  |  CLASE= 5  |  CLASE= 6  |  CLASE= 7  |  CLASE = 11).
VARIABLE LABEL filpasajero 'Filtro de vehculos para capacidad de pasajeros'.
VALUE LABELS filpasajero 0 'Not Selected' 1 'Selected'.
FORMAT filpasajero (f1.0).
FILTER BY filpasajero.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE PASAJEROS ESTRAPASAJERO DISPLAY=LABEL
  /TABLE CLASE [C] BY PASAJEROS [S][SUM] + ESTRAPASAJERO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, OTHERNM] EMPTY=EXCLUDE 
    TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRAPASAJERO [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    POSITION=before
   /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN CAPACIDAD DE PASAJEROS, ao 2018'
 'POR CLASE'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

FILTER OFF.

**************CUADRO N.- 10.

***FILTRO PARA VEHCULOS CON TONELADA.

USE ALL.
COMPUTE filtonelaje=(CLASE= 3  |  CLASE=4  |  CLASE= 8  |  CLASE= 9  | CLASE= 10).
VARIABLE LABEL filtonelaje 'Filtro de vehculos para capacidad de carga'.
VALUE LABELS filtonelaje 0 'Not Selected' 1 'Selected'.
FORMAT filtonelaje (f1.0).
FILTER BY filtonelaje.
EXECUTE.


* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE TONELAJE ESTRATONE DISPLAY=LABEL
  /TABLE CLASE BY TONELAJE [SUM] + ESTRATONE [C][COUNT F40.0]
  /CATEGORIES VARIABLES=CLASE [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, OTHERNM] EMPTY=EXCLUDE 
    TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRATONE [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=EXCLUDE TOTAL=YES 
    POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN CAPACIDAD DE CARGA, ao 2018'
 'POR CLASE'
 '(Nmero y toneladas)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

FILTER OFF.

**************CUADRO N.- 11.

***FILTRO PARA VEHCULOS CON PASAJEROS.

FILTER BY filpasajero.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA ESTRAPASAJERO DISPLAY=LABEL
  /TABLE PROVINCIA BY PASAJEROS [SUM] + ESTRAPASAJERO [C][COUNT F40.0]
  /CATEGORIES VARIABLES=PROVINCIA ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRAPASAJERO [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=exclude TOTAL=YES 
    POSITION=before
   /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN CAPACIDAD DE PASAJEROS, ao 2018'
 'POR PROVINCIA'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

FILTER OFF.

**************CUADRO N.- 12.

***FILTRO PARA VEHCULOS CON TONELADA.

FILTER BY filtonelaje.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA TONELAJE ESTRATONE DISPLAY=LABEL
  /TABLE PROVINCIA [C] BY TONELAJE  [SUM] + ESTRATONE [C][COUNT F40.0]
  /CATEGORIES VARIABLES=PROVINCIA ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=ESTRATONE [1.00, 2.00, 3.00, 4.00, 5.00, OTHERNM] EMPTY=exclude TOTAL=YES 
    POSITION=before
   /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN CAPACIDAD DE CARGA, ao 2018'
 'POR PROVINCIA'
 '(Nmero y toneladas)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

FILTER OFF.

**************CUADRO N.- 13.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PROVINCIA COMBUSTIBLE SERVICIO DISPLAY=BOTH
  /TABLE PROVINCIA > COMBUSTIBLE [C][COUNT F40.0] BY SERVICIO
  /CATEGORIES VARIABLES=PROVINCIA SERVICIO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before 
  /CATEGORIES VARIABLES=COMBUSTIBLE ORDER=A KEY=VALUE EMPTY=exCLUDE
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN USO, ao 2018'
 'POR PROVINCIA Y TIPO DE COMBUSTIBLE'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

**************CUADRO N.- 14.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=CLASE COMBUSTIBLE SERVICIO DISPLAY=BOTH
  /TABLE CLASE > COMBUSTIBLE [C][COUNT F40.0] BY SERVICIO [C]
  /CATEGORIES VARIABLES=CLASE [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, OTHERNM] EMPTY=exclude 
    TOTAL=YES POSITION=before
  /CATEGORIES VARIABLES=COMBUSTIBLE ORDER=A KEY=VALUE EMPTY=exCLUDE
  /CATEGORIES VARIABLES=SERVICIO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=before
  /TITLES TITLE='VEHCULOS MOTORIZADOS MATRICULADOS SEGN USO DE VEHCULO, ao 2018'
 'POR CLASE Y TIPO DE COMBUSTIBLE'
 '(Nmero)'
 CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Agencia Nacional de Trnsito - ANT'.

****ELIMINAMOS VARIABLES FILTRO***.

DELETE VARIABLES filtonelaje filpasajero.
EXECUTE.
