* Encoding: UTF-8.
*************************************************************************************************************************************************.
******************************INSTITUTO NACIONAL DE ESTADSTICA Y CENSOS****************************************************.
***********************************SINTAXIS TABULADOS TRANSPORE MARTIMO****************************************************.
*************************************************************************************************************************************************.

**TEMA: TABULADOS TRANSPORTE MARTIMO 2019.
**DIRECCIN DE ESTADSTICAS ECONMICAS.
**UNIDAD DE GESTIN DE ESTADSTICAS ESTRUCTURALES - GESE.
**FECHA: 06-07-2020.


COMPUTE T=1.
VARIABLE LABELS T 'NMERO DE NAVES ARRIBADAS'.
VARIABLE LEVEL T (SCALE).
EXECUTE.

DO IF (MES_ENTRADA<=12).
COMPUTE ENTRADAS=1.
END IF.
VARIABLE LABELS ENTRADAS 'NMERO DE NAVES ENTRADAS'.
VARIABLE LEVEL ENTRADAS (SCALE).
EXECUTE.

DO IF (MES_SALIDA<=12).
COMPUTE SALIDAS=1.
END IF.
VARIABLE LABELS SALIDAS 'NMERO DE NAVES SALIDAS'.
VARIABLE LEVEL SALIDAS (SCALE).
EXECUTE.

**************CUADRO N.- 51.
* Tablas personalizadas.

CTABLES
  /VLABELS VARIABLES=BANDERA_C PUERTO DISPLAY=LABEL
  /TABLE BANDERA_C [C][COUNT F40.0] BY PUERTO [C] 
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
 /TITLES TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: NAVES ARRIBADAS SEGN PUERTO, ao 2019'
 'POR BANDERAS' 
 '(Nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 52.

***ENTRADA DE NAVES***.
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRN MES_ENTRADA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRN [S][SUM] BY MES_ENTRADA [C]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: TONELAJE DE REGISTRO NETO DE LAS NAVES ENTRADAS SEGN MESES, ao 2019'
'POR PUERTO' 
'(Toneladas mtricas)'
CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

***SALIDA DE NAVES***.
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRN MES_SALIDA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRN [S][SUM] BY MES_SALIDA
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: TONELAJE DE REGISTRO NETO DE LAS NAVES SALIDAS SEGN MESES, ao 2019'
'POR PUERTO' 
'(Toneladas mtricas)'
CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 53.

***ENTRADA DE NAVES***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRB MES_ENTRADA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRB [S][SUM] BY MES_ENTRADA
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: TONELAJE DE REGISTRO BRUTO DE LAS NAVES ENTRADAS SEGN MESES, ao 2019' 
 'POR PUERTO'
 '(Toneladas mtricas)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

***SALIDA DE NAVES***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO TRB MES_SALIDA DISPLAY=LABEL
  /TABLE PUERTO [C] > TRB [SUM] BY MES_SALIDA [C]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: TONELAJE DE REGISTRO BRUTO DE LAS NAVES SALIDAS SEGN MESES, ao 2019' 
 'POR PUERTO'
 '(Toneladas Mtricas)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 54.
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C MES_ENTRADA DISPLAY=LABEL
  /TABLE BANDERA_C BY MES_ENTRADA [C][COUNT F40.0]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
/TITLES TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: NAVES ARRIBADAS SEGN MESES, ao 2019'
'POR BANDERAS' 
'(Nmero)' 
CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 55.

**ENTRADA DE PASAJEROS***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_ENTRADA PASAJ_ENT DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_ENTRADA > PASAJ_ENT [S][SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: PASAJEROS ENTRADOS SEGN MESES, ao 2019'
'POR PUERTO'
'(Nmero)' 
CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

***SALIDA DE PASAJEROS***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_SALIDA PASAJ_SAL DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_SALIDA [C] > PASAJ_SAL [SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: PASAJEROS SALIDOS SEGN MESES, ao 2019'
 'POR PUERTO' 
 '(Nmero)' 
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 56.

***CARGA ENTRADA***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_ENTRADA ETC DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_ENTRADA > ETC [SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_ENTRADA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
   /TITLES TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: TOTAL DE CARGA ENTRADA SEGN MESES, ao 2019'
 'POR PUERTO'
 '(Toneladas Mtricas)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

***CARGA SALIDA***
* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=PUERTO MES_SALIDA STC DISPLAY=LABEL
  /TABLE PUERTO [C] BY MES_SALIDA > STC [SUM]
  /CATEGORIES VARIABLES=PUERTO ORDER=A KEY=VALUE EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /CATEGORIES VARIABLES=MES_SALIDA [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, OTHERNM] EMPTY=INCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: TOTAL DE CARGA SALIDA SEGN MESES, ao 2019' 
 'POR PUERTO'
 '(Toneladas Mtricas)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 57.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019'
 'POR BANDERAS'
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

**************CUADRO N.- 58.

COMPUTE ESMERALDAS=(TRAFICO_C='Internacional' & PUERTO='APE').
VARIABLE LABELS ESMERALDAS 'Filtro para transporte internacional - Puerto de Esmeraldas'.
FILTER by ESMERALDAS.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: AUTORIDAD PORTUARIA DE ESMERALDAS (APE) NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019'
 'POR BANDERAS'
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridad Portuaria de Esmeraldas - 2019'.

FILTER OFF.
DELETE VARIABLES ESMERALDAS.
EXECUTE.

**************CUADRO N.- 59.

COMPUTE MANTA=(TRAFICO_C='Internacional' & PUERTO='APM').
VARIABLE LABELS MANTA 'Filtro para transporte internacional - Puerto de Manta'.
FILTER by MANTA.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: AUTORIDAD PORTUARIA DE MANTA (APM): NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019' 
 'POR BANDERAS' 
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridad Portuaria de Manta - 2019'.

FILTER OFF.
DELETE VARIABLES MANTA.
EXECUTE.

**************CUADRO N.- 60.

COMPUTE GUAYAQUIL=(TRAFICO_C='Internacional' & PUERTO='APG').
VARIABLE LABELS GUAYAQUIL 'Filtro para transporte internacional - Puerto de Guayaquil'.
FILTER by GUAYAQUIL.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL AUTORIDAD PORTUARIA DE GUAYAQUIL (APG): NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019'
 'POR BANDERAS' 
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridad Portuaria de Guayaquil - 2019'.

FILTER OFF.
DELETE VARIABLES GUAYAQUIL.
EXECUTE.

**************CUADRO N.- 61.

COMPUTE BOLIVAR=(TRAFICO_C='Internacional' & PUERTO='APPB').
VARIABLE LABELS BOLIVAR 'Filtro para transporte internacional - Puerto Bolvar'.
FILTER by BOLIVAR.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL - AUTORIDAD PORTUARIA DE PUERTO BOLVAR (APPB): NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019'
 'POR BANDERAS'
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridad Portuaria de Puerto Bolivar - 2019'.

FILTER OFF.
DELETE VARIABLES BOLIVAR.
EXECUTE.

**************CUADRO N.- 62.

COMPUTE BALAO=(TRAFICO_C='Internacional' & PUERTO='SUINBA').
VARIABLE LABELS BALAO 'Filtro para transporte internacional - Superintendencia Petrolera de Balao'.
FILTER by BALAO.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL - SUPERINTENDENCIA PETROLERA DE BALAO (SUINBA): NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019' 
 'POR BANDERAS' 
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Superintendencia petrolera de Balao - 2019'.

FILTER OFF.
DELETE VARIABLES BALAO.
EXECUTE.


**************CUADRO N.- 63.

COMPUTE LIBERTAD=(TRAFICO_C='Internacional' & PUERTO='SUINLI').
VARIABLE LABELS LIBERTAD 'Filtro para transporte internacional - Superintendencia Petrolera de La Libertad'.
FILTER by LIBERTAD.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE='TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL - SUPERINTENDENCIA PETROLERA DE LA LIBERTAD (SUINLI): NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019' 
 'POR BANDERAS'
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Superintendencia petrolera de la Libertad - 2019'.

FILTER OFF.
DELETE VARIABLES LIBERTAD.
EXECUTE.

**************CUADRO N.- 64.

COMPUTE SALITRAL=(TRAFICO_C='Internacional' & PUERTO='SUINSA').
VARIABLE LABELS SALITRAL 'Filtro para transporte internacional - Superintendencia Petrolera El Salitral'.
FILTER by SALITRAL.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=BANDERA_C TRN TRB ETC STC DISPLAY=BOTH
  /TABLE BANDERA_C BY T[COUNT] + TRN [SUM] + TRB [SUM] + ETC [SUM] + STC [SUM]
  /CATEGORIES VARIABLES=BANDERA_C ORDER=D KEY=COUNT EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL - SUPERINTENDENCIA PETROLERA EL SALITRAL (SUINSA): NAVES ARRIBADAS, TONELAJE DE REGISTRO NETO, TONELAJE DE REGISTRO BRUTO, CARGA ENTRADA Y SALIDA, ao 2019' 
 'POR BANDERAS' 
 '(Toneladas y nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Superintendencia petrolera el Salitral - 2019'.

FILTER OFF.
DELETE VARIABLES SALITRAL.
EXECUTE.

**************CUADRO N.- 65.

COMPUTE TCONT_20= SUM.1(ENT_NCONT_20, SAL_NCONT_20).
COMPUTE TCONT_40= SUM.1(ENT_NCONT_40, SAL_NCONT_40).
COMPUTE TCONT= SUM.1(TCONT_20, TCONT_40).
VARIABLE LABELS TCONT_20 'Total nmero de contenedores de 20'.
VARIABLE LABELS TCONT_40 'Total nmero de contenedores de 40'.
VARIABLE LABELS TCONT 'Total nmero de contenedores'.
VARIABLE LEVEL TCONT_20 TCONT_40 TCONT (SCALA).
FORMATS TCONT ENT_NCONT_20 ENT_NCONT_40 SAL_NCONT_20 SAL_NCONT_40 TCONT_20 TCONT_40 (F10.0).
EXECUTE.


USE ALL. 
COMPUTE filter_TCONT=(TCONT<>0). 
VARIABLE LABELS filter_TCONT 'TCONT<>0 (FILTER)'. 
VALUE LABELS filter_TCONT 0 'Not Selected' 1 'Selected'. 
FORMATS filter_TCONT (f1.0). 
FILTER BY filter_TCONT. 
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES=AGENCIA_NAVIERA_C TCONT ENT_NCONT_20 ENT_NCONT_40 SAL_NCONT_20 SAL_NCONT_40 TCONT_20 TCONT_40 DISPLAY=LABEL
  /TABLE AGENCIA_NAVIERA_C BY TCONT [SUM] + ENT_NCONT_20 [SUM] + ENT_NCONT_40 [SUM] + SAL_NCONT_20 [SUM] + SAL_NCONT_40 [SUM] + TCONT_20 [SUM] + TCONT_40 [SUM]
  /CATEGORIES VARIABLES=AGENCIA_NAVIERA_C ORDER=D KEY=SUM (TCONT) EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE 
  /TITLES	TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: CONTENEDORES CON CARGA MOVILIZADA, ao 2019'
 'POR AGENCIAS NAVIERAS' 
 '(Nmero)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

FILTER OFF.


**************CUADRO N.- 66.

USE ALL.
COMPUTE filter_STC=(STC<>0).
VARIABLE LABELS filter_STC 'STC<>0 (FILTER)'.
VALUE LABELS filter_STC 0 'Not Selected' 1 'Selected'.
FORMATS filter_STC (f1.0).
FILTER BY filter_STC.
EXECUTE.

* Tablas personalizadas.
CTABLES
  /VLABELS VARIABLES= STC SAL_TOT_CGEN STCC SAL_TOT_CSOL  SAL_TOT_CLIQ DISPLAY=LABEL
  /TABLE AGENCIA_NAVIERA_C [C] BY STC [S][SUM] + SAL_TOT_CGEN [S][SUM] + STCC [S][SUM] + SAL_TOT_CSOL [S][SUM] + SAL_TOT_CLIQ [S][SUM]
  /CATEGORIES VARIABLES=AGENCIA_NAVIERA_C ORDER=D KEY=SUM (STC) EMPTY=EXCLUDE TOTAL=YES POSITION=BEFORE
  /TITLES	TITLE= 'TRANSPORTE MARTIMO Y FLUVIAL INTERNACIONAL: MOVIMIENTOS DE TIPOS DE CARGA DE EXPORTACIN, ao 2019'
 'POR AGENCIAS NAVIERAS' 
 '(Toneladas mtricas)'
 CAPTION= 'Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
 'Fuente: Autoridades Portuarias y Superintendencias Petroleras - 2019'.

FILTER OFF.

DELETE VARIABLES  T ENTRADAS SALIDAS filter_TCONT filter_STC.
EXECUTE.



