#################################################################################################
###############       INSTITUTO NACIONAL DE ESTADÍSTICA Y CENSOS - INEC           ###############
###############              DIRECCIÓN DE ESTADÍSTICAS ECONÓMICAS                 ###############
###############            REGISTRO ESTADÍSTICO DE EMPRESAS - REEM                ###############
###############                                                                   ###############
############### TABULADOS DEL REGISTRO ESTADÍSTICO DE EMPRESAS, AÑO 2024 ###############           
#################################################################################################
#Elaborada 25-10-2019.
#Actualizado 24-08-2020
#Actualizada 15-10-2020
#Actualizado 20-08-2021
#Actualizado 17-08-2022
#Actualizado 12-10-2022
#Actualizado 10-12-2022
#Actualizado 17-03-2023
#Actualizado 17-10-2023
#Actualizado 21-03-2024
#Actualizado 20-09-2024
#Actualizado 24-12-2024
#Actualizado 25-03-2025
#Actualizado 01/09/2025

#Requerimientos##################################################################################
#Es necesario crear un proyecto dentro del mismo deberán estar los siguientes archivos:
#FORMATO SPSS: BASES DE DATOS PUBLICADAS: "EMPRESAS_periodo_2006_2011"
#                                         "EMPRESAS_periodo_2012_2023"
#                                         "EMPRESAS_periodo_2024"


#FORMATO EXCEL: CATÁLOGO : "reem_catalogo.xlsx"
#               PLANTILLA EN BLANCO: "Tabulados_REEM_2024"
#FORMATO R : SCRIPT_TABULADOS_REEM_2024
#################################################################################################

#librerías y paquetes#
library(dplyr)
library(openxlsx)
library(reshape2)
library(foreign)
library(data.table)
library(writexl)
#install.packages("zipR")
library(zipR)

# Limpiar objetos de ser necesario
rm(list = ls()) #Borra objetos
inicio <- Sys.time()

####################################### BASE DE DATOS ##########################################
#Aumentar la capacidad de almacenamiento
memory.limit(size=56000)

#Lectura de la base de 

######BASE DE DATOS 2012_2023###################
bd_reem3 <- read.spss("EMPRESAS_periodo_2012_2023.sav",use.value.labels=F,to.data.frame = T)

######BASE DE DATOS 2006_2011
bd_reem1 <- read.spss("EMPRESAS_periodo_2006_2011.sav",use.value.labels=F,to.data.frame = T)

######BASE DE DATOS 2024###################
bd_reem2 <- read.spss("EMPRESAS_periodo_2024.sav",use.value.labels=F,to.data.frame = T)

#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reem <- bd_reem2%>% filter(anio == 2024)

###########Formato / color####################
newStyle <- createStyle(fgFill = "#FFFFFF") #blanco
purpleStyle <- createStyle(fgFill = "#644ea2") #purpura

####################################### FUNCIONES ##############################################

#########1.1 SECCIÓN I: número de empresas##################

################TABULADO 1.1.1###############################
###EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL,             ###
###AÑO 2024 POR ESTRUCTURA PARA ESTRATIFICACIÓN       ###

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(estructura_estrat, anio, situacion)

#Cálculo de las variables.
t_estrato <- df1 %>% group_by(estructura_estrat) %>% summarise("total_estrato"=n(), porcentaje = 0)
total <- as.numeric(sum(t_estrato$total_estrato,na.rm =T ))
t_estrato$porcentaje <- t_estrato$total_estrato / total

#Lectura catálogo de variables.
des_estrato <- read.xlsx("reem_catalogo.xlsx", sheet = "estructura_estratificacion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_estrato,t_estrato, by.x = "CODIGO", by.y = "estructura_estrat", all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION, total_estrato, porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
wb1<-loadWorkbook(file = "Tabulados_reem_2024.xlsx")
writeData(wb1,sheet = "1.1.1","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.1",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.1",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.1",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.1",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_estrato, total, des_estrato, dft2, dft3, t_estrato1)

####################TABULADO 1.1.2 ##################################

###TOTAL EMPRESAS (UNIVERSO REEM), PERIODO 2012 - 2024 POR AÑO###

#Total empresas del año 2012-2023
total_anios <- bd_reem3 %>% group_by(anio) %>% summarise("total_anios"=n())

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.2",total_anios, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.1.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.2",purpleStyle,cols= 1:2, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(total_anios)

#Total empresas del año 2024
total_anios <- bd_reem %>% group_by(anio) %>% summarise("total_anios"=n())

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.2",total_anios, startCol = 1,startRow = 19,colNames = F) ##escribir
addStyle(wb1,"1.1.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.2",purpleStyle,cols= 1:2, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(total_anios)

#####################TABULADO 1.1.3###################################
#EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024#
#               POR FORMA INSTITUCIONAL 	                       #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(forma_institucional,anio,situacion)

#cálculo de las variables
t_formainstitucional <- df1 %>% group_by(forma_institucional) %>% summarise("total_formainstitucional"=n(),porcentaje = 0)
total <- sum(t_formainstitucional$total_formainstitucional,na.rm =T )
t_formainstitucional$porcentaje <- t_formainstitucional$total_formainstitucional / total

#Lectura catálogo de variables.
des_formainstitucional <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_formainstitucional,t_formainstitucional,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_formainstitucional,porcentaje)
t_estrato2 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.3","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.3",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.3",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.3",t_estrato2,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.3",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.3",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_formainstitucional, total, des_formainstitucional, dft2, dft3, t_estrato2)

#########################TABULADO 1.1.4#################################
#EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024##
#                    POR TAMAÑO DE EMPRESA                       #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(tamanoe_plazas,anio,situacion)

#Cálculo de las variables.
t_tamano <- df1 %>% group_by(tamanoe_plazas) %>% summarise("total_tamano"=n(),porcentaje = 0)
total <- sum(t_tamano$total_tamano,na.rm =T )
t_tamano$porcentaje <- t_tamano$total_tamano / total

#Lectura catálogo de variables.
des_tamano <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamano,t_tamano,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_tamano,porcentaje)
t_estrato3 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.4","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.4",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.4",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.4",t_estrato3,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.4",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.4",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.4",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_tamano, total, des_tamano, dft2, dft3, t_estrato3)

#########################TABULADO 1.1.5#################################
#EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024##
#                    POR TAMAÑO DE EMPRESA  (COP)               #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(tamano_cop,anio,situacion)

#Cálculo de las variables.
t_tamano1 <- df1 %>% group_by(tamano_cop) %>% summarise("total_tamano"=n(),porcentaje = 0)
total <- sum(t_tamano1$total_tamano,na.rm =T )
t_tamano1$porcentaje <- t_tamano1$total_tamano / total

#Lectura catálogo de variables.
des_tamano1 <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamano1,t_tamano1,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_tamano,porcentaje)
t_estrato4 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.5","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.5",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.5",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.5",t_estrato4,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.5",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.5",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.5",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_tamano1, total, des_tamano1, dft2, dft3, t_estrato4)

#########################TABULADO 1.1.6#################################
# EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024 #
#                    POR SECTOR ECONÓMICO                          #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,anio,situacion)

#Cálculo de las variables.
t_sectores <- df1 %>% group_by(gsectores) %>% summarise("total_sectores"=n(),porcentaje = 0)
total <- sum(t_sectores$total_sectores,na.rm =T )
t_sectores$porcentaje <- t_sectores$total_sectores / total

#Lectura catálogo de variables.
des_sectores <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectores,t_sectores,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_sectores,porcentaje)
t_estrato4 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.6","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.6",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.6",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.6",t_estrato4,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.6",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.6",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectores, total, des_sectores, dft2, dft3, t_estrato4)

#########################TABULADO 1.1.7#################################
#  EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024#
#                POR ACTIVIDAD ECONÓMICA                          #  

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_seccion,anio,situacion)

#Cálculo de las variables.
t_seccion <- df1 %>% group_by(codigo_seccion) %>% summarise("total_seccion"=n(),porcentaje = 0)
total <- sum(t_seccion$total_seccion,na.rm =T )
t_seccion$porcentaje <- t_seccion$total_seccion / total

#Lectura catálogo de variables.
des_seccion <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccion,t_seccion,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_seccion,porcentaje)
t_estrato5 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.7","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.7",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.7",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.7",t_estrato5,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.7",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.7",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_seccion, total, des_seccion, dft2, dft3, t_estrato5)

#########################TABULADO 1.1.8################################
# EMPRESAS SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024#
#                     POR PROVINCIA                              #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_provincia,anio,situacion)

#Cálculo de las variables.
t_provincia <- df1 %>% group_by(codigo_provincia) %>% summarise("total_provincia"=n(),porcentaje = 0)
total <- sum(t_provincia$total_provincia,na.rm =T )
t_provincia$porcentaje <- t_provincia$total_provincia / total

##lectura de excel para llenar###
des_provincia <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provincia,t_provincia,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_provincia,porcentaje)
t_estrato6 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.1.8","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.1.8",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.8",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.1.8",t_estrato6,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.1.8",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.1.8",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provincia, total, des_provincia, dft2, dft3, t_estrato6)

#########1.2 SECCIÓN II: ventas##################

###################TABULADO 1.2.1###############################
#      VENTAS TOTALES (UNIVERSO REEM), PERIODO 2009 - 2024 #
#                    POR AÑO                               #

# Lectura de base 2009-2011

bd_reemventas <- bd_reem1 %>% select(ventas_totales,anio,situacion,exportaciones_netas,ventas_nacionales)
d_reemven <- bd_reemventas %>% filter (anio != 2006 & anio != 2007 & anio != 2008)

#VENTAS TOTALES#
#Total empresas del año 2009-2011#
t_ventas1 <- d_reemven %>% group_by(anio) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas1, startCol = 1,startRow = 7,colNames = F) ##escribir

#VENTAS NACIONALES#
#total empresas del año 2009 - 2011#
t_vntanacional1 <- d_reemven %>% group_by(anio) %>% summarise ("total_ventanacional"=sum(ventas_nacionales,na.rm=T))
t_vntanacional2 <- t_vntanacional1 %>% select(total_ventanacional)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_vntanacional2, startCol = 3,startRow = 7,colNames = F) ##escribir

#EXPORTACIONES#
#total empresas de los años 2009 - 2011#
t_exportaciones1 <- d_reemven %>% group_by(anio) %>% summarise ("total_exportaciones"=sum(exportaciones_netas,na.rm=T))
t_exportaciones2 <- t_exportaciones1 %>% select(total_exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_exportaciones2, startCol = 4,startRow = 7,colNames = F) ##escribir

#Lectura de la base de datos 2012-2023
bd_reem4 <- bd_reem3 %>% select(ventas_totales,anio,situacion,exportaciones_netas,ventas_nacionales)
bd_reemac2 <- bd_reem4 %>% filter (situacion == 1)

#Total empresas del año 2012-2023
t_ventas2 <- bd_reemac2 %>% group_by(anio) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas2, startCol = 1,startRow = 10,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS NACIONALES#
#total empresas del año 2012 - 2023#
t_vntanacional11 <- bd_reemac2 %>% group_by(anio) %>% summarise ("total_ventanacional"=sum(ventas_nacionales,na.rm=T))
t_vntanacional22 <- t_vntanacional11 %>% select(total_ventanacional)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_vntanacional22, startCol = 3,startRow = 10,colNames = F) ##escribir

#EXPORTACIONES#
#total empresas del año 2012 - 2023#
t_exportaciones11 <- bd_reemac2 %>% group_by(anio) %>% summarise ("total_exportaciones"=sum(exportaciones_netas,na.rm=T))
t_exportaciones22 <- t_exportaciones11 %>% select(total_exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_exportaciones22, startCol = 4,startRow = 10,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#Lectura de la base de datos 2022
bd_reem6 <- bd_reem3 %>% select(ventas_totales,anio,situacion,exportaciones_netas,ventas_nacionales,ventas_rimpe,ventas_totales_rimpe)
bd_reemac6 <- bd_reem6 %>% filter (situacion == 1)
bd_reemac6 <- bd_reem6 %>% filter (anio == 2022)

#VENTAS RIMPE#
#Total empresas del año 2022
t_ventas7 <- bd_reemac6 %>% group_by(anio) %>% summarise ("ventas_rimpe"=sum(ventas_rimpe,na.rm=T))
t_ventas9 <- t_ventas7 %>% select(ventas_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas9, startCol = 5,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS TOTALES RIMPE#
#Total empresas del año 2022
t_ventas8 <- bd_reemac6 %>% group_by(anio) %>% summarise ("ventas_totales_rimpe"=sum(ventas_totales_rimpe,na.rm=T))
t_ventas10 <- t_ventas8 %>% select(ventas_totales_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas10, startCol = 6,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reem6, bd_reemac6, t_ventas7, t_ventas9, t_ventas8, t_ventas10)

#Lectura de la base de datos 2023
bd_reem6 <- bd_reem3 %>% select(ventas_totales,anio,situacion,exportaciones_netas,ventas_nacionales,ventas_rimpe,ventas_totales_rimpe)
bd_reemac6 <- bd_reem6 %>% filter (situacion == 1)
bd_reemac6 <- bd_reem6 %>% filter (anio == 2023)

#VENTAS RIMPE#
#Total empresas del año 2023
t_ventas7 <- bd_reemac6 %>% group_by(anio) %>% summarise ("ventas_rimpe"=sum(ventas_rimpe,na.rm=T))
t_ventas9 <- t_ventas7 %>% select(ventas_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas9, startCol = 5,startRow = 21,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS TOTALES RIMPE#
#Total empresas del año 2023
t_ventas8 <- bd_reemac6 %>% group_by(anio) %>% summarise ("ventas_totales_rimpe"=sum(ventas_totales_rimpe,na.rm=T))
t_ventas10 <- t_ventas8 %>% select(ventas_totales_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas10, startCol = 6,startRow = 21,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reem6, bd_reemac6, t_ventas7, t_ventas9, t_ventas8, t_ventas10)

#Lectura de la base de datos 2024
bd_reem7 <- bd_reem %>% select(ventas_totales,anio,situacion,exportaciones_netas,ventas_nacionales,ventas_rimpe,ventas_totales_rimpe)
bd_reemac7 <- bd_reem7 %>% filter (situacion == 1)

#Total empresas del año 2024
t_ventas7 <- bd_reemac7 %>% group_by(anio) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas7, startCol = 1,startRow = 22,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS NACIONALES#
#total empresas del año 2024#
t_vntanacional14 <- bd_reemac7 %>% group_by(anio) %>% summarise ("total_ventanacional"=sum(ventas_nacionales,na.rm=T))
t_vntanacional25 <- t_vntanacional14 %>% select(total_ventanacional)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_vntanacional25, startCol = 3,startRow = 22,colNames = F) ##escribir

#EXPORTACIONES#
#total empresas del año 2024#
t_exportaciones29 <- bd_reemac7 %>% group_by(anio) %>% summarise ("total_exportaciones"=sum(exportaciones_netas,na.rm=T))
t_exportaciones30 <- t_exportaciones29 %>% select(total_exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_exportaciones30, startCol = 4,startRow = 22,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS RIMPE#
#Total empresas del año 2024
t_ventas11 <- bd_reemac7 %>% group_by(anio) %>% summarise ("ventas_rimpe"=sum(ventas_rimpe,na.rm=T))
t_ventas12 <- t_ventas11 %>% select(ventas_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas12, startCol = 5,startRow = 22,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS TOTALES RIMPE#
#Total empresas del año 2024
t_ventas13 <- bd_reemac7 %>% group_by(anio) %>% summarise ("ventas_totales_rimpe"=sum(ventas_totales_rimpe,na.rm=T))
t_ventas14 <- t_ventas13 %>% select(ventas_totales_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.1",t_ventas14, startCol = 6,startRow = 22,colNames = F) ##escribir
addStyle(wb1,"1.2.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.1",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemventas, d_reemven, t_ventas1, t_vntanacional1, t_vntanacional2, t_exportaciones1, t_exportaciones2)
rm(bd_reem4, bd_reemac2, t_ventas2, t_vntanacional11, t_vntanacional22, t_exportaciones11, t_exportaciones22)
rm(t_ventas7, bd_reem7, bd_reemac7)
rm(t_vntanacional14, t_vntanacional25, t_exportaciones29, t_exportaciones30, t_ventas11, t_ventas12, t_ventas13, t_ventas14)

###############TABULADO 1.2.2 (CONSTANTES)#########################
###VENTAS TOTALES (UNIVERSO REEM), PERIODO 2009 - 2024 POR AÑO

#lectura de base 2009
bd_reemventas3 <- bd_reem1 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven3 <- bd_reemventas3 %>% filter (anio == 2009 )
t_ventas2009 <- d_reemven3 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/79.4102375646185)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2009, startCol = 1,startRow = 7,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2009 <- d_reemven3 %>% summarise ("total_ventas"=sum((ventas_nacionales/79.4102375646185)*100,na.rm=T))
    t_ventanacional09<- t_ventanacional2009 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional09, startCol = 3,startRow = 7,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2009 <- d_reemven3 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/79.4102375646185)*100,na.rm=T))
    t_exportaciones09<- t_exportaciones2009 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones09, startCol = 4,startRow = 7,colNames = F) ##escribir

rm(bd_reemventas3, d_reemven3, t_ventas2009, t_ventanacional2009, t_ventanacional09, t_exportaciones2009, t_exportaciones09)

#lectura de base 2010
bd_reemventas4 <- bd_reem1 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven4 <- bd_reemventas4 %>% filter (anio == 2010 & situacion == 1)
t_ventas2010 <- d_reemven4 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/86.5680541612763)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2010, startCol = 1,startRow = 8,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2010 <- d_reemven4 %>% summarise ("total_ventas"=sum((ventas_nacionales/86.5680541612763)*100,na.rm=T))
    t_ventanacional10<- t_ventanacional2010 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional10, startCol = 3,startRow = 8,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2010 <- d_reemven4 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/86.5680541612763)*100,na.rm=T))
    t_exportaciones10<- t_exportaciones2010 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones10, startCol = 4,startRow = 8,colNames = F) ##escribir

rm (bd_reemventas4, d_reemven4, t_ventas2010, t_ventanacional2010, t_ventanacional10, t_exportaciones2010, t_exportaciones10)

#lectura de base 2011
bd_reemventas5 <- bd_reem1 %>% select(ventas_totales,anio,situacion, ventas_nacionales,exportaciones_netas)
d_reemven5 <- bd_reemventas5 %>% filter (anio == 2011 & situacion == 1)
t_ventas2011 <- d_reemven5 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/92.4871544904257)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2011, startCol = 1,startRow = 9,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2011 <- d_reemven5 %>% summarise ("total_ventas"=sum((ventas_nacionales/92.4871544904257)*100,na.rm=T))
    t_ventanacional11<- t_ventanacional2011 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional11, startCol = 3,startRow = 9,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2011 <- d_reemven5 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/92.4871544904257)*100,na.rm=T))
    t_exportaciones11<- t_exportaciones2011 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones11, startCol = 4,startRow = 9,colNames = F) ##escribir

rm(bd_reemventas5, d_reemven5, t_ventas2011, t_ventanacional2011, t_ventanacional11, t_exportaciones2011, t_exportaciones11)

#lectura de base 2012
bd_reemventas6 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven6 <- bd_reemventas6 %>% filter (anio == 2012 & situacion == 1)
t_ventas2012 <- d_reemven6 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/97.1145052821589)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2012, startCol = 1,startRow = 10,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2012 <- d_reemven6 %>% summarise ("total_ventas"=sum((ventas_nacionales/97.1145052821589)*100,na.rm=T))
    t_ventanacional12<- t_ventanacional2012 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional12, startCol = 3,startRow = 10,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2012 <- d_reemven6 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/97.1145052821589)*100,na.rm=T))
    t_exportaciones12<- t_exportaciones2012 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones12, startCol = 4,startRow = 10,colNames = F) ##escribir

rm(bd_reemventas6, d_reemven6, t_ventas2012, t_ventanacional2012, t_ventanacional12, t_exportaciones2012, t_exportaciones12)    
    
#lectura de base 2013
bd_reemventas7 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven7 <- bd_reemventas7 %>% filter (anio == 2013 & situacion == 1)
t_ventas2013 <- d_reemven7 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/99.704421757685)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2013, startCol = 1,startRow = 11,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2013 <- d_reemven7 %>% summarise ("total_ventas"=sum((ventas_nacionales/99.704421757685)*100,na.rm=T))
    t_ventanacional13<- t_ventanacional2013 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional13, startCol = 3,startRow = 11,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2013 <- d_reemven7 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/99.704421757685)*100,na.rm=T))
    t_exportaciones13<- t_exportaciones2013 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones13, startCol = 4,startRow = 11,colNames = F) ##escribir

rm(bd_reemventas7, d_reemven7, t_ventas2013, t_ventanacional2013, t_ventanacional13, t_exportaciones2013, t_exportaciones13)   

#lectura de base 2014
bd_reemventas8 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven8 <- bd_reemventas8 %>% filter (anio == 2014 & situacion == 1)
t_ventas2014 <- d_reemven8 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/101.75131247565)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2014, startCol = 1,startRow = 12,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2014 <- d_reemven8 %>% summarise ("total_ventas"=sum((ventas_nacionales/101.75131247565)*100,na.rm=T))
    t_ventanacional14<- t_ventanacional2014 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional14, startCol = 3,startRow = 12,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2014 <- d_reemven8 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/101.75131247565)*100,na.rm=T))
    t_exportaciones14<- t_exportaciones2014 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones14, startCol = 4,startRow = 12,colNames = F) ##escribir

rm(bd_reemventas8, d_reemven8, t_ventas2014, t_ventanacional2014, t_ventanacional14, t_exportaciones2014, t_exportaciones14)
    
#lectura de base 2015
bd_reemventas9 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven9 <- bd_reemventas9 %>% filter (anio == 2015 & situacion == 1)
t_ventas2015 <- d_reemven9 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/96.1797845146234)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2015, startCol = 1,startRow = 13,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2015 <- d_reemven9 %>% summarise ("total_ventas"=sum((ventas_nacionales/96.1797845146234)*100,na.rm=T))
    t_ventanacional15<- t_ventanacional2015 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional15, startCol = 3,startRow = 13,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2015 <- d_reemven9 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/96.1797845146234)*100,na.rm=T))
    t_exportaciones15<- t_exportaciones2015 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones15, startCol = 4,startRow = 13,colNames = F) ##escribir

rm(bd_reemventas9, d_reemven9, t_ventas2015, t_ventanacional2015, t_ventanacional15, t_exportaciones2015, t_exportaciones15)
    
#lectura de base 2016
bd_reemventas10 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven10 <- bd_reemventas10 %>% filter (anio == 2016 & situacion == 1)
t_ventas2016 <- d_reemven10 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/97.3061899862597)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2016, startCol = 1,startRow = 14,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2016 <- d_reemven10 %>% summarise ("total_ventas"=sum((ventas_nacionales/97.3061899862597)*100,na.rm=T))
    t_ventanacional16<- t_ventanacional2016 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional16, startCol = 3,startRow = 14,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2016 <- d_reemven10 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/97.3061899862597)*100,na.rm=T))
    t_exportaciones16<- t_exportaciones2016 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones16, startCol = 4,startRow = 14,colNames = F) ##escribir

rm(bd_reemventas10, d_reemven10, t_ventas2016, t_ventanacional2016, t_ventanacional16, t_exportaciones2016, t_exportaciones16)
    
#lectura de base 2017
bd_reemventas101 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven10 <- bd_reemventas101 %>% filter (anio == 2017 & situacion == 1)
t_ventas2017 <- d_reemven10 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/98.2131134656989)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2017, startCol = 1,startRow = 15,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2017 <- d_reemven10 %>% summarise ("total_ventas"=sum((ventas_nacionales/98.2131134656989)*100,na.rm=T))
    t_ventanacional17<- t_ventanacional2017 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional17, startCol = 3,startRow = 15,colNames = F) ##escribir

    #EXPORTACIONES
    t_exportaciones2017 <- d_reemven10 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/98.2131134656989)*100,na.rm=T))
    t_exportaciones17 <- t_exportaciones2017 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones17, startCol = 4,startRow = 15,colNames = F) ##escribir

rm (bd_reemventas101, d_reemven10, t_ventas2017, t_ventanacional2017, t_ventanacional17, t_exportaciones2017, t_exportaciones17)

#lectura de base 2018
bd_reemventas11 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven11 <- bd_reemventas11 %>% filter (anio == 2018 & situacion == 1)
t_ventas2018 <- d_reemven11 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/100)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2018, startCol = 1,startRow = 16,colNames = F) ##escribir

    #VENTAS NACIONALES
    t_ventanacional2018 <- d_reemven11 %>% summarise ("total_ventas"=sum((ventas_nacionales/100)*100,na.rm=T))
    t_ventanacional18<- t_ventanacional2018 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional18, startCol = 3,startRow = 16,colNames = F) ##escribir

    #EXPORTACIONES
    t_exportaciones2018 <- d_reemven11 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/100)*100,na.rm=T))
    t_exportaciones18 <- t_exportaciones2018 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones18, startCol = 4,startRow = 16,colNames = F) ##escribir

rm(bd_reemventas11, d_reemven11, t_ventas2018, t_ventanacional2018, t_ventanacional18, t_exportaciones2018, t_exportaciones18)

#lectura de base 2019
bd_reemventas12 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_reemven12 <- bd_reemventas12 %>% filter (anio == 2019 & situacion == 1)
t_ventas2019 <- d_reemven12 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/99.9434257416061)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2019, startCol = 1,startRow = 17,colNames = F) ##escribir
addStyle(wb1,"1.2.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.2",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES
    t_ventanacional2019 <- d_reemven12 %>% summarise ("total_ventas"=sum((ventas_nacionales/99.9434257416061)*100,na.rm=T))
    t_ventanacional19 <- t_ventanacional2019 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional19, startCol = 3,startRow = 17,colNames = F) ##escribir

    #EXPORTACIONES
    t_exportaciones2019 <- d_reemven12 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/99.9434257416061)*100,na.rm=T))
    t_exportaciones19 <- t_exportaciones2019 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones19, startCol = 4,startRow = 17,colNames = F) ##escribir

rm(bd_reemventas12, d_reemven12, t_ventas2019, t_ventanacional2019, t_ventanacional19, t_exportaciones2019, t_exportaciones19)

###lectura de base 2020###
    bd_reemventas13 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
    d_reemven13 <- bd_reemventas13 %>% filter (anio == 2020 & situacion == 1)
    t_ventas2020 <- d_reemven13 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/98.1185022495001)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas2020, startCol = 1,startRow = 18,colNames = F) ##escribir

    #VENTAS NACIONALES
    t_ventanacional2020 <- d_reemven13 %>% summarise ("total_ventas"=sum((ventas_nacionales/98.1185022495001)*100,na.rm=T))
    t_ventanacional20 <- t_ventanacional2020 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional20, startCol = 3,startRow = 18,colNames = F) ##escribir

    #EXPORTACIONES
    t_exportaciones2020 <- d_reemven13 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/98.1185022495001)*100,na.rm=T))
    t_exportaciones20 <- t_exportaciones2020 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones20, startCol = 4,startRow = 18,colNames = F) ##escribir

rm(bd_reemventas13, d_reemven13, t_ventas2020, t_ventanacional2020, t_ventanacional20, t_exportaciones2020, t_exportaciones20)

###lectura de base 2021###
    bd_reemventas14 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
    d_reemven14 <- bd_reemventas14 %>% filter (anio == 2021 & situacion == 1)
    t_ventas2021 <- d_reemven14 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/100.252328548402)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas2021, startCol = 1,startRow = 19,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2021 <- d_reemven14 %>% summarise ("total_ventas"=sum((ventas_nacionales/100.252328548402)*100,na.rm=T))
    t_ventanacional21 <- t_ventanacional2021 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional21, startCol = 3,startRow = 19,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2021 <- d_reemven14 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/100.252328548402)*100,na.rm=T))
    t_exportaciones21 <- t_exportaciones2021 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones21, startCol = 4,startRow = 19,colNames = F) ##escribir

rm(bd_reemventas14, d_reemven14, t_ventas2021, t_ventanacional2021, t_ventanacional21, t_exportaciones2021, t_exportaciones21)

###lectura de base 2022###
    bd_reemventas15 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas,ventas_rimpe,ventas_totales_rimpe)
    d_reemven15 <- bd_reemventas15 %>% filter (anio == 2022 & situacion == 1)
    t_ventas2022 <- d_reemven15 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/102.606321845514)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas2022, startCol = 1,startRow = 20,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2022 <- d_reemven15 %>% summarise ("total_ventas"=sum((ventas_nacionales/102.606321845514)*100,na.rm=T))
    t_ventanacional22 <- t_ventanacional2022 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional22, startCol = 3,startRow = 20,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2022 <- d_reemven15 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/102.606321845514)*100,na.rm=T))
    t_exportaciones23 <- t_exportaciones2022 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones23, startCol = 4,startRow = 20,colNames = F) ##escribir

    #VENTAS RIMPE#
    t_ventas_rimpe2022 <- d_reemven15 %>% group_by(anio) %>% summarise ("ventas_rimpe"=sum((ventas_rimpe/102.606321845514)*100,na.rm=T))
    t_ventas_rimpe2022_1 <- t_ventas_rimpe2022 %>% select(ventas_rimpe)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas_rimpe2022_1 <- t_ventas_rimpe2022 %>% select(ventas_rimpe), startCol = 5,startRow = 20,colNames = F) ##escribir

    #VENTAS TOTALES RIMPE#
    t_ventas_tr2022 <- d_reemven15 %>% group_by(anio) %>% summarise ("ventas_totales_rimpe"=sum((ventas_totales_rimpe/102.606321845514)*100,na.rm=T))
    t_ventas_tr2022_1 <- t_ventas_tr2022 %>% select(ventas_totales_rimpe)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas_tr2022_1, startCol = 6,startRow = 20,colNames = F) ##escribir
    addStyle(wb1,"1.2.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
    addStyle(wb1,"1.2.2",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemventas15, d_reemven15, t_ventas2022, t_ventanacional2022, t_ventanacional22, t_exportaciones2022, t_exportaciones23, t_ventas_rimpe2022, t_ventas_rimpe2022_1, t_ventas_tr2022, t_ventas_tr2022_1)

###lectura de base 2023###
    bd_reemventas16 <- bd_reem3 %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas,ventas_rimpe,ventas_totales_rimpe)
    d_reemven16 <- bd_reemventas16 %>% filter (anio == 2023 & situacion == 1)
    t_ventas2023 <- d_reemven16 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/104.949603244225)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas2023, startCol = 1,startRow = 21,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_ventanacional2023 <- d_reemven16 %>% summarise ("total_ventas"=sum((ventas_nacionales/104.949603244225)*100,na.rm=T))
    t_ventanacional23 <- t_ventanacional2023 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventanacional23, startCol = 3,startRow = 21,colNames = F) ##escribir

    #EXPORTACIONES#
    t_exportaciones2023 <- d_reemven16 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/104.949603244225)*100,na.rm=T))
    t_exportaciones23 <- t_exportaciones2023 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_exportaciones23, startCol = 4,startRow = 21,colNames = F) ##escribir

    #VENTAS RIMPE#
    t_ventas_rimpe2023 <- d_reemven16 %>% group_by(anio) %>% summarise ("ventas_rimpe"=sum((ventas_rimpe/104.949603244225)*100,na.rm=T))
    t_ventas_rimpe2023_1 <- t_ventas_rimpe2023 %>% select(ventas_rimpe)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas_rimpe2023_1 <- t_ventas_rimpe2023 %>% select(ventas_rimpe), startCol = 5,startRow = 21,colNames = F) ##escribir

    #VENTAS TOTALES RIMPE#
    t_ventas_tr2023 <- d_reemven16 %>% group_by(anio) %>% summarise ("ventas_totales_rimpe"=sum((ventas_totales_rimpe/104.949603244225)*100,na.rm=T))
    t_ventas_tr2023_1 <- t_ventas_tr2023 %>% select(ventas_totales_rimpe)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "1.2.2",t_ventas_tr2023_1, startCol = 6,startRow = 21,colNames = F) ##escribir
    addStyle(wb1,"1.2.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
    addStyle(wb1,"1.2.2",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemventas16, d_reemven16, t_ventas2023, t_ventanacional2023, t_ventanacional23, t_exportaciones2023, t_exportaciones23, t_ventas_rimpe2023, t_ventas_rimpe2023_1, t_ventas_tr2023, t_ventas_tr2023_1)

###lectura de base 2024###
bd_reemventas16 <- bd_reem %>% select(ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas,ventas_rimpe,ventas_totales_rimpe)
d_reemven16 <- bd_reemventas16 %>% filter (anio == 2024 & situacion == 1)
t_ventas2024 <- d_reemven16 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/110.212419827962)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas2024, startCol = 1,startRow = 22,colNames = F) ##escribir

#VENTAS NACIONALES#
t_ventanacional2024 <- d_reemven16 %>% summarise ("total_ventas"=sum((ventas_nacionales/110.212419827962)*100,na.rm=T))
t_ventanacional24 <- t_ventanacional2024 %>% select(total_ventas)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventanacional24, startCol = 3,startRow = 22,colNames = F) ##escribir

#EXPORTACIONES#
t_exportaciones2024 <- d_reemven16 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/110.212419827962)*100,na.rm=T))
t_exportaciones24 <- t_exportaciones2024 %>% select(total_exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_exportaciones24, startCol = 4,startRow = 22,colNames = F) ##escribir

#VENTAS RIMPE#
t_ventas_rimpe2024 <- d_reemven16 %>% group_by(anio) %>% summarise ("ventas_rimpe"=sum((ventas_rimpe/110.212419827962)*100,na.rm=T))
t_ventas_rimpe2024_1 <- t_ventas_rimpe2024 %>% select(ventas_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas_rimpe2024_1 <- t_ventas_rimpe2024 %>% select(ventas_rimpe), startCol = 5,startRow = 22,colNames = F) ##escribir

#VENTAS TOTALES RIMPE#
t_ventas_tr2024 <- d_reemven16 %>% group_by(anio) %>% summarise ("ventas_totales_rimpe"=sum((ventas_totales_rimpe/110.212419827962)*100,na.rm=T))
t_ventas_tr2024_1 <- t_ventas_tr2024 %>% select(ventas_totales_rimpe)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.2",t_ventas_tr2024_1, startCol = 6,startRow = 22,colNames = F) ##escribir
addStyle(wb1,"1.2.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.2",purpleStyle,cols= 1:6, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemventas16, d_reemven16, t_ventas2024, t_ventanacional2024, t_ventanacional24, t_exportaciones2024, t_exportaciones24, t_ventas_rimpe2024, t_ventas_rimpe2024_1, t_ventas_tr2024, t_ventas_tr2024_1)

######################TABULADO 1.2.3##################################
#  VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM) #
#              AÑO 2024 POR FORMA INSTITUCIONAL                  #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(forma_institucional,ventas_totales,anio,situacion)

# Cálculo de las variables.
t_participacion <- df1 %>% group_by(forma_institucional) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_participacion$total_ventas,na.rm =T )
t_participacion$porcentaje <- t_participacion$total_ventas / total

#Lectura catálogo de variables.
des_participacion <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_participacion,t_participacion,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.3","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.3",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.3",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.3",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.3",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.3",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_participacion, total, des_participacion, dft2, dft3, t_estrato1)

#############################TABULADO 1.2.4#########################################
#   VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM), AÑO 2024   #
#                        POR TAMAÑO DE EMPRESA                                  #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(tamanoe_plazas,ventas_totales,anio,situacion)

#Cálculo de las variables.
t_tamanoventas <- df1 %>% group_by(tamanoe_plazas) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoventas$total_ventas,na.rm =T )
t_tamanoventas$porcentaje <- t_tamanoventas$total_ventas / total

#Lectura catálogo de variables.
des_tamanoventas <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoventas,t_tamanoventas,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.4","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.4",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.4",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.4",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.4",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.4",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.4",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_tamanoventas, total, des_tamanoventas, dft2, dft3, t_estrato1)

#############################TABULADO 1.2.5#########################################
#   VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM), AÑO 2024   #
#                        POR TAMAÑO DE EMPRESA (COP)                            #

#Selección de variables que se requieren para el tabulado.+
df1 <- bd_reem %>% select(tamano_cop,ventas_totales,anio,situacion)

#Cálculo de las variables.
t_tamanoventas <- df1 %>% group_by(tamano_cop) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoventas$total_ventas,na.rm =T )
t_tamanoventas$porcentaje <- t_tamanoventas$total_ventas / total

#Lectura catálogo de variables.
des_tamanoventas <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoventas,t_tamanoventas,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.5","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.5",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.5",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.5",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.5",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.5",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.5",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_tamanoventas, total, des_tamanoventas, dft2, dft3, t_estrato1)

#####################TABULADO 1.2.6####################################
#  VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM)  #
#            AÑO 2024 POR SECTOR ECONÓMICO                        #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,ventas_totales,anio,situacion)

#Cálculo de las variables.
t_sectorventas <- df1 %>% group_by(gsectores) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_sectorventas$total_ventas,na.rm =T )
t_sectorventas$porcentaje <- t_sectorventas$total_ventas / total

#Lectura catálogo de variables.
des_sectorventas <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorventas,t_sectorventas,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.6","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.6",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.6",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.6",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.6",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.6",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectorventas, total, des_sectorventas, dft2, dft3, t_estrato1)

###################TABULADO 1.2.7###################################
#VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM),#
#       AÑO 2024 POR ACTIVIDAD ECONÓMICA                       #

#selección de variables###
df1 <- bd_reem %>% select(codigo_seccion,ventas_totales,anio,situacion)

#Cálculo de las variables.
t_seccventas <- df1 %>% group_by(codigo_seccion) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_seccventas$total_ventas,na.rm =T )
t_seccventas$porcentaje <- t_seccventas$total_ventas / total

#Lectura catálogo de variables.
des_seccventas <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccventas,t_seccventas,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.7","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.7",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.7",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.7",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.7",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.7",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_seccventas, total, des_seccventas, dft2, dft3, t_estrato1)

####################TABULADO 1.2.8###############################
#VENTAS TOTALES SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM),#
#          AÑO 2024 POR PROVINCIA                           #

#selección de variables###
df1 <- bd_reem %>% select(codigo_provincia,ventas_totales,anio,situacion)

#Cálculo de las variables.
t_provventas <- df1 %>% group_by(codigo_provincia) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_provventas$total_ventas,na.rm =T )
t_provventas$porcentaje <- t_provventas$total_ventas / total

#Lectura catálogo de variables.
des_provventas <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provventas,t_provventas,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.8","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.8",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.8",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.8",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.8",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.8",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provventas, total, des_provventas, dft2, dft3, t_estrato1)

######################TABULADO 1.2.9##################################
#  VENTAS RIMPE SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM) #
#              AÑO 2024 POR FORMA INSTITUCIONAL                  #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(forma_institucional,ventas_rimpe,anio,situacion)

# Cálculo de las variables.
t_participacionventasrimpe <- df1 %>% group_by(forma_institucional) %>% summarise ("total_rimpe"=sum(ventas_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_participacionventasrimpe$total_rimpe,na.rm =T )
t_participacionventasrimpe$porcentaje <- t_participacionventasrimpe$total_rimpe / total

#Lectura catálogo de variables.
des_participacionvr <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_participacionvr,t_participacionventasrimpe,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.9","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.9",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.9",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.9",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.9",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_participacionventasrimpe, total, des_participacionvr, dft2, dft3, t_estrato1)

#####################TABULADO 1.2.10####################################
#  VENTAS RIMPE SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM)  #
#            AÑO 2024 POR SECTOR ECONÓMICO                        #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,ventas_rimpe,anio,situacion)

#Cálculo de las variables.
t_sectorventasrimpe <- df1 %>% group_by(gsectores) %>% summarise ("total_rimpe"=sum(ventas_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_sectorventasrimpe$total_rimpe,na.rm =T )
t_sectorventasrimpe$porcentaje <- t_sectorventasrimpe$total_rimpe / total

#Lectura catálogo de variables.
des_sectorventasr <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorventasr,t_sectorventasrimpe,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.10","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.10",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.10",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.10",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.10",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.10",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectorventasrimpe, total, des_sectorventasr, dft2, dft3, t_estrato1)

###################TABULADO 1.2.11###################################
#VENTAS RIMPE SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM),#
#       AÑO 2024 POR ACTIVIDAD ECONÓMICA                       #

#selección de variables###
df1 <- bd_reem %>% select(codigo_seccion,ventas_rimpe,anio,situacion)

#Cálculo de las variables.
t_actventasrimpe <- df1 %>% group_by(codigo_seccion) %>% summarise ("total_rimpe"=sum(ventas_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_actventasrimpe$total_rimpe,na.rm =T )
t_actventasrimpe$porcentaje <- t_actventasrimpe$total_rimpe / total

#Lectura catálogo de variables.
des_seccventasr <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccventasr,t_actventasrimpe,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.11","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.11",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.11",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.11",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.11",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.11",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_actventasrimpe, total, des_seccventasr, dft2, dft3, t_estrato1)

####################TABULADO 1.2.12###############################
#VENTAS RIMPE SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM),#
#          AÑO 2024 POR PROVINCIA                           #

#selección de variables###
df1 <- bd_reem %>% select(codigo_provincia,ventas_rimpe,anio,situacion)

#Cálculo de las variables.
t_provventasrimpe <- df1 %>% group_by(codigo_provincia) %>% summarise ("total_rimpe"=sum(ventas_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_provventasrimpe$total_rimpe,na.rm =T )
t_provventasrimpe$porcentaje <- t_provventasrimpe$total_rimpe / total

#Lectura catálogo de variables.
des_provventasr <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provventasr,t_provventasrimpe,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.12","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.12",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.12",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.12",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.12",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.12",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provventasrimpe, total, des_provventasr, dft2, dft3, t_estrato1)

######################TABULADO 1.2.13##################################
#  VENTAS TOTALES RIMPE SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM) #
#              AÑO 2024 POR FORMA INSTITUCIONAL                  #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(forma_institucional,ventas_totales_rimpe,anio,situacion)

# Cálculo de las variables.
t_participacionrt <- df1 %>% group_by(forma_institucional) %>% summarise ("total_ventas_rimpe"=sum(ventas_totales_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_participacionrt$total_ventas_rimpe,na.rm =T )
t_participacionrt$porcentaje <- t_participacionrt$total_ventas_rimpe / total

#Lectura catálogo de variables.
des_participacionrt <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_participacionrt,t_participacionrt,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.13","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.13",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.13",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.13",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.13",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.13",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_participacionrt, total, des_participacionrt, dft2, dft3, t_estrato1)

#####################TABULADO 1.2.14####################################
#  VENTAS TOTALES RIMPE SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM)  #
#            AÑO 2024 POR SECTOR ECONÓMICO                        #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,ventas_totales_rimpe,anio,situacion)

#Cálculo de las variables.
t_sectorventasrt <- df1 %>% group_by(gsectores) %>% summarise ("total_ventas_rimpe"=sum(ventas_totales_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_sectorventasrt$total_ventas_rimpe,na.rm =T )
t_sectorventasrt$porcentaje <- t_sectorventasrt$total_ventas_rimpe / total

#Lectura catálogo de variables.
des_sectorventasrt <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorventasrt,t_sectorventasrt,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.14","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.14",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.14",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.14",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.14",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.14",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectorventasrt, total, des_sectorventasrt, dft2, dft3, t_estrato1)

###################TABULADO 1.2.15###################################
#VENTAS TOTALES RIMPE SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM),#
#       AÑO 2024 POR ACTIVIDAD ECONÓMICA                       #

#selección de variables###
df1 <- bd_reem %>% select(codigo_seccion,ventas_totales_rimpe,anio,situacion)

#Cálculo de las variables.
t_seccventasrt <- df1 %>% group_by(codigo_seccion) %>% summarise ("total_ventas_rimpe"=sum(ventas_totales_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_seccventasrt$total_ventas_rimpe,na.rm =T )
t_seccventasrt$porcentaje <- t_seccventasrt$total_ventas_rimpe / total

#Lectura catálogo de variables.
des_seccventasrt <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccventasrt,t_seccventasrt,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.15","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.15",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.15",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.15",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.15",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.15",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_seccventasrt, total, des_seccventasrt, dft2, dft3, t_estrato1)

####################TABULADO 1.2.16###############################
#VENTAS TOTALES RIMPE SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM),#
#          AÑO 2024 POR PROVINCIA                           #

#selección de variables###
df1 <- bd_reem %>% select(codigo_provincia,ventas_totales_rimpe,anio,situacion)

#Cálculo de las variables.
t_provventasrt <- df1 %>% group_by(codigo_provincia) %>% summarise ("total_ventas_rimpe"=sum(ventas_totales_rimpe,na.rm=T), porcentaje = 0)
total <- sum(t_provventasrt$total_ventas_rimpe,na.rm =T )
t_provventasrt$porcentaje <- t_provventasrt$total_ventas_rimpe / total

#Lectura catálogo de variables.
des_provventasrt <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provventasrt,t_provventasrt,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas_rimpe,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.16","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.2.16",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.16",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.2.16",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.16",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.16",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provventasrt, total, des_provventasrt, dft2, dft3, t_estrato1)

###################TABULADO 1.2.17###############################
#      VENTAS TOTALES (UNIVERSO REEM)                      #
#                   AÑO DESDE 2023                             #

#Lectura de la base de datos 2023
bd_reem7cx <- bd_reem3 %>% select(importaciones, exportaciones,anio,situacion)
bd_reemac7_cx <- bd_reem7cx %>% filter (anio == 2023 & situacion == 1)

#IMPORTACIONES#
t_importaciones <- bd_reemac7_cx %>% group_by(anio) %>% summarise ("importaciones"=sum(importaciones,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.17",t_importaciones, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.2.17",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.17",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

#EXPORTACIONES#
#total empresas del año 2023#
t_exportacionescx <- bd_reemac7_cx %>% group_by(anio) %>% summarise ("exportaciones"=sum(exportaciones,na.rm=T))
t_exportacionescx_1 <- t_exportacionescx %>% select(exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.17",t_exportacionescx_1, startCol = 3,startRow = 7,colNames = F) ##escribir

rm(bd_reem7cx, bd_reemac7_cx, t_importaciones, t_exportacionescx, t_exportacionescx_1)

#Lectura de la base de datos 2024
bd_reem7cx <- bd_reem %>% select(importaciones, exportaciones,anio,situacion)
bd_reemac7_cx <- bd_reem7cx %>% filter (situacion == 1)

#IMPORTACIONES#
t_importaciones <- bd_reemac7_cx %>% group_by(anio) %>% summarise ("importaciones"=sum(importaciones,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.17",t_importaciones, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.2.17",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.2.17",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

#EXPORTACIONES#
#total empresas del año 2024#
t_exportacionescx <- bd_reemac7_cx %>% group_by(anio) %>% summarise ("exportaciones"=sum(exportaciones,na.rm=T))
t_exportacionescx_1 <- t_exportacionescx %>% select(exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "1.2.17",t_exportacionescx_1, startCol = 3,startRow = 8,colNames = F) ##escribir

rm(bd_reem7cx, bd_reemac7_cx, t_importaciones, t_exportacionescx, t_exportacionescx_1)

#########1.3 SECCION III: plazas de empleo registrado, empleo registrado y masa salarial##################

###############TABULADO 1.3.1####################################
#PLAZAS DE EMPLEO REGISTRADO EQUIVALENTE (UNIVERSO REEM) PERIODO 2006-2024#

#######PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM) PERIODO 2006 - 2011 POR AÑO
d_plazas <- bd_reem1 %>% select(plazas_equiv,plazas_equiv_hombres,plazas_equiv_mujeres,anio,situacion)

#total empresas del año 2006-2011#
t_plazas <- d_plazas %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                  "total_plazashombres" =sum(plazas_equiv_hombres,na.rm=T),
                                                  "total_plazasmujeres"=sum(plazas_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.3.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_plazas, t_plazas)

########PLAZAS DE EMPLEO REGISTRADO EQUIVALENTE (UNIVERSO REEM), PERIODO 2012 - 2023 POR AÑO

bd_plazas <- bd_reem3 %>% select(plazas_equiv,plazas_equiv_hombres,plazas_equiv_mujeres,anio,situacion)
bd_plazas1 <- bd_plazas %>% filter (situacion ==1)

#total empresas del año 2012-2023#
t_plazas <- bd_plazas1 %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                     "total_plazashombres" =sum(plazas_equiv_hombres,na.rm=T),
                                                     "total_plazasmujeres"=sum(plazas_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 13,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 13,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 13,colNames = F) ##escribir
addStyle(wb1,"1.3.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_plazas, bd_plazas1, t_plazas)

########PLAZAS DE EMPLEO REGISTRADO EQUIVALENTE (UNIVERSO REEM), AÑO 2024

bd_plazas <- bd_reem %>% select(plazas_equiv,plazas_equiv_hombres,plazas_equiv_mujeres,anio,situacion)
bd_plazas1 <- bd_plazas %>% filter (situacion ==1)

#total empresas del año 2024#
t_plazas <- bd_plazas1 %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                         "total_plazashombres" =sum(plazas_equiv_hombres,na.rm=T),
                                                         "total_plazasmujeres"=sum(plazas_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 25,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 25,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.1",t_plazas, startCol = 1,startRow = 25,colNames = F) ##escribir
addStyle(wb1,"1.3.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.1",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_plazas, bd_plazas1, t_plazas)


###############TABULADO 1.3.2####################################

########PLAZAS DE EMPLEO REGISTRADO EQUIVALENTE (UNIVERSO REEM) POR NACIONALIDAD, DESDE AÑO 2023

# AÑO 2023 #

bd_plazas8 <- bd_reem3 %>% select(plazas_equiv,plazas_nacionales_equiv,plazas_extranjeros_equiv,anio,situacion)
bd_plazas9 <- bd_plazas8 %>% filter (anio == 2023 & situacion ==1)

#total empresas del año 2024#
t_plazas <- bd_plazas9 %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                         "total_plazasnacionales" =sum(plazas_nacionales_equiv,na.rm=T),
                                                         "total_plazasextranjeros" =sum(plazas_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.2",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.2",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.2",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.3.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.2",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_plazas8, bd_plazas9, t_plazas)

# AÑO 2024 #

bd_plazas8 <- bd_reem %>% select(plazas_equiv,plazas_nacionales_equiv,plazas_extranjeros_equiv,anio,situacion)
bd_plazas9 <- bd_plazas8 %>% filter (situacion ==1)

#total empresas del año 2024#
t_plazas <- bd_plazas9 %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                         "total_plazasnacionales" =sum(plazas_nacionales_equiv,na.rm=T),
                                                         "total_plazasextranjeros" =sum(plazas_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.2",t_plazas, startCol = 1,startRow = 8,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.2",t_plazas, startCol = 1,startRow = 8,colNames = F) ##escribir
writeData(wb1,sheet = "1.3.2",t_plazas, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.2",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_plazas8, bd_plazas9, t_plazas)

#######################TABULADO 1.3.3##################################################
#############PLAZAS DE EMPLEO REGISTRADO EQUIVALENTE (UNIVERSO REEM), POR RANGO DE EDAD AÑO 2024

#Selección de variables que se requieren para el tabulado.
bd_plazas <- bd_reem %>% select(plazas_rango_edad_1,plazas_rango_edad_2,
                                   plazas_rango_edad_3,plazas_rango_edad_4, 
                                   plazas_rango_edad_5, situacion)

#Cálculo de las variables.
t_plazasre1 <- bd_plazas %>% summarise ("total_plazas"=sum(plazas_rango_edad_1,na.rm=T), porcentaje = 0)
t_plazasre2 <- bd_plazas %>% summarise ("total_plazas"=sum(plazas_rango_edad_2,na.rm=T), porcentaje = 0)
t_plazasre3 <- bd_plazas %>% summarise ("total_plazas"=sum(plazas_rango_edad_3,na.rm=T), porcentaje = 0)
t_plazasre4 <- bd_plazas %>% summarise ("total_plazas"=sum(plazas_rango_edad_4,na.rm=T), porcentaje = 0)
t_plazasre5 <- bd_plazas %>% summarise ("total_plazas"=sum(plazas_rango_edad_5,na.rm=T), porcentaje = 0)

t_rangos1 = data.frame(new.row.names = "RANGO DE EDAD 1", rbind(t_plazasre1))
t_rangos2 = data.frame(new.row.names = "RANGO DE EDAD 2", rbind(t_plazasre2))
t_rangos3 = data.frame(new.row.names = "RANGO DE EDAD 3", rbind(t_plazasre3))
t_rangos4 = data.frame(new.row.names = "RANGO DE EDAD 4", rbind(t_plazasre4))
t_rangos5 = data.frame(new.row.names = "RANGO DE EDAD 5", rbind(t_plazasre5))

tabla1 <- data.frame (rbind(t_rangos1,t_rangos2,t_rangos3, t_rangos4, t_rangos5))
total <- sum(tabla1$total_plazas,na.rm = T)
tabla1$porcentaje <- tabla1$total_plazas/total

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.3","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.3",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.3",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.3",tabla1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.3",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.3",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.3",purpleStyle,cols= 6:7, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_plazas, t_plazasre1, t_plazasre2, t_plazasre3, t_plazasre4, t_plazasre5, t_rangos1, t_rangos2, t_rangos3, t_rangos4, t_rangos5, tabla1, total)

#######################TABULADO 1.3.4#############################################
#PLAZAS DE EMPLEO REGISTRADO EQUIVALENTE (UNIVERSO REEM), AÑO 2024 POR FORMA INSTITUCIONAL#

#Selección de variables que se requieren para el tabulado.
bd_plazas <- bd_reem %>% select(plazas_equiv,forma_institucional,situacion)

#Cálculo de las variables.
t_plazasins <- bd_plazas %>% group_by(forma_institucional) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_plazasins$total_plazas,na.rm =T )
t_plazasins$porcentaje <- t_plazasins$total_plazas / total

#Lectura catálogo de variables.
des_plazasinst <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_plazasinst,t_plazasins,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.4","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.4",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.4",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.4",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.4",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.4",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_plazas, t_plazasins, total, des_plazasinst, dft2, dft3, t_estrato1)

##############################TABULADO 1.3.5##############################################
##PARTICIPACIÓN DEL PERSONAL AFILIADO EQUIVALENTE (UNIVERSO REEM), AÑO 2024 POR TAMAÑO DE EMPRESA#

#selección de variables
bd_tamano <- bd_reem %>% select(tamanoe_plazas,plazas_equiv,anio,situacion)

#Cálculo de las variables.
t_tamanoplazas <- bd_tamano %>% group_by(tamanoe_plazas) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=TRUE), porcentaje = 0)
total <- sum(t_tamanoplazas$total_plazas,na.rm =TRUE )
t_tamanoplazas$porcentaje <- t_tamanoplazas$total_plazas / total

#Lectura catálogo de variables.
des_tamanoplazas <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoplazas,t_tamanoplazas,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.5","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.5",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.5",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.5",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.5",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.5",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.5",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, t_tamanoplazas, total, des_tamanoplazas, dft2, dft3, t_estrato1)

##############################TABULADO 1.3.6####################################################
##PARTICIPACIÓN DEL PERSONAL AFILIADO (UNIVERSO REEM), AÑO 2024 POR TAMAÑO DE EMPRESA (COP)#

#selección de variables
bd_tamano <- bd_reem %>% select(tamano_cop,plazas_equiv,anio,situacion)

#Cálculo de las variables.
t_tamano_cop <- bd_tamano %>% group_by(tamano_cop) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamano_cop$total_plazas,na.rm =T )
t_tamano_cop$porcentaje <- t_tamano_cop$total_plazas / total

#Lectura catálogo de variables.
des_tamano_cop <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamano_cop,t_tamano_cop,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.6","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.6",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.6",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.6",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.6",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.6",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.6",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, t_tamano_cop, total, des_tamano_cop, dft2, dft3, t_estrato1)

###########################TABULADO 1.3.7###############################################
#PARTICIPACIÓN DEL PERSONAL AFILIADO (UNIVERSO REEM), AÑO 2024 POR SECTOR ECONÓMICO#

#selección de variables###
df1 <- bd_reem %>% select(gsectores,plazas_equiv,anio,situacion)

#Cálculo de las variables.
t_sectorplazas <- df1 %>% group_by(gsectores) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_sectorplazas$total_plazas,na.rm =T )
t_sectorplazas$porcentaje <- t_sectorplazas$total_plazas / total

#Lectura catálogo de variables.
des_sectorplazas <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorplazas,t_sectorplazas,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

v_total <- c("TOTAL",total,"100.00%")
v_total <- matrix(v_total,nrow=1,ncol=3)

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.7","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.7",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.7",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.7",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.7",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.7",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectorplazas, total, des_sectorplazas, dft2, dft3, t_estrato1, v_total)

###########################TABULADO 1.3.8##############################
#PERSONAL AFILIADO SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM) #
#            AÑO 2024 POR ACTIVIDAD ECONÓMICA                     #

#selección de variables###
df1 <- bd_reem %>% select(codigo_seccion,plazas_equiv,anio,situacion)

#cálculo#
t_seccplazas <- df1 %>% group_by(codigo_seccion) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_seccplazas$total_plazas,na.rm =T )
t_seccplazas$porcentaje <- t_seccplazas$total_plazas / total

#Lectura catálogo de variables.
des_seccplazas <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccplazas,t_seccplazas,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.8","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.8",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.8",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.8",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.8",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.8",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_seccplazas, total, des_seccplazas, dft2, dft3, t_estrato1)

##############################TABULADO 1.3.9############################
#  PERSONAL AFILIADO SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM),  #  
#                     AÑO 2024 POR PROVINCIA                       #

#selección de variables###
df1 <- bd_reem %>% select(codigo_provincia,plazas_equiv,anio,situacion)

#Cálculo de las variables.
t_provplazas <- df1 %>% group_by(codigo_provincia) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_provplazas$total_plazas,na.rm =T )
t_provplazas$porcentaje <- t_provplazas$total_plazas / total

#Lectura catálogo de variables.
des_provplazas <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provplazas,t_provplazas,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.9","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.9",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.9",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.9",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.9",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provplazas, total, des_provplazas, dft2, dft3, t_estrato1)

########TABULADO 1.3.10##############################################
#PERSONAL AFILIADO - EMPLEO (UNIVERSO REEM), PERIODO 2006 - 2024 POR AÑO#

#BASE GENERAL 2006 - 2011
d_empleo <- bd_reem1 %>% select(empleo_equiv,empleo_equiv_hombres,empleo_equiv_mujeres,anio,situacion)

#total empresas del año 2006-2011
t_empleoafi <- d_empleo %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                     "total_empleohombres" =sum(empleo_equiv_hombres,na.rm=T),
                                                     "total_empleomujeres"=sum(empleo_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.10",t_empleoafi, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.3.10",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.10",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#BASE GENERAL 2012-2023
bd_empleo2 <- bd_reem3 %>% select(empleo_equiv,empleo_equiv_hombres,empleo_equiv_mujeres,ventas_totales,anio,situacion)
bd_empleo2 <- bd_empleo2 %>% filter (situacion ==1)

#total empresas del año 2012-2023#
t_empleoafi <- bd_empleo2 %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                    "total_empleohombres" =sum(empleo_equiv_hombres,na.rm=T),
                                                    "total_empleomujeres"=sum(empleo_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.10",t_empleoafi, startCol = 1,startRow = 13,colNames = F) ##escribir
addStyle(wb1,"1.3.10",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.10",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(t_empleoafi, bd_empleo2)

#BASE GENERAL 2024
bd_empleo2 <- bd_reem %>% select(empleo_equiv,empleo_equiv_hombres,empleo_equiv_mujeres,ventas_totales,anio,situacion)
bd_empleo2 <- bd_empleo2 %>% filter (situacion ==1)

#total empresas del año 2024#
t_empleoafi <- bd_empleo2 %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                            "total_empleohombres" =sum(empleo_equiv_hombres,na.rm=T),
                                                            "total_empleomujeres"=sum(empleo_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.10",t_empleoafi, startCol = 1,startRow = 25,colNames = F) ##escribir
addStyle(wb1,"1.3.10",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.10",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_empleo, t_empleoafi, bd_empleo2)


########TABULADO 1.3.11##############################################
#PERSONAL AFILIADO - EMPLEO (UNIVERSO REEM), DESDE AÑO 2023 POR NACIONALIDAD#

#BASE GENERAL 2023
bd_empleo6 <- bd_reem3 %>% select(empleo_equiv,empleo_nacionales_equiv,empleo_extranjeros_equiv,ventas_totales,anio,situacion)
bd_empleo6 <- bd_empleo6 %>% filter (anio == 2023 & situacion == 1)

#total empresas del año 2023#
t_empleoafi <- bd_empleo6 %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                            "total_empleonacionales" =sum(empleo_nacionales_equiv,na.rm=T),
                                                            "total_empleoextranjeros"=sum(empleo_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.11",t_empleoafi, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.3.11",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.11",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_empleo6, t_empleoafi)

#BASE GENERAL 2024
bd_empleo6 <- bd_reem %>% select(empleo_equiv,empleo_nacionales_equiv,empleo_extranjeros_equiv,ventas_totales,anio,situacion)
bd_empleo6 <- bd_empleo6 %>% filter (situacion == 1)

#total empresas del año 2024#
t_empleoafi <- bd_empleo6 %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                            "total_empleonacionales" =sum(empleo_nacionales_equiv,na.rm=T),
                                                            "total_empleoextranjeros"=sum(empleo_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.11",t_empleoafi, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.11",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.11",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_empleo6, t_empleoafi)


####################TABULADO 1.3.12#######################################
#EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024 POR RANGO DE EDAD#

#Selección de variables que se requieren para el tabulado.
bd_empleo <- bd_reem %>% select(empleo_rango_edad_1,empleo_rango_edad_2,
                                   empleo_rango_edad_3,empleo_rango_edad_4, 
                                   empleo_rango_edad_5, situacion)

#Cálculo de las variables.
t_empleore1 <- bd_empleo %>% summarise ("total_empleo"=sum(empleo_rango_edad_1,na.rm=T), porcentaje = 0)
t_empleore2 <- bd_empleo %>% summarise ("total_empleo"=sum(empleo_rango_edad_2,na.rm=T), porcentaje = 0)
t_empleore3 <- bd_empleo %>% summarise ("total_empleo"=sum(empleo_rango_edad_3,na.rm=T), porcentaje = 0)
t_empleore4 <- bd_empleo %>% summarise ("total_empleo"=sum(empleo_rango_edad_4,na.rm=T), porcentaje = 0)
t_empleore5 <- bd_empleo %>% summarise ("total_empleo"=sum(empleo_rango_edad_5,na.rm=T), porcentaje = 0)

t_rangos1 = data.frame(new.row.names = "RANGO DE EDAD 1", rbind(t_empleore1))
t_rangos2 = data.frame(new.row.names = "RANGO DE EDAD 2", rbind(t_empleore2))
t_rangos3 = data.frame(new.row.names = "RANGO DE EDAD 3", rbind(t_empleore3))
t_rangos4 = data.frame(new.row.names = "RANGO DE EDAD 4", rbind(t_empleore4))
t_rangos5 = data.frame(new.row.names = "RANGO DE EDAD 5", rbind(t_empleore5))

tabla1 <- data.frame (rbind(t_rangos1,t_rangos2,t_rangos3, t_rangos4, t_rangos5))
total <- sum(tabla1$total_empleo,na.rm = T)
tabla1$porcentaje <- tabla1$total_empleo/total

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.12","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.12",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.12",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.12",tabla1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.12",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.12",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.12",purpleStyle,cols= 6:7, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_empleo, t_empleore1, t_empleore2, t_empleore3, t_empleore4, t_empleore5, t_rangos1, t_rangos2, t_rangos3, t_rangos4, t_rangos5, tabla1, total)

####################TABULADO 1.3.13#######################################
#EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024 POR FORMA INSTITUCIONAL# 

#Selección de variables que se requieren para el tabulado.
bd_empleo <- bd_reem %>% select(empleo_equiv,forma_institucional,situacion)

#Cálculo de las variables.
t_empformains <- bd_empleo %>% group_by(forma_institucional) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_empformains$total_empleo,na.rm =T )
t_empformains$porcentaje <- t_empformains$total_empleo / total

#Lectura catálogo de variables.
des_empformainst <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_empformainst,t_empformains,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.13","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.13",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.13",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.13",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.13",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.13",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_empleo, t_empformains, total, des_empformainst, dft2, dft3, t_estrato1)

###########################TABULADO 1.3.14#################################################
# PARTICIPACIÓN DEL PERSONAL AFILIADO (UNIVERSO REEM), AÑO 2024 POR TAMAÑO DE EMPRESA#

#Selección de variables que se requieren para el tabulado.
bd_tamano <- bd_reem %>% select(tamanoe_empleo,empleo_equiv,anio,situacion)

#Cálculo de las variables.
t_tamanoempleo <- bd_tamano %>% group_by(tamanoe_empleo) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoempleo$total_empleo,na.rm =T )
t_tamanoempleo$porcentaje <- t_tamanoempleo$total_empleo / total

#Lectura catálogo de variables.
des_tamanoempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoempleo,t_tamanoempleo,by.x = "CODIGO",by.y = "tamanoe_empleo",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.14","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.14",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.14",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.14",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.14",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.14",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.14",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)
estilo  <-  createStyle (fontColour  =  rgb (1 ,  1 ,  1) )
addStyle(wb1,"1.3.14",estilo,cols= 2:3, rows = 13,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, t_tamanoempleo, total, des_tamanoempleo, dft2, dft3, t_estrato1)

###########################TABULADO 1.3.15########################################################
# PARTICIPACIÓN DEL PERSONAL AFILIADO (UNIVERSO REEM), AÑO 2024 POR TAMAÑO DE EMPRESA (COP) #

#Selección de variables que se requieren para el tabulado.
bd_tamano <- bd_reem %>% select(tamano_cop,empleo_equiv,anio,situacion)

#Cálculo de las variables.
t_tamanocopemp <- bd_tamano %>% group_by(tamano_cop) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamanocopemp$total_empleo,na.rm =T )
t_tamanocopemp$porcentaje <- t_tamanocopemp$total_empleo / total

#Lectura catálogo de variables.
des_tamanocopemp <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanocopemp,t_tamanocopemp,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.15","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.15",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.15",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.15",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.15",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.15",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.15",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, t_tamanocopemp, total, des_tamanocopemp, dft2, dft3, t_estrato1)

###################################TABULADO 1.3.16#######################################
#PARTICIPACIÓN DEL PERSONAL AFILIADO (UNIVERSO REEM), AÑO 2024 POR SECTOR ECONÓMICO#

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,empleo_equiv,anio,situacion)

#cálculo#
t_sectorempleo <- df1 %>% group_by(gsectores) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_sectorempleo$total_empleo,na.rm =T )
t_sectorempleo$porcentaje <- t_sectorempleo$total_empleo / total

#Lectura catálogo de variables.
des_sectorempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorempleo,t_sectorempleo,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.16","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.16",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.16",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.16",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.16",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.16",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectorempleo, total, des_sectorempleo, dft2, dft3, t_estrato1)

######################TABULADO 1.3.17##################################
#PERSONAL AFILIADO SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM)# 
#         AÑO 2024 POR ACTIVIDAD ECONÓMICA                       #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_seccion,empleo_equiv,anio,situacion)

#Cálculo de las variables.
t_seccempleo <- df1 %>% group_by(codigo_seccion) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_seccempleo$total_empleo,na.rm =T )
t_seccempleo$porcentaje <- t_seccempleo$total_empleo / total

#Lectura catálogo de variables.
des_seccempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccempleo,t_seccempleo,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.17","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.17",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.17",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.17",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.17",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.17",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_seccempleo, total, des_seccempleo, dft2, dft3, t_estrato1)

#########TABULADO 1.3.18##########################
#EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024#
#           POR PROVINCIA                    #  

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_provincia,empleo_equiv,anio,situacion)

#Cálculo de las variables.
t_provempleo <- df1 %>% group_by(codigo_provincia) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_provempleo$total_empleo,na.rm =T )
t_provempleo$porcentaje <- t_provempleo$total_empleo / total

#Lectura catálogo de variables.
des_provempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provempleo,t_provempleo,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.18","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.18",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.18",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.18",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.18",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.18",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provempleo, total, des_provempleo, dft2, dft3, t_estrato1)

################################TABULADO 1.3.19##########################################
#       MASA SALARIAL (UNIVERSO REEM), PERIODO 2006 - 2024 POR AÑO                 #

#BASE GENERAL 2006-2011
d_remuneracion <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)

#total empresas del año 2006-2011
t_remuneraciones <- d_remuneracion %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T),
                                                                     "total_remuneracioneshombres" =sum(remuneraciones_hombres,na.rm=T),
                                                                     "total_remuneracionesmujeres"=sum(remuneraciones_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.19",t_remuneraciones, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"1.3.19",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.19",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#BASE GENERAL 2012-2023
d_remuneracion <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_remuneracion1 <- d_remuneracion %>% filter(situacion ==1)

#total empresas del año 2012-2023#
t_remuneraciones <- d_remuneracion1 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T),
                                                    "total_remuneracioneshombres" =sum(remuneraciones_hombres,na.rm=T),
                                                    "total_remuneracionesmujeres"=sum(remuneraciones_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.19",t_remuneraciones, startCol = 1,startRow = 13,colNames = F) ##escribir
addStyle(wb1,"1.3.19",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.19",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_remuneracion, t_remuneraciones, d_remuneracion1)

#BASE GENERAL 2024
d_remuneracion <- bd_reem %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_remuneracion1 <- d_remuneracion %>% filter(situacion ==1)

#total empresas del año 2024#
t_remuneraciones <- d_remuneracion1 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T),
                                                                      "total_remuneracioneshombres" =sum(remuneraciones_hombres,na.rm=T),
                                                                      "total_remuneracionesmujeres"=sum(remuneraciones_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.19",t_remuneraciones, startCol = 1,startRow = 25,colNames = F) ##escribir
addStyle(wb1,"1.3.19",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.19",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_remuneracion, t_remuneraciones, d_remuneracion1)


#################TABULADO 1.3.20 : CONSTANTES#################################
#MASA SALARIAL (UNIVERSO REEM), PERIODO 2006 - 2024 POR AÑO#

#lectura de base 2006
bd_reemms <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms1 <- bd_reemms %>% filter (anio == 2006 & situacion == 1)
t_masa2006 <- d_reemms1 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/67.47325607058)*100,na.rm=T),
                                                  "total_remuneracioneshombres" =sum((remuneraciones_hombres/67.47325607058)*100,na.rm=T),
                                                  "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/67.47325607058)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2006, startCol = 1,startRow = 7,colNames = F) ##escribir

#lectura de base 2007
bd_reemms1 <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms2 <- bd_reemms1 %>% filter (anio == 2007 & situacion == 1)
t_masa2007 <- d_reemms2 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/69.7131700881765)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/69.7131700881765)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/69.7131700881765)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2007, startCol = 1,startRow = 8,colNames = F) ##escribir

#lectura de base 2008
bd_reemms2 <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms3 <- bd_reemms2 %>% filter (anio == 2008 & situacion == 1)
t_masa2008 <- d_reemms3 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/75.869220409474400)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/75.869220409474400)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/75.869220409474400)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2008, startCol = 1,startRow = 9,colNames = F) ##escribir

#lectura de base 2009
bd_reemms3 <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms4 <- bd_reemms3 %>% filter (anio == 2009 & situacion == 1)
t_masa2009 <- d_reemms4 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/79.140506694669800)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/79.140506694669800)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/79.140506694669800)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2009, startCol = 1,startRow = 10,colNames = F) ##escribir

#lectura de base 2010
bd_reemms4 <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms5 <- bd_reemms4 %>% filter (anio == 2010 & situacion == 1)
t_masa2010 <- d_reemms5 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/81.77433051557090)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/81.77433051557090)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/81.77433051557090)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2010, startCol = 1,startRow = 11,colNames = F) ##escribir

#lectura de base 2011
bd_reemms5 <- bd_reem1 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms6 <- bd_reemms5 %>% filter (anio == 2011 & situacion == 1)
t_masa2011 <- d_reemms6 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/86.1978166564780)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/86.1978166564780)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/86.1978166564780)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2011, startCol = 1,startRow = 12,colNames = F) ##escribir

#lectura de base 2012
bd_reemms6 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms7 <- bd_reemms6 %>% filter (anio == 2012 & situacion == 1)
t_masa2012 <- d_reemms7 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/89.7870158278850)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/89.7870158278850)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/89.7870158278850)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2012, startCol = 1,startRow = 13,colNames = F) ##escribir

#lectura de base 2013
bd_reemms7 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms8 <- bd_reemms7 %>% filter (anio == 2013 & situacion == 1)
t_masa2013 <- d_reemms8 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/92.21157233719690)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/92.21157233719690)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/92.21157233719690)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2013, startCol = 1,startRow = 14,colNames = F) ##escribir

#lectura de base 2014
bd_reemms8 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms9 <- bd_reemms8 %>% filter (anio == 2014 & situacion == 1)
t_masa2014 <- d_reemms9 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/95.59330008553980)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/95.59330008553980)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/95.59330008553980)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2014, startCol = 1,startRow = 15,colNames = F) ##escribir

#lectura de base 2015
bd_reemms9 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms10 <- bd_reemms9 %>% filter (anio == 2015 & situacion == 1)
t_masa2015 <- d_reemms10 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/98.82447324752920)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/98.82447324752920)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/98.82447324752920)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2015, startCol = 1,startRow = 16,colNames = F) ##escribir

#lectura de base 2016
bd_reemms10 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms11 <- bd_reemms10 %>% filter (anio == 2016 & situacion == 1)
t_masa2016 <- d_reemms11 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/99.93110124665580)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/99.93110124665580)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/99.93110124665580)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2016, startCol = 1,startRow = 17,colNames = F) ##escribir

#lectura de base 2017
bd_reemms11 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms12 <- bd_reemms11 %>% filter (anio == 2017 & situacion == 1)
t_masa2017 <- d_reemms12 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/99.73453622777890)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/99.73453622777890)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/99.73453622777890)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2017, startCol = 1,startRow = 18,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2018
bd_reemms12 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms121 <- bd_reemms12 %>% filter (anio == 2018 & situacion == 1)
t_masa2018 <- d_reemms121 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/100)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/100)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/100)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2018, startCol = 1,startRow = 19,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2019
bd_reemms13 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms122 <- bd_reemms13 %>% filter (anio == 2019 & situacion == 1)
t_masa2019 <- d_reemms122 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/99.9302340733309)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/99.9302340733309)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/99.9302340733309)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2019, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2020
bd_reemms14 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms132 <- bd_reemms14 %>% filter (anio == 2020 & situacion == 1)
t_masa2020 <- d_reemms132 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/98.9994135297337)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/98.9994135297337)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/98.9994135297337)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2020, startCol = 1,startRow = 21,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2021
bd_reemms15 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms142 <- bd_reemms15 %>% filter (anio == 2021 & situacion == 1)
t_masa2021 <- d_reemms142 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/100.927541798614)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/100.927541798614)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/100.927541798614)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2021, startCol = 1,startRow = 22,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2022
bd_reemms16 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms152 <- bd_reemms16 %>% filter (anio == 2022 & situacion == 1)
t_masa2022 <- d_reemms152 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/104.698314817064)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/104.698314817064)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/104.698314817064)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2022, startCol = 1,startRow = 23,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2023
bd_reemms17 <- bd_reem3 %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms153 <- bd_reemms17 %>% filter (anio == 2023 & situacion == 1)
t_masa2023 <- d_reemms153 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/106.108889213024)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/106.108889213024)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/106.108889213024)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2023, startCol = 1,startRow = 24,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemms, d_reemms1, t_masa2006, bd_reemms1, d_reemms2, t_masa2007, bd_reemms2)
rm(d_reemms3, t_masa2008, bd_reemms3, d_reemms4, t_masa2009, bd_reemms4, d_reemms5, bd_reemms8)
rm(t_masa2010, bd_reemms5, d_reemms6, t_masa2011, bd_reemms6, d_reemms7, t_masa2012, bd_reemms7, d_reemms8, t_masa2013)
rm(d_reemms9, t_masa2014, bd_reemms9, d_reemms10, t_masa2015, bd_reemms10, d_reemms11, t_masa2016, bd_reemms11, d_reemms12)
rm(t_masa2017, bd_reemms12, d_reemms121, t_masa2018, bd_reemms13, d_reemms122, t_masa2019, bd_reemms14, d_reemms132, t_masa2020)
rm(bd_reemms15, d_reemms142, t_masa2021, bd_reemms16, d_reemms152, t_masa2022, bd_reemms17, d_reemms153, t_masa2023)

#lectura de base 2024
bd_reemms17 <- bd_reem %>% select(remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemms153 <- bd_reemms17 %>% filter (situacion == 1)
t_masa2024 <- d_reemms153 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/106.673933930005)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/106.673933930005)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/106.673933930005)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "1.3.20",t_masa2024, startCol = 1,startRow = 25,colNames = F) ##escribir
addStyle(wb1,"1.3.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.20",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemms17, d_reemms153, t_masa2024)


#######################TABULADO 1.3.21################################
# MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM)  #
#              AÑO 2024 POR FORMA INSTITUCIONAL                 #

#Selección de variables que se requieren para el tabulado.
bd_remuneraciones <- bd_reem %>% select(remuneraciones,forma_institucional,situacion)

#cálculo#
t_remuneracionesins <- bd_remuneraciones %>% group_by(forma_institucional) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_remuneracionesins$total_remuneraciones,na.rm =T )
t_remuneracionesins$porcentaje <- t_remuneracionesins$total_remuneraciones / total

#Lectura catálogo de variables.
des_remuneracionesinst <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_remuneracionesinst,t_remuneracionesins,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remuneraciones,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.21","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.21",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.21",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.21",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.21",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.21",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_remuneraciones, t_remuneracionesins, total, des_remuneracionesinst, dft2, dft3, t_estrato1)

##########################TABULADO 1.3.22##################################
###   MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM) ### 
###              AÑO 2024 POR TAMAÑO DE EMPRESA                    ###

#Selección de variables que se requieren para el tabulado.
bd_tamano <- bd_reem %>% select(tamanoe_plazas,remuneraciones,anio,situacion)

#cálculo#
t_tamanoremu <- bd_tamano %>% group_by(tamanoe_plazas) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoremu$total_remu,na.rm =T )
t_tamanoremu$porcentaje <- t_tamanoremu$total_remu / total

#Lectura catálogo de variables.
des_tamanoremu <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoremu,t_tamanoremu,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.22","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.22",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.22",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.22",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.22",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.22",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.22",purpleStyle,cols= 5:7, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, t_tamanoremu, total, des_tamanoremu, dft2, dft3, t_estrato1)

##########################TABULADO 1.3.23##################################
###   MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM) ### 
###              AÑO 2024 POR TAMAÑO DE EMPRESA    (COP)           ###

#Selección de variables que se requieren para el tabulado.
bd_tamano <- bd_reem %>% select(tamano_cop,remuneraciones,anio,situacion)

#cálculo#
t_tamanoremu <- bd_tamano %>% group_by(tamano_cop) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoremu$total_remu,na.rm =T )
t_tamanoremu$porcentaje <- t_tamanoremu$total_remu / total

#Lectura catálogo de variables.
des_tamanoremu <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoremu,t_tamanoremu,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.23","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.23",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.23",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.23",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.23",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.23",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.23",purpleStyle,cols= 5:7, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, t_tamanoremu, total, des_tamanoremu, dft2, dft3, t_estrato1)

#############################TABULADO 1.3.24#########################
#MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM)  #
#           AÑO 2024 POR SECTOR ECONÓMICO                      #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,remuneraciones,anio,situacion)

#cálculo#
t_sectorremu<- df1 %>% group_by(gsectores) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_sectorremu$total_remu,na.rm =T )
t_sectorremu$porcentaje <- t_sectorremu$total_remu / total
                            
#Lectura catálogo de variables.
des_sectorremu <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorremu,t_sectorremu,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.24","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.24",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.24",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.24",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.24",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.24",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_sectorremu, total, des_sectorremu, dft2, dft3, t_estrato1)

###########################TABULADO 1.3.25############################
##MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM),## 
#              AÑO 2024 POR ACTIVIDAD ECONÓMICA                 #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_seccion,remuneraciones,anio,situacion)

#Cálculo de las variables.
t_seccremu <- df1 %>% group_by(codigo_seccion) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_seccremu$total_remu,na.rm =T )
t_seccremu$porcentaje <- t_seccremu$total_remu / total

#Lectura catálogo de variables.
des_seccremu <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccremu,t_seccremu,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.25","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.25",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.25",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.25",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.25",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.25",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_seccremu, total, des_seccremu, dft2, dft3, t_estrato1)

######################TABULADO 1.3.26####################################################
#MASA SALARIAL SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024 POR PROVINCIA#

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_provincia,remuneraciones,anio,situacion)

#Cálculo de las variables.
t_provremu <- df1 %>% group_by(codigo_provincia) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_provremu$total_remu,na.rm =T )
t_provremu$porcentaje <- t_provremu$total_remu / total

#Lectura catálogo de variables.
des_provremu <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provremu,t_provremu,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "1.3.26","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "1.3.26",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.26",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "1.3.26",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"1.3.26",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"1.3.26",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, t_provremu, total, des_provremu, dft2, dft3, t_estrato1)

######EMPRESAS QUE REGISTRAN VENTAS Y EMPLEO DE ACTIVIDADES PRODUCTIVAS (SE EXCLUYE SECCIONES O,P,Q)**#####
#########2.1 SECCION I: número de empresas, ventas, plazas de empleo, empleo registrado y masa salarial##################

###########################TABULADO 2.1.1###############################################
#TOTAL EMPRESAS (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), PERIODO 2011 - 2024 POR AÑO#

#BASE GENERAL 2011 
#Selección de variables que se requieren para el tabulado.
d_act <- bd_reem1 %>% select(estructura_estrat,codigo_seccion,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
d_act1 <- d_act %>% filter(estructura_estrat == 1 & anio== 2011)

#total empresas del año 2006-2011#
t_actprod <- d_act1 %>% group_by(anio) %>% summarise ("total_actprod"= n())

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.1",t_actprod, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.1",purpleStyle,cols= 1:2, rows = 6,gridExpand = TRUE,stack=TRUE)

#BASE GENERAL 2012-2023
d_act <- bd_reem3 %>% select(estructura_estrat,codigo_seccion,anio,situacion)
d_act2<- d_act %>% filter(situacion ==1 & estructura_estrat ==1 )

#total empresas del año 2012-2023
t_actprod2 <- d_act2 %>% group_by(anio) %>% summarise ("total_actprod"= n())

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.1",t_actprod2, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.1",purpleStyle,cols= 1:2, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_act, d_act1, t_actprod, d_act2, t_actprod2)

#BASE GENERAL 2024
d_act <- bd_reem %>% select(estructura_estrat,codigo_seccion,anio,situacion)
d_act2<- d_act %>% filter(situacion ==1 & estructura_estrat ==1 )

#total empresas del año 2024
t_actprod2 <- d_act2 %>% group_by(anio) %>% summarise ("total_actprod"= n())

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.1",t_actprod2, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.1",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.1",purpleStyle,cols= 1:2, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_act, d_act2, t_actprod2)

##################################TABULADO 2.1.2####################################
#EMPRESAS SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#              AÑO 2024 POR FORMA INSTITUCIONAL                                #

#Selección de variables que se requieren para el tabulado.
bd_actprod <- bd_reem %>% select(anio,codigo_seccion,estructura_estrat,forma_institucional,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reemact <- bd_actprod%>% filter(estructura_estrat ==1)

#Cálculo de las variables.
t_actfi <- bd_reemact %>% group_by (forma_institucional) %>% summarise ("total_actfi"= n(), porcentaje = 0)
total <- sum(t_actfi$total_actfi,na.rm =T )
t_actfi$porcentaje <- t_actfi$total_actfi / total

#Lectura catálogo de variables.
des_actfi <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_actfi,t_actfi,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_actfi,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.2","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.2",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.2",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.2",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.2",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.2",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_actprod, bd_reemact, t_actfi, total, des_actfi, dft2, dft3, t_estrato1)

###############################TABULADO 2.1.3#######################################
#EMPRESAS SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#                     AÑO 2024 POR TAMAÑO DE EMPRESAS                          #

#Selección de variables que se requieren para el tabulado.
bd_actprod <- bd_reem %>% select(anio,codigo_seccion,estructura_estrat,tamanoe_plazas,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reemact <- bd_actprod%>% filter(estructura_estrat ==1 )

#Cálculo de las variables.
t_tamanoat<- bd_reemact %>% group_by(tamanoe_plazas) %>% summarise ("total_at"= n(), porcentaje = 0)
total <- sum(t_tamanoat$total_at,na.rm =T )
t_tamanoat$porcentaje <- t_tamanoat$total_at / total

#Lectura catálogo de variables.
des_tamanoat <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoat,t_tamanoat,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_at,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.3","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.3",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.3",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.3",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.3",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.3",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.3",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_actprod, bd_reemact, t_tamanoat, total, des_tamanoat, dft2, dft3, t_estrato1)

###############################TABULADO 2.1.4#######################################
#EMPRESAS SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#                     AÑO 2024 POR TAMAÑO DE EMPRESAS       (COP)              #

#Selección de variables que se requieren para el tabulado.
bd_actprod <- bd_reem %>% select(anio,codigo_seccion,estructura_estrat,tamano_cop,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reemact <- bd_actprod%>% filter(estructura_estrat ==1 )

#Cálculo de las variables.
t_tamanoat<- bd_reemact %>% group_by(tamano_cop) %>% summarise ("total_at"= n(), porcentaje = 0)
total <- sum(t_tamanoat$total_at,na.rm =T )
t_tamanoat$porcentaje <- t_tamanoat$total_at / total

#Lectura catálogo de variables.
des_tamanoat <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoat,t_tamanoat,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_at,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.4","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.4",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.4",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.4",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.4",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.4",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.4",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_actprod, bd_reemact, t_tamanoat, total, des_tamanoat, dft2, dft3, t_estrato1)

#################TABULADO 2.1.5######################################################
#EMPRESAS SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS) #
#           AÑO 2024 POR SECTOR ECONÓMICO                                       #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(gsectores,codigo_seccion,estructura_estrat,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#Cálculo de las variables.
t_sectorap<- bd_reemact %>% group_by(gsectores) %>% summarise ("total_ap"= n(), porcentaje = 0)
total <- sum(t_sectorap$total_ap,na.rm =T )
t_sectorap$porcentaje <- t_sectorap$total_ap / total

#Lectura catálogo de variables.
des_sectorap <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorap,t_sectorap,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ap,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.5","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.5",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.5",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.5",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.5",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.5",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_sectorap, total, des_sectorap, dft2, dft3, t_estrato1)

#########################TABULADO 2.1.6#############################################
#EMPRESAS SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#                     AÑO 2024, POR ACTIVIDAD ECONÓMICA                        #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_seccion,estructura_estrat,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#Cálculo de las variables
t_seccap<- bd_reemact %>% group_by(codigo_seccion) %>% summarise ("total_ap"= n(), porcentaje = 0)
total <- sum(t_seccap$total_ap,na.rm =T )
t_seccap$porcentaje <- t_seccap$total_ap / total

#Lectura catálogo de variables.
des_seccap <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccap,t_seccap,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ap,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.6","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.6",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.6",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.6",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.6",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.6",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_seccap, total, des_seccap, dft2, dft3, t_estrato1)

#######################TABULADO 2.1.7###############################################
#EMPRESAS SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#              AÑO 2024 POR PROVINCIA                                          #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_provincia,codigo_seccion,estructura_estrat,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#Cálculo de las variables
t_provap <- bd_reemact %>% group_by(codigo_provincia) %>% summarise ("total_ap"= n(), porcentaje = 0)
total <- sum(t_provap$total_ap,na.rm =T )
t_provap$porcentaje <- t_provap$total_ap / total

#Lectura catálogo de variables.
des_provap <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provap,t_provap,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ap,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.7","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.7",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.7",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.7",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.7",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.7",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_provap, total, des_provap, dft2, dft3, t_estrato1)

##########################TABULADO 2.1.8####################
#VENTAS TOTALES (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)  #       
#             PERIODO 2011 - 2024 POR AÑO              #

#Selección de variables que se requieren para el tabulado.
##BASE GENERAL 2011###
d_act <- bd_reem1 %>% select(estructura_estrat,codigo_seccion,ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_excact <- d_act %>% filter (estructura_estrat == 1, situacion ==1 , anio ==2011)

#total empresas del año 2006-2011#
t_actprod1 <- d_excact %>% group_by(anio) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.8",t_actprod1, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.8",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.8",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    #total empresas del año 2009 - 2011#
    t_nacional1 <- d_excact %>% group_by(anio) %>% summarise ("total_ventanacional"=sum(ventas_nacionales,na.rm=T))
    t_nacional2 <- t_nacional1 %>% select(total_ventanacional)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.8",t_nacional2, startCol = 3,startRow = 7,colNames = F) ##escribir

    #EXPORTACIONES#
    #total empresas del año 2009 - 2011#
    t_expprod1 <- d_excact %>% group_by(anio) %>% summarise ("total_exportaciones"=sum(exportaciones_netas,na.rm=T))
    t_expprod2 <- t_expprod1 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.8",t_expprod2, startCol = 4,startRow = 7,colNames = F) ##escribir

##BASE GENERAL 2012-2023###
d_act1 <- bd_reem3 %>% select(estructura_estrat,codigo_seccion,ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_excact <- d_act1 %>% filter (estructura_estrat == 1, situacion ==1 )

#total empresas del año 2012-2023#
t_actprod <- d_excact %>% group_by(anio) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.8",t_actprod, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.8",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.8",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    #total empresas del año 2012 - 2023#
    t_vntanacional1_1 <- d_excact %>% group_by(anio) %>% summarise ("total_ventanacional"=sum(ventas_nacionales,na.rm=T))
    t_vntanacional2_2 <- t_vntanacional1_1 %>% select(total_ventanacional)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.8",t_vntanacional2_2, startCol = 3,startRow = 8,colNames = F) ##escribir

    #EXPORTACIONES#
    #total empresas del año 2012 - 2023#
    t_exp1_1 <- d_excact %>% group_by(anio) %>% summarise ("total_exportaciones"=sum(exportaciones_netas,na.rm=T))
    t_exp2_2 <- t_exp1_1 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.8",t_exp2_2, startCol = 4,startRow = 8,colNames = F) ##escribir

rm(d_act, d_excact, t_actprod1, t_nacional1, t_nacional2, t_expprod1, t_expprod2, d_act1, t_actprod, t_vntanacional1_1, t_vntanacional2_2, t_exp1_1, t_exp2_2)

##BASE GENERAL 2024###
d_act1 <- bd_reem %>% select(estructura_estrat,codigo_seccion,ventas_totales,anio,situacion,ventas_nacionales,exportaciones_netas)
d_excact <- d_act1 %>% filter (estructura_estrat == 1, situacion ==1 )

#total empresas del año 2024#
t_actprod <- d_excact %>% group_by(anio) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.8",t_actprod, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.8",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.8",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS NACIONALES#
#total empresas del año 22024#
t_vntanacional1_1 <- d_excact %>% group_by(anio) %>% summarise ("total_ventanacional"=sum(ventas_nacionales,na.rm=T))
t_vntanacional2_2 <- t_vntanacional1_1 %>% select(total_ventanacional)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.8",t_vntanacional2_2, startCol = 3,startRow = 20,colNames = F) ##escribir

#EXPORTACIONES#
#total empresas del año 2024#
t_exp1_1 <- d_excact %>% group_by(anio) %>% summarise ("total_exportaciones"=sum(exportaciones_netas,na.rm=T))
t_exp2_2 <- t_exp1_1 %>% select(total_exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.8",t_exp2_2, startCol = 4,startRow = 20,colNames = F) ##escribir

rm(d_excact, d_act1, t_actprod, t_vntanacional1_1, t_vntanacional2_2, t_exp1_1, t_exp2_2)

#####################TABULADO 2.1.9 (CONSTANTES)################################
#VENTAS TOTALES (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), PERIODO 2011 - 2024##

#lectura de base 2011
bd_reemap <- bd_reem1 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap <- bd_reemap %>% filter (anio == 2011 & situacion == 1&estructura_estrat==1)
t_ventas2011 <- d_reemap %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/92.4871544904257)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2011, startCol = 1,startRow = 7,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_vntnacional2011 <- d_reemap %>% summarise ("total_ventas"=sum((ventas_nacionales/92.4871544904257)*100,na.rm=T))
    t_vntnacional11<- t_vntnacional2011 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional11, startCol = 3,startRow = 7,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2011 <- d_reemap %>% summarise ("total_exportaciones"=sum((exportaciones_netas/92.4871544904257)*100,na.rm=T))
    t_export11 <- t_export2011 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export11, startCol = 4,startRow = 7,colNames = F) ##escribir

#lectura de base 2012
bd_reemap1 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap1 <- bd_reemap1 %>% filter (anio == 2012 & situacion == 1 & estructura_estrat==1)
t_ventas2012 <- d_reemap1 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/97.1145052821589)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2012, startCol = 1,startRow = 8,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_vntnacional2012 <- d_reemap1 %>% summarise ("total_ventas"=sum((ventas_nacionales/97.1145052821589)*100,na.rm=T))
    t_vntnacional12<- t_vntnacional2012 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional12, startCol = 3,startRow = 8,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2012 <- d_reemap1 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/97.1145052821589)*100,na.rm=T))
    t_export12 <- t_export2012 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export12, startCol = 4,startRow = 8,colNames = F) ##escribir

rm(bd_reemap, d_reemap, t_ventas2011, t_vntnacional2011, t_vntnacional11, t_export2011, t_export11)
rm(bd_reemap1, d_reemap1, t_ventas2012, t_vntnacional2012, t_vntnacional12, t_export2012, t_export12)

#lectura de base 2013
bd_reemap2 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap2 <- bd_reemap2 %>% filter (anio == 2013 & situacion == 1 & estructura_estrat==1)
t_ventas2013 <- d_reemap2 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/99.704421757685)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2013, startCol = 1,startRow = 9,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_vntnacional2013 <- d_reemap2 %>% summarise ("total_ventas"=sum((ventas_nacionales/99.704421757685)*100,na.rm=T))
    t_vntnacional13<- t_vntnacional2013 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional13, startCol = 3,startRow = 9,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2013 <- d_reemap2 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/99.704421757685)*100,na.rm=T))
    t_export13 <- t_export2013 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export13, startCol = 4,startRow = 9,colNames = F) ##escribir

#lectura de base 2014
bd_reemap3 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap3 <- bd_reemap3 %>% filter (anio == 2014 & situacion == 1 & estructura_estrat==1)
t_ventas2014 <- d_reemap3 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/101.75131247565)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2014, startCol = 1,startRow = 10,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_vntnacional2014 <- d_reemap3 %>% summarise ("total_ventas"=sum((ventas_nacionales/101.75131247565)*100,na.rm=T))
    t_vntnacional14<- t_vntnacional2014 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional14, startCol = 3,startRow = 10,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2014 <- d_reemap3 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/101.75131247565)*100,na.rm=T))
    t_export14 <- t_export2014 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export14, startCol = 4,startRow = 10,colNames = F) ##escribir

rm(bd_reemap2, d_reemap2, t_ventas2013, t_vntnacional2013, t_vntnacional13, t_export2013, t_export13)
rm(bd_reemap3, d_reemap3, t_ventas2014, t_vntnacional2014, t_vntnacional14, t_export2014, t_export14)

#lectura de base 2015
bd_reemap4 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap4 <- bd_reemap4 %>% filter (anio == 2015 & situacion == 1 & estructura_estrat==1)
t_ventas2015 <- d_reemap4 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/96.1797845146234)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2015, startCol = 1,startRow = 11,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_vntnacional2015 <- d_reemap4 %>% summarise ("total_ventas"=sum((ventas_nacionales/96.1797845146234)*100,na.rm=T))
    t_vntnacional15<- t_vntnacional2015 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional15, startCol = 3,startRow = 11,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2015 <- d_reemap4 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/96.1797845146234)*100,na.rm=T))
    t_export15 <- t_export2015 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export15, startCol = 4,startRow = 11,colNames = F) ##escribir

#lectura de base 2016
bd_reemap5 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap5 <- bd_reemap5 %>% filter (anio == 2016 & situacion == 1 & estructura_estrat==1)
t_ventas2016 <- d_reemap5 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/97.3061899862597)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2016, startCol = 1,startRow = 12,colNames = F) ##escribir

    #VENTAS NACIONALES#
    t_vntnacional2016 <- d_reemap5 %>% summarise ("total_ventas"=sum((ventas_nacionales/97.3061899862597)*100,na.rm=T))
    t_vntnacional16<- t_vntnacional2016 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional16, startCol = 3,startRow = 12,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2016 <- d_reemap5 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/97.3061899862597)*100,na.rm=T))
    t_export16 <- t_export2016 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export16, startCol = 4,startRow = 12,colNames = F) ##escribir

#lectura de base 2017
bd_reemap6 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap6 <- bd_reemap6 %>% filter (anio == 2017 & situacion == 1 & estructura_estrat==1)
t_ventas2017 <- d_reemap6 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/98.2131134656989)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2017, startCol = 1,startRow = 13,colNames = F) ##escribir
addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2017 <- d_reemap6 %>% summarise ("total_ventas"=sum((ventas_nacionales/98.2131134656989)*100,na.rm=T))
    t_vntnacional17<- t_vntnacional2017 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional17, startCol = 3,startRow = 13,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2017 <- d_reemap6 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/98.2131134656989)*100,na.rm=T))
    t_export17 <- t_export2017 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export17, startCol = 4,startRow = 13,colNames = F) ##escribir

rm(bd_reemap4, d_reemap4, t_ventas2015, t_vntnacional2015, t_vntnacional15, t_export2015, t_export15)
rm(bd_reemap5, d_reemap5, t_ventas2016, t_vntnacional2016, t_vntnacional16, t_export2016, t_export16)
rm(bd_reemap6, d_reemap6, t_ventas2017, t_vntnacional2017, t_vntnacional17, t_export2017, t_export17)

#lectura de base 2018
bd_reemap7 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap7 <- bd_reemap7 %>% filter (anio == 2018 & situacion == 1 & estructura_estrat==1)
t_ventas2018 <- d_reemap7 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/100)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2018, startCol = 1,startRow = 14,colNames = F) ##escribir
addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2018 <- d_reemap7 %>% summarise ("total_ventas"=sum((ventas_nacionales/100)*100,na.rm=T))
    t_vntnacional18<- t_vntnacional2018 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional18, startCol = 3,startRow = 14,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2018 <- d_reemap7 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/100)*100,na.rm=T))
    t_export18 <- t_export2018 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export18, startCol = 4,startRow = 14,colNames = F) ##escribir

#lectura de base 2019
bd_reemap8 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap8 <- bd_reemap8 %>% filter (anio == 2019 & situacion == 1 & estructura_estrat==1)
t_ventas2019 <- d_reemap8 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/99.9434257416061)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2019, startCol = 1,startRow = 15,colNames = F) ##escribir
addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2019 <- d_reemap8 %>% summarise ("total_ventas"=sum((ventas_nacionales/99.9434257416061)*100,na.rm=T))
    t_vntnacional19<- t_vntnacional2019 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional19, startCol = 3,startRow = 15,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2019 <- d_reemap8 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/99.9434257416061)*100,na.rm=T))
    t_export19 <- t_export2019 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export19, startCol = 4,startRow = 15,colNames = F) ##escribir

#lectura de base 2020
    bd_reemap9 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
    d_reemap9 <- bd_reemap9 %>% filter (anio == 2020 & situacion == 1 & estructura_estrat==1)
    t_ventas2020 <- d_reemap9 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/98.1185022495001)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_ventas2020, startCol = 1,startRow = 16,colNames = F) ##escribir
    addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
    addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2020 <- d_reemap9 %>% summarise ("total_ventas"=sum((ventas_nacionales/98.1185022495001)*100,na.rm=T))
    t_vntnacional20<- t_vntnacional2020 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional20, startCol = 3,startRow = 16,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2020 <- d_reemap9 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/98.1185022495001)*100,na.rm=T))
    t_export20 <- t_export2020 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export20, startCol = 4,startRow = 16,colNames = F) ##escribir

#lectura de base 2021
    bd_reemap10 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
    d_reemap10 <- bd_reemap10 %>% filter (anio == 2021 & situacion == 1 & estructura_estrat==1)
    t_ventas2021 <- d_reemap10 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/100.252328548402)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_ventas2021, startCol = 1,startRow = 17,colNames = F) ##escribir
    addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
    addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2021 <- d_reemap10 %>% summarise ("total_ventas"=sum((ventas_nacionales/100.252328548402)*100,na.rm=T))
    t_vntnacional21<- t_vntnacional2021 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional21, startCol = 3,startRow = 17,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2021 <- d_reemap10 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/100.252328548402)*100,na.rm=T))
    t_export21 <- t_export2021 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export21, startCol = 4,startRow = 17,colNames = F) ##escribir

#lectura de base 2022
    bd_reemap11 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
    d_reemap11 <- bd_reemap11 %>% filter (anio == 2022 & situacion == 1 & estructura_estrat==1)
    t_ventas2022 <- d_reemap11 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/102.606321845514)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_ventas2022, startCol = 1,startRow = 18,colNames = F) ##escribir
    addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
    addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2022 <- d_reemap11 %>% summarise ("total_ventas"=sum((ventas_nacionales/102.606321845514)*100,na.rm=T))
    t_vntnacional22<- t_vntnacional2022 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional22, startCol = 3,startRow = 18,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2022 <- d_reemap11 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/102.606321845514)*100,na.rm=T))
    t_export22 <- t_export2022 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export22, startCol = 4,startRow = 18,colNames = F) ##escribir

#lectura de base 2023
    bd_reemap12 <- bd_reem3 %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
    d_reemap12 <- bd_reemap12 %>% filter (anio == 2023 & situacion == 1 & estructura_estrat==1)
    t_ventas2023 <- d_reemap12 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/104.949603244225)*100,na.rm=T))
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_ventas2023, startCol = 1,startRow = 19,colNames = F) ##escribir
    addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
    addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

    #VENTAS NACIONALES#
    t_vntnacional2023 <- d_reemap12 %>% summarise ("total_ventas"=sum((ventas_nacionales/104.949603244225)*100,na.rm=T))
    t_vntnacional23<- t_vntnacional2023 %>% select(total_ventas)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_vntnacional23, startCol = 3,startRow = 19,colNames = F) ##escribir

    #EXPORTACIONES#
    t_export2023 <- d_reemap12 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/104.949603244225)*100,na.rm=T))
    t_export23 <- t_export2023 %>% select(total_exportaciones)
    
    #Exportar resultados a excel
    writeData(wb1,sheet = "2.1.9",t_export23, startCol = 4,startRow = 19,colNames = F) ##escribir

rm(bd_reemap7, d_reemap7, t_ventas2018, t_vntnacional2018, t_vntnacional18, t_export2018, t_export18)
rm(bd_reemap8, d_reemap8, t_ventas2019, t_vntnacional2019, t_vntnacional19, t_export2019, t_export19)
rm(bd_reemap9, d_reemap9, t_ventas2020, t_vntnacional2020, t_vntnacional20, t_export2020, t_export20)
rm(bd_reemap10, d_reemap10, t_ventas2021, t_vntnacional2021, t_vntnacional21, t_export2021, t_export21)
rm(bd_reemap11, d_reemap11, t_ventas2022, t_vntnacional2022, t_vntnacional22, t_export2022, t_export22)
rm(bd_reemap12, d_reemap12, t_ventas2023, t_vntnacional2023, t_vntnacional23, t_export2023, t_export23) 

#lectura de base 2024
bd_reemap12 <- bd_reem %>% select(ventas_totales,anio,situacion,estructura_estrat,ventas_nacionales,exportaciones_netas)
d_reemap12 <- bd_reemap12 %>% filter (situacion == 1 & estructura_estrat==1)
t_ventas2024 <- d_reemap12 %>% group_by(anio) %>% summarise ("total_ventas"=sum((ventas_totales/110.212419827962)*100,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_ventas2024, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.9",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.9",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#VENTAS NACIONALES#
t_vntnacional2024 <- d_reemap12 %>% summarise ("total_ventas"=sum((ventas_nacionales/110.212419827962)*100,na.rm=T))
t_vntnacional24<- t_vntnacional2024 %>% select(total_ventas)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_vntnacional24, startCol = 3,startRow = 20,colNames = F) ##escribir

#EXPORTACIONES#
t_export2024 <- d_reemap12 %>% summarise ("total_exportaciones"=sum((exportaciones_netas/110.212419827962)*100,na.rm=T))
t_export24 <- t_export2024 %>% select(total_exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.9",t_export24, startCol = 4,startRow = 20,colNames = F) ##escribir

rm(bd_reemap12, d_reemap12, t_ventas2024, t_vntnacional2024, t_vntnacional24, t_export2024, t_export24) 

################################TABULADO 2.1.10############################################
#VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#                       AÑO 2024 POR FORMA INSTITUCIONAL                             #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_seccion,estructura_estrat,forma_institucional,ventas_totales,anio,situacion)
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#Cálculo de las variables
t_seccventas <- bd_reemact %>% group_by(forma_institucional) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_seccventas$total_ventas,na.rm =T )
t_seccventas$porcentaje <- t_seccventas$total_ventas / total

#Lectura catálogo de variables.
des_seccventas <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccventas,t_seccventas,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.10","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.10",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.10",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.10",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.10",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.10",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_seccventas, total, des_seccventas, dft2, dft3, t_estrato1)

#################################TABULADO 2.1.11###########################################
# VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS#
#                AÑO 2024 POR TAMAÑO DE  EMPRESA                                     #

#selección de variables###
bd_tamano <- bd_reem %>% select(tamanoe_plazas,ventas_totales,estructura_estrat,codigo_seccion,anio,situacion)
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#cálculo#
t_tamanovp <- bd_reemact %>% group_by(tamanoe_plazas) %>% summarise ("total_vp"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_tamanovp$total_vp,na.rm =T )
t_tamanovp$porcentaje <- t_tamanovp$total_vp/ total

#Lectura catálogo de variables.
des_tamanovp <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

##Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanovp,t_tamanovp,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_vp,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

v_total <- c("TOTAL",total,"100.00%")
v_total <- matrix(v_total,nrow=1,ncol=3)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.11","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.11",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.11",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.11",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.11",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.11",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.11",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_tamanovp, total, des_tamanovp, dft2, dft3, t_estrato1, v_total)

#################################TABULADO 2.1.12###########################################
# VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS#
#                AÑO 2024 POR TAMAÑO DE  EMPRESA (COP)                               #

#selección de variables###
bd_tamano <- bd_reem %>% select(tamano_cop,ventas_totales,estructura_estrat,codigo_seccion,anio,situacion)
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#cálculo#
t_tamanovp <- bd_reemact %>% group_by(tamano_cop) %>% summarise ("total_vp"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_tamanovp$total_vp,na.rm =T )
t_tamanovp$porcentaje <- t_tamanovp$total_vp/ total

#Lectura catálogo de variables.
des_tamanovp <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanovp,t_tamanovp,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_vp,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

v_total <- c("TOTAL",total,"100.00%")
v_total <- matrix(v_total,nrow=1,ncol=3)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.12","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.12",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.12",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.12",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.12",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.12",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.12",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_tamanovp, total, des_tamanovp, dft2, dft3, t_estrato1, v_total)

##################TABULADO 2.1.13##########################################################
#VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#                   AÑO 2024 POR SECTOR ECONÓMICO                                    #

#selección de variables
bd_tamano <- bd_reem %>% select(gsectores,ventas_totales,estructura_estrat,codigo_seccion,anio,situacion)
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#Cálculo de las variables
t_sectoresvp <- bd_reemact %>% group_by(gsectores) %>% summarise ("total_secvp"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_sectoresvp$total_secvp,na.rm =T )
t_sectoresvp$porcentaje <- t_sectoresvp$total_secvp/ total

#Lectura catálogo de variables.
des_sectoresvp <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectoresvp,t_sectoresvp,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_secvp,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.13","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.13",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.13",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.13",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.13",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.13",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_sectoresvp, total, des_sectoresvp, dft2, dft3, t_estrato1)

##########################TABULADO 2.1.14##################################################
#VENTAS TOTALES SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#                       AÑO 2024, POR ACTIVIDAD ECONÓMICA                            # 

#selección de variables###
bd_tamano <- bd_reem %>% select(codigo_seccion,ventas_totales,estructura_estrat,anio,situacion)
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#cálculo#
t_seccap <- bd_reemact %>% group_by(codigo_seccion) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_seccap$total_ventas,na.rm =T )
t_seccap$porcentaje <- t_seccap$total_ventas / total

#Lectura catálogo de variables.
des_seccap <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccap,t_seccap,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.14","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.14",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.14",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.14",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.14",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.14",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_seccap, total, des_seccap, dft2, dft3, t_estrato1)

################################TABULADO 2.1.15##########################################
#VENTAS TOTALES SEGÚN PARTICIPACIÓN NACIONAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS) #
#                AÑO 2024 POR PROVINCIA                                            #

df1 <- bd_reem %>% select(codigo_provincia,codigo_seccion,ventas_totales,estructura_estrat,anio,situacion)
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#cálculo#
t_provap <- bd_reemact %>% group_by(codigo_provincia) %>% summarise ("total_ventas"=sum(ventas_totales,na.rm=T), porcentaje = 0)
total <- sum(t_provap$total_ventas,na.rm =T )
t_provap$porcentaje <- t_provap$total_ventas / total

#Lectura catálogo de variables.
des_provap <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provap,t_provap,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_ventas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.15","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.15",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.15",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.15",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.15",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.15",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_provap, total, des_provap, dft2, dft3, t_estrato1)

##########################TABULADO 2.1.16####################
#VENTAS TOTALES (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)  #       
#                        DESDE AÑO 2023                     #

#AÑO 2023
#Selección de variables que se requieren para el tabulado.
d_act1_cx0 <- bd_reem3 %>% filter (anio == 2023)
d_act1_cx <- d_act1_cx0 %>% select(estructura_estrat,codigo_seccion,importaciones, exportaciones, anio,situacion)
d_excact_cx <- d_act1_cx %>% filter (estructura_estrat == 1, situacion ==1 )

#IMPORTACIONES#
t_actprod7_cx <- d_excact_cx %>% group_by(anio) %>% summarise ("total_importaciones"=sum(importaciones,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.16",t_actprod7_cx, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.16",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.16",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

#EXPORTACIONES#
t_exp1_4_cx <- d_excact_cx %>% group_by(anio) %>% summarise ("exportaciones"=sum(exportaciones,na.rm=T))
t_exp2_5_cx <- t_exp1_4_cx %>% select(exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.16",t_exp2_5_cx, startCol = 3,startRow = 7,colNames = F) ##escribir

rm(d_act1_cx, d_excact_cx, t_actprod7_cx, t_exp1_4_cx, t_exp2_5_cx, d_act1_cx0)


#AÑO 2024
#Selección de variables que se requieren para el tabulado.
d_act1_cx <- bd_reem %>% select(estructura_estrat,codigo_seccion,importaciones, exportaciones, anio,situacion)
d_excact_cx <- d_act1_cx %>% filter (estructura_estrat == 1, situacion ==1 )

#IMPORTACIONES#
t_actprod7_cx <- d_excact_cx %>% group_by(anio) %>% summarise ("total_importaciones"=sum(importaciones,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.16",t_actprod7_cx, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.16",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.16",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

#EXPORTACIONES#
t_exp1_4_cx <- d_excact_cx %>% group_by(anio) %>% summarise ("exportaciones"=sum(exportaciones,na.rm=T))
t_exp2_5_cx <- t_exp1_4_cx %>% select(exportaciones)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.16",t_exp2_5_cx, startCol = 3,startRow = 8,colNames = F) ##escribir

rm(d_act1_cx, d_excact_cx, t_actprod7_cx, t_exp1_4_cx, t_exp2_5_cx)

########################TABULADO 2.1.17#################################
#PLAZAS DE EMPLEO REGISTRADO (EMPRESAS CON ACTIVIDADES PRODUCTIVAS) #                  
#                   PERIODO 2011 - 2024 POR AÑO                   #

#######PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM) PERIODO 2006-2011

d_plazas <- bd_reem1 %>% select(estructura_estrat,plazas_equiv,plazas_equiv_hombres,plazas_equiv_mujeres,anio,situacion)
bd_plazas <- d_plazas %>% filter(anio == 2011 & situacion==1 & estructura_estrat ==1)

#total empresas del año 2012-2023#
t_plazas <- bd_plazas %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                       "total_plazashombres" =sum(plazas_equiv_hombres,na.rm=T),
                                                       "total_plazasmujeres"=sum(plazas_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.17",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.17",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.17",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_plazas, bd_plazas, t_plazas)

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), PERIODO 2012 - 2023 POR AÑO

d_plazas <- bd_reem3 %>% select(estructura_estrat,plazas_equiv,plazas_equiv_hombres,plazas_equiv_mujeres,anio,situacion)
bd_plazas <- d_plazas %>% filter(situacion==1 & estructura_estrat ==1)

#total empresas del año 2012-2023#
t_plazas <- bd_plazas %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                       "total_plazashombres" =sum(plazas_equiv_hombres,na.rm=T),
                                                       "total_plazasmujeres"=sum(plazas_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.17",t_plazas, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.17",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.17",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_plazas, bd_plazas, t_plazas)

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024

d_plazas <- bd_reem %>% select(estructura_estrat,plazas_equiv,plazas_equiv_hombres,plazas_equiv_mujeres,anio,situacion)
bd_plazas <- d_plazas %>% filter(situacion==1 & estructura_estrat ==1)

#total empresas del año 2024#
t_plazas <- bd_plazas %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                        "total_plazashombres" =sum(plazas_equiv_hombres,na.rm=T),
                                                        "total_plazasmujeres"=sum(plazas_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.17",t_plazas, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.17",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.17",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_plazas, bd_plazas, t_plazas)

########################TABULADO 2.1.18#################################
#PLAZAS DE EMPLEO REGISTRADO (EMPRESAS CON ACTIVIDADES PRODUCTIVAS) #                  
#                   DESDE AÑO 2023 POR NACIONALIDAD             #

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2023

d_plazas <- bd_reem3 %>% select(estructura_estrat,plazas_equiv,plazas_nacionales_equiv,plazas_extranjeros_equiv,anio,situacion)
bd_plazas <- d_plazas %>% filter(anio == 2023 & situacion==1 & estructura_estrat ==1)

#total empresas del año 2024#
t_plazas <- bd_plazas %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                        "total_plazasnacionales"=sum(plazas_nacionales_equiv,na.rm=T),
                                                        "total_plazasextranjeros"=sum(plazas_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.18",t_plazas, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.18",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.18",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_plazas, bd_plazas, t_plazas)

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024

d_plazas <- bd_reem %>% select(estructura_estrat,plazas_equiv,plazas_nacionales_equiv,plazas_extranjeros_equiv,anio,situacion)
bd_plazas <- d_plazas %>% filter(situacion==1 & estructura_estrat ==1)

#total empresas del año 2024#
t_plazas <- bd_plazas %>% group_by(anio) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T),
                                                        "total_plazasnacionales"=sum(plazas_nacionales_equiv,na.rm=T),
                                                        "total_plazasextranjeros"=sum(plazas_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.18",t_plazas, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.18",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.18",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_plazas, bd_plazas, t_plazas)

####################################TABULADO 2.1.19#############################
#    PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL           #
#    (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR RANGO DE EDAD    #

bd_reemact <- bd_reem%>% filter(estructura_estrat ==1 )

#selección de variables
bd_plazasrp <- bd_reemact %>% select(plazas_rango_edad_1,plazas_rango_edad_2,
                                    plazas_rango_edad_3,plazas_rango_edad_4, 
                                    plazas_rango_edad_5,estructura_estrat,
                                    anio,situacion)


#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_plazasrp %>% filter(estructura_estrat==1)

#Cálculo de las variables.
t_plazasre1 <- bd_plazasrp %>% summarise ("total_plazas"=sum(plazas_rango_edad_1,na.rm=T), porcentaje = 0)
t_plazasre2 <- bd_plazasrp %>% summarise ("total_plazas"=sum(plazas_rango_edad_2,na.rm=T), porcentaje = 0)
t_plazasre3 <- bd_plazasrp %>% summarise ("total_plazas"=sum(plazas_rango_edad_3,na.rm=T), porcentaje = 0)
t_plazasre4 <- bd_plazasrp %>% summarise ("total_plazas"=sum(plazas_rango_edad_4,na.rm=T), porcentaje = 0)
t_plazasre5 <- bd_plazasrp %>% summarise ("total_plazas"=sum(plazas_rango_edad_5,na.rm=T), porcentaje = 0)

t_rangos1 = data.frame(new.row.names = "RANGO DE EDAD 1", rbind(t_plazasre1))
t_rangos2 = data.frame(new.row.names = "RANGO DE EDAD 2", rbind(t_plazasre2))
t_rangos3 = data.frame(new.row.names = "RANGO DE EDAD 3", rbind(t_plazasre3))
t_rangos4 = data.frame(new.row.names = "RANGO DE EDAD 4", rbind(t_plazasre4))
t_rangos5 = data.frame(new.row.names = "RANGO DE EDAD 5", rbind(t_plazasre5))

tabla1 <- data.frame (rbind(t_rangos1,t_rangos2,t_rangos3, t_rangos4, t_rangos5))
total <- sum(tabla1$total_plazas,na.rm = T)
tabla1$porcentaje <- tabla1$total_plazas/total

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.19","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.19",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.19",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.19",tabla1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.19",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.19",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.19",purpleStyle,cols= 6:7, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemact, bd_plazasrp, t_plazasre1, t_plazasre2, t_plazasre3, t_plazasre4, t_plazasre5, t_rangos1, t_rangos2, t_rangos3, t_rangos4, t_rangos5, tabla1, total)

####################################TABULADO 2.1.20#############################
#      PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL          #
# (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR FORMA INSTITUCIONAL#

#selección de variables###
df1 <- bd_reem %>% select(codigo_seccion,estructura_estrat,forma_institucional,plazas_equiv,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#Cálculo de las variables.
t_plazasins <- bd_reemact %>% group_by(forma_institucional) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_plazasins$total_plazas,na.rm =T )
t_plazasins$porcentaje <- t_plazasins$total_plazas / total

#Lectura catálogo de variables.
des_plazasinst <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_plazasinst,t_plazasins,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.20","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.20",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.20",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.20",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.20",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.20",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_plazasins, total, des_plazasinst, dft2, dft3, t_estrato1)

#################################TABULADO 2.1.21###############################
#      PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL         #
# (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR TAMAÑO DE EMPRESA #

#selección de variables
bd_tamano <- bd_reem %>% select(tamanoe_plazas,plazas_equiv,estructura_estrat,codigo_seccion,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#Cálculo de las variables
t_tamanoplazas <- bd_reemact %>% group_by(tamanoe_plazas) %>% summarise ("total_vp"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoplazas$total_vp,na.rm =T )
t_tamanoplazas$porcentaje <- t_tamanoplazas$total_vp/ total

#Lectura catálogo de variables.
des_tamanoplazas <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoplazas,t_tamanoplazas,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_vp,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.21","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.21",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.21",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.21",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.21",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.21",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.21",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_tamanoplazas, total, des_tamanoplazas, dft2, dft3, t_estrato1)

#################################TABULADO 2.1.22#####################################
#      PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL               #
# (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR TAMAÑO DE EMPRESA (COP) #

#selección de variables
bd_tamano <- bd_reem %>% select(tamano_cop,plazas_equiv,estructura_estrat,codigo_seccion,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#Cálculo de las variables
t_tamanocop <- bd_reemact %>% group_by(tamano_cop) %>% summarise ("total_vp"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamanocop$total_vp,na.rm =T )
t_tamanocop$porcentaje <- t_tamanocop$total_vp/ total

#Lectura catálogo de variables.
des_tamanoplazas <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoplazas,t_tamanocop,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_vp,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.22","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.22",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.22",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.22",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.22",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.22",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.22",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_tamanocop, total, des_tamanoplazas, dft2, dft3, t_estrato1)

#########################TABULADO 2.1.23######################################
#       PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL       #
#(EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR SECTOR ECONÓMICO  #

#selección de variables
bd_sector <- bd_reem %>% select(gsectores,plazas_equiv,estructura_estrat,codigo_seccion,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_sector %>% filter(estructura_estrat==1)

#Cálculo de las variables.
t_sectoresvp <- bd_reemact %>% group_by(gsectores) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_sectoresvp$total_plazas,na.rm =T )
t_sectoresvp$porcentaje <- t_sectoresvp$total_plazas/ total

#Lectura catálogo de variables.
des_sectoresvp <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectoresvp,t_sectoresvp,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))
v_total <- c("TOTAL",total,"100.00%")
v_total <- matrix(v_total,nrow=1,ncol=3)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.23","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.23",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.23",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.23",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.23",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.23",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_sector, bd_reemact, t_sectoresvp, total, des_sectoresvp, dft2, dft3, t_estrato1, v_total)

##############################TABULADO 2.1.24##################################
#   PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL            #
#(EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR ACTIVIDAD ECONÓMICA#

#selección de variables###
bd_act <- bd_reem %>% select(codigo_seccion,plazas_equiv,estructura_estrat,anio,situacion)
bd_reemact <- bd_act %>% filter(estructura_estrat==1)

#cálculo#
t_secact <- bd_reemact %>% group_by(codigo_seccion) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_secact$total_plazas,na.rm =T )
t_secact$porcentaje <- t_secact$total_plazas / total

#Lectura catálogo de variables.
des_secact <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_secact,t_secact,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.24","TOTAL", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.24",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.24",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.24",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.24",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.24",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_act, bd_reemact, t_secact, total, des_secact, dft2, dft3, t_estrato1)

####################TABULADO 2.1.25######################################
#      PLAZAS DE EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN NACIONAL      #
# (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR PROVINCIA   #

df1 <- bd_reem %>% select(codigo_provincia,codigo_seccion,plazas_equiv,estructura_estrat,anio,situacion)
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#cálculo#
t_provap <- bd_reemact %>% group_by(codigo_provincia) %>% summarise ("total_plazas"=sum(plazas_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_provap$total_plazas,na.rm =T )
t_provap$porcentaje <- t_provap$total_plazas / total

#Lectura catálogo de variables.
des_provap <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provap,t_provap,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_plazas,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.25","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.25",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.25",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.25",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.25",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.25",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_provap, total, des_provap, dft2, dft3, t_estrato1)

######################## TABULADO 2.1.26##########################################
#EMPLEO REGISTRADO (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), PERIODO 2011 - 2024#

# EMPLEO (UNIVERSO REEM) PERIODO 2006-2011
#Selección de variables que se requieren para el tabulado.
d_empleo <- bd_reem1 %>% select(estructura_estrat,empleo_equiv,empleo_equiv_hombres,empleo_equiv_mujeres,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_empleo <- d_empleo %>% filter(anio == 2011 & situacion==1 & estructura_estrat ==1)

#total empresas del año 2006-2011#
t_empleo <- bd_empleo %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                        "total_empleohombres" =sum(empleo_equiv_hombres,na.rm=T),
                                                        "total_empleomujeres"=sum(empleo_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.26",t_empleo, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.26",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.26",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_empleo, bd_empleo, t_empleo)

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), PERIODO 2012 - 2023 POR AÑO

d_empleo <- bd_reem3 %>% select(estructura_estrat,empleo_equiv,empleo_equiv_hombres,empleo_equiv_mujeres,anio,situacion)
bd_empleo <- d_empleo %>% filter(situacion==1 & estructura_estrat ==1)

#total empresas del año 2012-2023#
t_empleo <- bd_empleo %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                        "total_empleohombres" =sum(empleo_equiv_hombres,na.rm=T),
                                                        "total_empleomujeres"=sum(empleo_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.26",t_empleo, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.26",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.26",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_empleo, bd_empleo, t_empleo)

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024

d_empleo <- bd_reem %>% select(estructura_estrat,empleo_equiv,empleo_equiv_hombres,empleo_equiv_mujeres,anio,situacion)
bd_empleo <- d_empleo %>% filter(situacion==1 & estructura_estrat ==1)

#total empresas del año 2024#
t_empleo <- bd_empleo %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                        "total_empleohombres" =sum(empleo_equiv_hombres,na.rm=T),
                                                        "total_empleomujeres"=sum(empleo_equiv_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.26",t_empleo, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.26",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.26",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_empleo, bd_empleo, t_empleo)


######################## TABULADO 2.1.27 ##########################################
#EMPLEO REGISTRADO (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), DESDE AÑO 2023 POR NACIONALIDAD# 

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2023

d_empleo <- bd_reem3 %>% select(estructura_estrat,empleo_equiv,empleo_nacionales_equiv,empleo_extranjeros_equiv,anio,situacion)
bd_empleo <- d_empleo %>% filter(anio == 2023 & situacion==1 & estructura_estrat ==1)

#total empresas del año 2024#
t_empleo <- bd_empleo %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                        "total_empleonacionales" =sum(empleo_nacionales_equiv,na.rm=T),
                                                        "total_empleoextranjeros"=sum(empleo_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.27",t_empleo, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.27",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.27",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_empleo, bd_empleo, t_empleo)

#PLAZAS DE EMPLEO REGISTRADO (UNIVERSO REEM), AÑO 2024

d_empleo <- bd_reem %>% select(estructura_estrat,empleo_equiv,empleo_nacionales_equiv,empleo_extranjeros_equiv,anio,situacion)
bd_empleo <- d_empleo %>% filter (situacion==1 & estructura_estrat ==1)

#total empresas del año 2024#
t_empleo <- bd_empleo %>% group_by(anio) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T),
                                                        "total_empleonacionales" =sum(empleo_nacionales_equiv,na.rm=T),
                                                        "total_empleoextranjeros"=sum(empleo_extranjeros_equiv,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.27",t_empleo, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.27",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.27",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_empleo, bd_empleo, t_empleo)

############TABULADO 2.1.28#####################################################
#     EMPLEO REGISTRADO SEG?N PARTICIPACI?N EN EL TOTAL                    #
# (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR RANGO DE EDAD       #
#selección de variables
bd_empleorp <- bd_reem %>% select(empleo_rango_edad_1,empleo_rango_edad_2,
                                    empleo_rango_edad_3,empleo_rango_edad_4, 
                                    empleo_rango_edad_5,estructura_estrat,
                                    anio,situacion)

#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact1 <- bd_empleorp %>% filter(estructura_estrat==1)

#Cálculo de las variables.
t_empleore1 <- bd_reemact1 %>% summarise ("total_empleo"=sum(empleo_rango_edad_1,na.rm=T), porcentaje = 0)
t_empleore2 <- bd_reemact1 %>% summarise ("total_empleo"=sum(empleo_rango_edad_2,na.rm=T), porcentaje = 0)
t_empleore3 <- bd_reemact1 %>% summarise ("total_empleo"=sum(empleo_rango_edad_3,na.rm=T), porcentaje = 0)
t_empleore4 <- bd_reemact1 %>% summarise ("total_empleo"=sum(empleo_rango_edad_4,na.rm=T), porcentaje = 0)
t_empleore5 <- bd_reemact1 %>% summarise ("total_empleo"=sum(empleo_rango_edad_5,na.rm=T), porcentaje = 0)

t_rangose1 = data.frame(new.row.names = "RANGO DE EDAD 1", rbind(t_empleore1))
t_rangose2 = data.frame(new.row.names = "RANGO DE EDAD 2", rbind(t_empleore2))
t_rangose3 = data.frame(new.row.names = "RANGO DE EDAD 3", rbind(t_empleore3))
t_rangose4 = data.frame(new.row.names = "RANGO DE EDAD 4", rbind(t_empleore4))
t_rangose5 = data.frame(new.row.names = "RANGO DE EDAD 5", rbind(t_empleore5))

tablae1 <- data.frame (rbind(t_rangose1,t_rangose2,t_rangose3, t_rangose4, t_rangose5))
total <- sum(tablae1$total_empleo,na.rm = T)
tablae1$porcentaje <- tablae1$total_empleo/total
v_total <- c("TOTAL",total,"100.00%")
v_total <- matrix(v_total,nrow=1,ncol=3)

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.28" ,v_total,startCol = 1,startRow = 7,colNames = F)
writeData(wb1,sheet = "2.1.28","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.28",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.28",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.28",tablae1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.28",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.28",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.28",purpleStyle,cols= 6:7, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_empleorp, bd_reemact1, t_empleore1, t_empleore2, t_empleore3, t_empleore4, t_empleore5, t_rangose1, t_rangose2, t_rangose3, t_rangose4, t_rangose5, tablae1, total, v_total)

############TABULADO 2.1.29#####################################################
#      EMPLEO REGISTRADO SEGÚN PARTICIPACIÓN EN EL TOTAL                   #
# (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024 POR FORMA INSTITUCIONAL#

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_seccion,estructura_estrat,forma_institucional,empleo_equiv,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#Cálculo de las variables.
t_empleoins <- bd_reemact %>% group_by(forma_institucional) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_empleoins$total_empleo,na.rm =T )
t_empleoins$porcentaje <- t_empleoins$total_empleo / total

#Lectura catálogo de variables.
des_empleoinst <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_empleoinst,t_empleoins,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.29","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.29",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.29",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.29",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.29",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.29",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_empleoins, total, des_empleoinst, dft2, dft3, t_estrato1)

####################TABULADO 2.1.30################################################
#EMPLEO SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#              AÑO 2024 POR TAMAÑO DE EMPRESA                                 #

#Selección de variables que se requieren para el tabulado.
bd_tamano <- bd_reem %>% select(tamanoe_empleo,empleo_equiv,estructura_estrat,codigo_seccion,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#Cálculo de las variables.
t_tamanoempleo <- bd_reemact %>% group_by(tamanoe_empleo) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoempleo$total_empleo,na.rm =T )
t_tamanoempleo$porcentaje <- t_tamanoempleo$total_empleo/ total

#Lectura catálogo de variables.
des_tamanoempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoempleo,t_tamanoempleo,by.x = "CODIGO",by.y = "tamanoe_empleo",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.30","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.30",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.30",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.30",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.30",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.30",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.30",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_tamanoempleo, total, des_tamanoempleo, dft2, dft3, t_estrato1)

####################TABULADO 2.1.31################################################
#EMPLEO SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#              AÑO 2024 POR TAMAÑO DE EMPRESA  (COP)                          #

#Selección de variables que se requieren para el tabulado.
bd_tamano <- bd_reem %>% select(tamano_cop,empleo_equiv,estructura_estrat,codigo_seccion,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_tamano %>% filter(estructura_estrat==1)

#Cálculo de las variables.
t_tamanocop <- bd_reemact %>% group_by(tamano_cop) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_tamanocop$total_empleo,na.rm =T )
t_tamanocop$porcentaje <- t_tamanocop$total_empleo/ total

#Lectura catálogo de variables.
des_tamanocop <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanocop,t_tamanocop,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.31","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.31",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.31",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.31",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.31",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.31",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.31",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_tamano, bd_reemact, t_tamanocop, total, des_tamanocop, dft2, dft3, t_estrato1)

##############TABULADO 2.1.32######################################################
#EMPLEO SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS)#
#            AÑO 2024 POR SECTOR ECONÓMICO                                   #     

#selección de variables###
bd_sector <- bd_reem %>% select(gsectores,empleo_equiv,estructura_estrat,codigo_seccion,anio,situacion)
bd_reemact <- bd_sector %>% filter(estructura_estrat==1)

#cálculo#
t_sectorempleo <- bd_reemact %>% group_by(gsectores) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_sectorempleo$total_empleo,na.rm =T )
t_sectorempleo$porcentaje <- t_sectorempleo$total_empleo/ total

#Lectura catálogo de variables.
des_sectorempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorempleo,t_sectorempleo,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.32","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.32",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.32",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.32",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.32",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.32",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_sector, bd_reemact, t_sectorempleo, total, des_sectorempleo, dft2, dft3, t_estrato1)

#################TABULADO 2.1.33##############################################################
#EMPLEO SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2043#
#                    POR ACTIVIDAD ECONÓMICA                                             #

#selección de variables###
bd_act <- bd_reem %>% select(codigo_seccion,empleo_equiv,estructura_estrat,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- bd_act %>% filter(estructura_estrat==1)

#cálculo#
t_secact <- bd_reemact %>% group_by(codigo_seccion) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_secact$total_empleo,na.rm =T )
t_secact$porcentaje <- t_secact$total_empleo / total

#Lectura catálogo de variables.
des_secact <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_secact,t_secact,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.33","TOTAL", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.33",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.33",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.33",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.33",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.33",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_act, bd_reemact, t_secact, total, des_secact, dft2, dft3, t_estrato1)

####################TABULADO 2.1.34#########################################################
##EMPLEO SEGÚN PARTICIPACIÓN NACIONAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024#
#                                POR PROVINCIA                                         #

#Selección de variables que se requieren para el tabulado.
df1 <- bd_reem %>% select(codigo_provincia,codigo_seccion,empleo_equiv,estructura_estrat,anio,situacion)
#Filtrar empresas activas del año del cual se requiere realizar la validación.
bd_reemact <- df1 %>% filter(estructura_estrat ==1)

#cálculo#
t_provempleo <- bd_reemact %>% group_by(codigo_provincia) %>% summarise ("total_empleo"=sum(empleo_equiv,na.rm=T), porcentaje = 0)
total <- sum(t_provempleo$total_empleo,na.rm =T )
t_provempleo$porcentaje <- t_provempleo$total_empleo / total

#Lectura catálogo de variables.
des_provempleo <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provempleo,t_provempleo,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_empleo,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.34","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.34",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.34",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.34",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.34",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.34",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(df1, bd_reemact, t_provempleo, total, des_provempleo, dft2, dft3, t_estrato1)

####################TABULADO 2.1.35#############################################
##MASA SALARIAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), PERIODO 2011 - 2024#
#                          POR AÑO                                        #

##BASE GENERAL 2011
d_remuneracion1 <- bd_reem1 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
bd_reemact1 <- bd_reem1 %>% filter(anio == 2011 & estructura_estrat ==1)

#total empresas del año 2006-2011
t_remuneraciones1 <- bd_reemact1 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T),
                                                                     "total_remuneracioneshombres" =sum(remuneraciones_hombres,na.rm=T),
                                                                     "total_remuneracionesmujeres"=sum(remuneraciones_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.35",t_remuneraciones1, startCol = 1,startRow = 7,colNames = F) ##escribir
addStyle(wb1,"2.1.35",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.35",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

##BASE GENERAL 2012-2023
d_remuneracion <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
bd_reemact <- d_remuneracion %>% filter(estructura_estrat ==1)

#total empresas del año 2012-2023
t_remuneraciones <- bd_reemact %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T),
                                                                     "total_remuneracioneshombres" =sum(remuneraciones_hombres,na.rm=T),
                                                                     "total_remuneracionesmujeres"=sum(remuneraciones_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.35",t_remuneraciones, startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.35",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.35",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_remuneracion1, bd_reemact1, t_remuneraciones1, d_remuneracion, bd_reemact, t_remuneraciones)

##BASE GENERAL 2024
d_remuneracion <- bd_reem %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
bd_reemact <- d_remuneracion %>% filter(estructura_estrat ==1)

#total empresas del año 2024
t_remuneraciones <- bd_reemact %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T),
                                                                 "total_remuneracioneshombres" =sum(remuneraciones_hombres,na.rm=T),
                                                                 "total_remuneracionesmujeres"=sum(remuneraciones_mujeres,na.rm=T))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.35",t_remuneraciones, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.35",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.35",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(d_remuneracion, bd_reemact, t_remuneraciones)

####################TABULADO 2.1.36: CONSTANTE#################
#           MASA SALARIAL CONSTANTE            #

#lectura de base 2011
bd_reemmsc <- bd_reem1 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc <- bd_reemmsc %>% filter (anio == 2011 & situacion == 1& estructura_estrat ==1)
t_masa2011 <- d_reemmsc %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/86.1978166564780)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/86.1978166564780)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/86.1978166564780)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2011, startCol = 1,startRow = 7,colNames = F) ##escribir

#lectura de base 2012
bd_reemmsc1 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc1 <- bd_reemmsc1 %>% filter (anio == 2012 & situacion == 1 & estructura_estrat ==1)
t_masa2012 <- d_reemmsc1 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/89.7870158278850)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/89.7870158278850)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/89.7870158278850)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2012, startCol = 1,startRow = 8,colNames = F) ##escribir

#lectura de base 2013
bd_reemmsc2 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc2 <- bd_reemmsc2 %>% filter (anio == 2013 & situacion == 1 & estructura_estrat ==1)
t_masa2013 <- d_reemmsc2 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/92.21157233719690)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/92.21157233719690)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/92.21157233719690)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2013, startCol = 1,startRow = 9,colNames = F) ##escribir

#lectura de base 2014
bd_reemmsc3 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc3 <- bd_reemmsc3 %>% filter (anio == 2014 & situacion == 1 & estructura_estrat ==1)
t_masa2014 <- d_reemmsc3 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/95.59330008553980)*100,na.rm=T),
                                                          "total_remuneracioneshombres" =sum((remuneraciones_hombres/95.59330008553980)*100,na.rm=T),
                                                          "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/95.59330008553980)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2014, startCol = 1,startRow = 10,colNames = F) ##escribir

#lectura de base 2015
bd_reemmsc4 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc4 <- bd_reemmsc4 %>% filter (anio == 2015 & situacion == 1 & estructura_estrat ==1)
t_masa2015 <- d_reemmsc4 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/98.82447324752920)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/98.82447324752920)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/98.82447324752920)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2015, startCol = 1,startRow = 11,colNames = F) ##escribir

#lectura de base 2016
bd_reemmsc5 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc5 <- bd_reemmsc5 %>% filter (anio == 2016 & situacion == 1 & estructura_estrat ==1)
t_masa2016 <- d_reemmsc5 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/99.93110124665580)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/99.93110124665580)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/99.93110124665580)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2016, startCol = 1,startRow = 12,colNames = F) ##escribir

#lectura de base 2017
bd_reemmsc6 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc6 <- bd_reemmsc6 %>% filter (anio == 2017 & situacion == 1 & estructura_estrat ==1)
t_masa2017 <- d_reemmsc6 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/99.73453622777890)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/99.73453622777890)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/99.73453622777890)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2017, startCol = 1,startRow = 13,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2018
bd_reemmsc8 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc8 <- bd_reemmsc8 %>% filter (anio == 2018 & situacion == 1 & estructura_estrat ==1)
t_masa2018 <- d_reemmsc8 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/100)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/100)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/100)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2018, startCol = 1,startRow = 14,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2019
bd_reemmsc9 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc9 <- bd_reemmsc9 %>% filter (anio == 2019 & situacion == 1 & estructura_estrat ==1)
t_masa2019 <- d_reemmsc9 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/99.9302340733309)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/99.9302340733309)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/99.9302340733309)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2019, startCol = 1,startRow = 15,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2020
bd_reemmsc10 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc10 <- bd_reemmsc10 %>% filter (anio == 2020 & situacion == 1 & estructura_estrat ==1)
t_masa2020 <- d_reemmsc10 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/98.9994135297337)*100,na.rm=T),
                                                           "total_remuneracioneshombres" =sum((remuneraciones_hombres/98.9994135297337)*100,na.rm=T),
                                                           "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/98.9994135297337)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2020, startCol = 1,startRow = 16,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2021
bd_reemmsc11 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc11 <- bd_reemmsc11 %>% filter (anio == 2021 & situacion == 1 & estructura_estrat ==1)
t_masa2021 <- d_reemmsc11 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/100.927541798614)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/100.927541798614)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/100.927541798614)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2021, startCol = 1,startRow = 17,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2022
bd_reemmsc12 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc12 <- bd_reemmsc12 %>% filter (anio == 2022 & situacion == 1 & estructura_estrat ==1)
t_masa2022 <- d_reemmsc12 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/104.698314817064)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/104.698314817064)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/104.698314817064)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2022, startCol = 1,startRow = 18,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

#lectura de base 2023
bd_reemmsc13 <- bd_reem3 %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc13 <- bd_reemmsc13 %>% filter (anio == 2023 & situacion == 1 & estructura_estrat ==1)
t_masa2023 <- d_reemmsc13 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/106.108889213024)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/106.108889213024)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/106.108889213024)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2023, startCol = 1,startRow = 19,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemmsc, d_reemmsc, t_masa2011, bd_reemmsc1, d_reemmsc1, t_masa2012, bd_reemmsc2, d_reemmsc2, t_masa2013, bd_reemmsc3)
rm(d_reemmsc3, t_masa2014, bd_reemmsc4, d_reemmsc4, t_masa2015, bd_reemmsc5, t_masa2016, bd_reemmsc6, d_reemmsc6, t_masa2017)
rm(d_reemmsc5, bd_reemmsc8, d_reemmsc8, t_masa2018, bd_reemmsc9, d_reemmsc9, t_masa2019, bd_reemmsc10, d_reemmsc10, t_masa2020)
rm(bd_reemmsc11, d_reemmsc11, t_masa2021, bd_reemmsc12, d_reemmsc12, t_masa2022, bd_reemmsc13, d_reemmsc13, t_masa2023)

#lectura de base 2024
bd_reemmsc13 <- bd_reem %>% select(estructura_estrat,remuneraciones,remuneraciones_hombres,remuneraciones_mujeres,anio,situacion)
d_reemmsc13 <- bd_reemmsc13 %>% filter (situacion == 1 & estructura_estrat ==1)
t_masa2024 <- d_reemmsc13 %>% group_by(anio) %>% summarise ("total_remuneraciones"=sum((remuneraciones/106.673933930005)*100,na.rm=T),
                                                            "total_remuneracioneshombres" =sum((remuneraciones_hombres/106.673933930005)*100,na.rm=T),
                                                            "total_remuneracionesmujeres"=sum((remuneraciones_mujeres/106.673933930005)*100,na.rm=T))
#Exportar resultados a excel
writeData(wb1,sheet = "2.1.36",t_masa2024, startCol = 1,startRow = 20,colNames = F) ##escribir
addStyle(wb1,"2.1.36",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.36",purpleStyle,cols= 1:4, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_reemmsc13, d_reemmsc13, t_masa2024)

####################TABULADO 2.1.37###################################################################
# MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024#
#               POR FORMA INSTITUCIONAL                                                          #

bd_remuneraciones <- bd_reem %>% select(anio,remuneraciones,forma_institucional,situacion, estructura_estrat)
bd_reemms <- bd_remuneraciones%>% filter(situacion==1 & estructura_estrat==1)

#cálculo#
t_remuneracionesins <- bd_reemms %>% group_by(forma_institucional) %>% summarise ("total_remuneraciones"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_remuneracionesins$total_remuneraciones,na.rm =T )
t_remuneracionesins$porcentaje <- t_remuneracionesins$total_remuneraciones / total

#Lectura catálogo de variables.
des_remuneracionesinst <- read.xlsx("reem_catalogo.xlsx", sheet = "forma_institucional")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_remuneracionesinst,t_remuneracionesins,by.x = "CODIGO",by.y = "forma_institucional",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remuneraciones,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.37","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.37",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.37",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.37",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.37",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.37",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_remuneraciones, bd_reemms, t_remuneracionesins, total, des_remuneracionesinst, dft2, dft3, t_estrato1)

###################TABULADO 2.1.38###################################################################
#MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024#
#             POR TAMAÑO DE EMPRESA                                                             #

bd_remuneraciones <- bd_reem %>% select(remuneraciones,tamanoe_plazas,situacion, estructura_estrat)
bd_reemtam <- bd_reem%>% filter(situacion==1 & estructura_estrat==1)
      
#cálculo#
t_tamanoremu <- bd_reemtam %>% group_by(tamanoe_plazas) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoremu$total_remu,na.rm =T )
t_tamanoremu$porcentaje <- t_tamanoremu$total_remu / total

#Lectura catálogo de variables.
des_tamanoremu <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoremu,t_tamanoremu,by.x = "CODIGO",by.y = "tamanoe_plazas",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.38","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.38",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.38",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.38",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.38",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.38",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.38",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_remuneraciones, bd_reemtam, t_tamanoremu, total, des_tamanoremu, dft2, dft3, t_estrato1)

###################TABULADO 2.1.39###################################################################
#MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024#
#             POR TAMAÑO DE EMPRESA   (COP)                                                     #

bd_remuneraciones <- bd_reem %>% select(remuneraciones,tamano_cop,situacion, estructura_estrat)
bd_reemtam <- bd_reem%>% filter(situacion==1 & estructura_estrat==1)

#cálculo#
t_tamanoremu <- bd_reemtam %>% group_by(tamano_cop) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_tamanoremu$total_remu,na.rm =T )
t_tamanoremu$porcentaje <- t_tamanoremu$total_remu / total

#Lectura catálogo de variables.
des_tamanoremu <- read.xlsx("reem_catalogo.xlsx", sheet = "tamano_cop")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_tamanoremu,t_tamanoremu,by.x = "CODIGO",by.y = "tamano_cop",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.39","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.39",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.39",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.39",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.39",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.39",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.39",purpleStyle,cols= 6:8, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_remuneraciones, bd_reemtam, t_tamanoremu, total, des_tamanoremu, dft2, dft3, t_estrato1)

#######################TABULADO 2.1.40################################################################
#"MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (EMPRESAS CON ACTIVIDADES PRODUCTIVAS), AÑO 2024#
#                   POR SECTOR ECONÓMICO                                                         #

bd_remuneraciones <- bd_reem %>% select(remuneraciones,gsectores,situacion, estructura_estrat)
bd_reemse <- bd_reem%>% filter(situacion==1 & estructura_estrat==1)

#cálculo#
t_sectorremu<- bd_reemse %>% group_by(gsectores) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_sectorremu$total_remu,na.rm =T )
t_sectorremu$porcentaje <- t_sectorremu$total_remu / total

#Lectura catálogo de variables.
des_sectorremu <- read.xlsx("reem_catalogo.xlsx", sheet = "g_sectores")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_sectorremu,t_sectorremu,by.x = "CODIGO",by.y = "gsectores",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.40","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.40",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.40",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.40",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.40",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.40",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_remuneraciones, bd_reemse, t_sectorremu, total, des_sectorremu, dft2, dft3, t_estrato1)

############TABULADO 2.1.41####################################################
# MASA SALARIAL SEGÚN PARTICIPACIÓN EN EL TOTAL (UNIVERSO REEM), AÑO 2024#
#       POR ACTIVIDAD ECONÓMICA                                           #  

bd_remuneraciones <- bd_reem %>% select(anio,remuneraciones,codigo_seccion,situacion, estructura_estrat)
bd_reemact <- bd_remuneraciones%>% filter(estructura_estrat==1)

#cálculo#
t_seccre <- bd_reemact %>% group_by(codigo_seccion) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_seccre$total_remu,na.rm =T )
t_seccre$porcentaje <- t_seccre$total_remu / total

#Lectura catálogo de variables.
des_seccre <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_ciiu4.1_seccion")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_seccre,t_seccre,by.x = "CODIGO",by.y = "codigo_seccion",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.41","TOTAL", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.41",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.41",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.41",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.41",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.41",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)

rm(bd_remuneraciones, bd_reemact, t_seccre, total, des_seccre, dft2, dft3, t_estrato1)

##########TABULADO 2.1.42################################################################
#MASA SALARIAL SEGÚN PARTICIPACIÓN NACIONAL (UNIVERSO REEM), AÑO 2024 POR PROVINCIA#

bd_remuneraciones <- bd_reem %>% select(anio,remuneraciones,codigo_provincia,situacion, estructura_estrat)
bd_reemact <- bd_remuneraciones%>% filter(estructura_estrat==1)

#cálculo#
t_provre <- bd_reemact %>% group_by(codigo_provincia) %>% summarise ("total_remu"=sum(remuneraciones,na.rm=T), porcentaje = 0)
total <- sum(t_provre$total_remu,na.rm =T )
t_provre$porcentaje <- t_provre$total_remu / total
 
#Lectura catálogo de variables.
des_provre <- read.xlsx("reem_catalogo.xlsx", sheet = "cod_provincia")

#Para unir identificadores y descripciones de excel
dft2 <-merge(des_provre,t_provre,by.x = "CODIGO",by.y = "codigo_provincia",all.y = T)
dft3 <- dft2 %>% select(DESCRIPCION,total_remu,porcentaje)
t_estrato1 <- arrange(dft3,(desc(porcentaje)))

#Exportar resultados a excel
writeData(wb1,sheet = "2.1.42","Total", startCol = 1,startRow = 7, colNames = F) ##escribir
writeData(wb1,sheet = "2.1.42",total, startCol = 2,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.42",1, startCol = 3,startRow = 7, colNames = F)
writeData(wb1,sheet = "2.1.42",t_estrato1,startCol = 1,startRow = 8,colNames = F) ##escribir
addStyle(wb1,"2.1.42",newStyle,cols= 1:100, rows = 1:100,gridExpand = TRUE,stack=TRUE)
addStyle(wb1,"2.1.42",purpleStyle,cols= 1:3, rows = 6,gridExpand = TRUE,stack=TRUE)
saveWorkbook(wb1,"Tabulados_reem_2024.xlsx",overwrite = T)

rm(bd_remuneraciones, bd_reemact, t_provre, total, des_provre, dft2, dft3, t_estrato1, wb1)

fin <- Sys.time()
Tiempo <- round(fin-inicio,2)
Tiempo
