*==============================================================================*
* TÍTULO DE LA SINTAXIS:													   *
* Principales tabulados de Entradas y Salidas Internacionales				   *
* OPERACIÓN ESTADÍSTICA:													   *
* Registro Estadístico de Entradas y Salidas Internacionales - 2019			   *
* UNIDAD TÉCNICA RESPONSABLE: 												   *
* Dirección de Estadísticas Sociodemográficas (DIES)						   *
* ENTIDAD EJECUTORA:														   *
* Instituto Nacional de Estadística y Censos (INEC)							   *
*==============================================================================*
* Fecha de elaboración:        Mayo   del 2020								   *
* Fecha última modificación:   Mayo   del 2020							   	   *
*==============================================================================*
* Elaborado por: José Carlos Andrade
* Actualizado por: Verónica Cuzco Q.										   *
* Dirección de Estadísticas Sociodemográficas (DIES)						   *
* Instituto Nacional de Estadística y Censos (INEC)							   *
* inec@inec.gob.ec											                   *
*==============================================================================*
* Revisado por:													               *
* Gabriela Lugmaña												               *
* Aprobado por:	                         									   *
* Andrés Albán  															   *
* Dirección de Estadísticas Sociodemográficas (DIES)						   *
* Instituto Nacional de Estadística y Censos (INEC)							   *
* inec@inec.gob.ec															   *
*==============================================================================*

clear all
set more off

global dir1 = "C:\..." // Se detalla la ubicación de la base de datos.
use "$dir1//esi_2019.dta", clear

*==============================================================================*  
* Preparación de la base: Creación de variables auxiliares
*==============================================================================*  
** Creación de la variable trimes para agrupación de los meses por trimestres en el año
recode mes_movi 1/3=1 4/6=2 7/9=3 10/12=4, generate(trimes)
label variable trimes "Trimestres"
label values trimes trimestres
label define trimestres 1 "1er Trimestre" 2 "2do Trimestre" 3 "2er Trimestre" 4 "4to trimestre"

** Creación de la variable gedad1 edad para hacer grupos en rangos de 5 años de edad
recode edad 0/4=1 5/9=2 10/14=3 15/19=4 20/24=5 25/29=6 30/34=7 35/39=8 40/49=9 50/59=10 60/69=11 70/120=12 999=13, generate(gedad1)
label variable gedad1 "Grupos de edad 1"
label values gedad1 gedad
label define gedad 1 "0-4" 2 "5-9" 3 "10-14" 4 "15-19" 5 "20-24" 6 "25-29" 7 "30-34" 8 "35-39" 9 "40-49" 10 "50-59" 11 "60-69" 12 "70 y más" 13 "sin especificar"

** Creación de la variable gedad2 para grupos de rangos de edad  de 10 en 10 años
recode edad 0/9=1 10/19=2 20/29=3 30/39=4 40/49=5 50/59=6 60/120=7 999=8, generate(gedad2)
label variable gedad2 "Grupos de edad 2"
label values gedad2 gedad1
label define gedad1 1 "Menores de 10 años" 2 "10-19" 3 "20-29" 4 "30-39" 5 "40-49" 6 "50-59" 7 "60 años y más" 8 "sin especificar"

** Creación de la variable ocu_migr1 para recodificar las ocupaciones según los grupos de ocupación de la CIUO-08
replace ocu_migr=3434 if ocu_migr==3534
generate ocu=ocu_migr
recode ocu (0/999	  =0) (1000/1999=1) (2000/2999=2)(3000/3999=3) (4000/4999=4) ///
(5000/5999=5) (6000/6999=6) (7000/7999=7) (8000/8999=8) (9000/9999=9) (55555	 =10) ///
(66666	 =11) (77777	 =12) (88888	 =13) (99999	 =14), generate(ocu_migr1)
label values ocu_migr1 ocu_migr1
label define ocu_migr1 0 "Ocupaciones militares"  1 "Directores y gerentes" 2 "Profesionales, científicos e intelectuales" 3 "Técnicos y profesionales del nivel medio" 4 "Personal de apoyo administrativo" 5 "Trabajadores de los servicios y vendedores de comercios y mercados" 6 "Agricultores y trabajadores calificados agropecuarios, forestales y pesqueros" 7 "Oficiales, operarios y artesanos de artes mecánicas y de otros oficios" 8 "Operadores de instalaciones y máquinas y ensambladores" 9 "Ocupaciones elementales" 10 "Amas de casa" 11 "Estudiantes" 12 "Jubilados y pensionistas" 13 "Menores de edad" 14 "Sin especificar"
drop ocu
label values ocu_migr ocu_migr

*==============================================================================*  
* 1.1. SERIES HISTORICAS DE ENTRADAS Y SALIDAS INTERNACIONALES
*==============================================================================*  
** Tabla 1.1.1. Entrada, salida, movimientos brutos y movimientos netos 
tab tip_movi, matcell(a)
mat b1=a[1,1]
mat b2=a[2,1]
mat b3=b1+b2
mat b4=b1-b2
mat T111 = b1, b2, b3, b4 

mat colnames T111 = "Entradas" "Salidas"  "Movimiento Bruto**" "Movimiento Neto***"
mat rownames T111 = "2019" 
mat list T111

** Tabla 1.1.2. Entradas, salidas, movimientos brutos y movimientos netos por sexo
tab tip_movi sex_migr, matcell(a)
mat b2_1=a[1,1..3]
mat b2_2=a[2,1..3]
mat b3=b2_1+b2_2

mat b3_1= b3[1,1] + b3[1,2] + b3[1,3]
mat b4=b2_1-b2_2
mat b4_1=b4[1,1]+b4[1,2]
mat b5=b3[1,1]/b3[1,2]*100
mat T112 = b2_1, b2_2, b3_1, b3, b4_1, b4, b5 

mat colnames T112 = "Hombre" "Mujer"	"Indefinido*"	"Hombre"	"Mujer"	"Indefinido*"	"Total"	"Hombre"	"Mujer"	"Indefinido*"	"Total"	"Hombre"	"Mujer"	"Indefinido*" "RM"
mat rownames T112 = "2019" 
mat list T112

** Tabla 1.1.3.Entradas y salidas por sexo y razón de masculinidad 
tab tip_movi sex_migr, matcell(a)
mat b1=a[1,1..3]
mat b2=a[2,1..3]
mat b3=b1[1,1]/b1[1,2]*100
mat b4=b2[1,1]/b2[1,2]*100
mat T113 = b1, b2 ,b3, b4
mat list T113

mat colnames T113 = "Hombre" "Mujer" "Indefinido*"	"Hombre" "Mujer" "Indefinido*"	"RM_Entradas"	"RM_Salida"
mat rownames T113 = "2019" 
mat list T113

** Tabla 1.1.4. Entrada y salida de ecuatorianos y extranjeros, según sexo
forvalues s = 1/2 {
di in red "`s'"
tab tip_movi sex_migr if tip_naci==`s', matcell(a_`s')
}
mat b1=a_1[1,1..2]
mat b1_1=b1[1,1]+b1[1,2]

mat b2=a_1[2,1..2]
mat b2_1=b2[1,1]+b2[1,2]
mat b3=a_2[1,1..3]
mat b3_1=b3[1,1]+b3[1,2]+b3[1,3]
mat b4=a_2[2,1..3]
mat b4_1=b4[1,1]+b4[1,2]+b4[1,3]
mat T114= b1_1, b1, b2_1, b2, b3_1, b3, b4_1, b4

mat colnames T114 = "Total"	"Hombre" "Mujer" "Total" "Hombre"	"Mujer"	"Total"	"Hombre" "Mujer" "Indefinido*"	"Total"	"Hombre" "Mujer" "Indefinido*"
mat rownames T114 = "2019" 
mat list T114

** Tabla 1.1.5. Entrada de ecuatorianos por país de procedencia
table pais_prod if tip_mov==1 & tip_nac==1

** Tabla 1.1.6. Salida de ecuatorianos por país de destino
table pais_prod if tip_mov==2 & tip_nac==1

** Tabla 1.1.7. Entrada de extranjeros por país de procedencia
table pais_prod if tip_mov==1 & tip_nac==2

** Tabla 1.1.8. Salida de extranjeros por país de destino
table pais_prod if tip_mov==2 & tip_nac==2

** Tabla 1.1.9. Entradas y Salidas de ecuatorianos y extranjeros,  según cantón de ubicación de las Jefaturas de Migración y vía de transporte
table can_jefm via_tran, by(tip_naci tip_movi)

** Tabla 1.1.10. Salida de ecuatorianos por sexo, según motivos de viaje
tabulate  mot_viam sex_migr if tip_movi==2 & tip_naci==1, matcell(a)
mat b1=a[1..6,1]
mat b2=a[1..6,2]
mat b4=b1+b2
mat c=b4[1,1]+b4[2,1]+b4[3,1]+b4[4,1]+b4[5,1]+b4[6,1],b1[1,1]+b1[2,1]+b1[3,1]+b1[4,1]+b1[5,1]+b1[6,1],b2[1,1]+b2[2,1]+b2[3,1]+b2[4,1]+b2[5,1]+b2[6,1]
mat c_1=  b4, b1 ,b2
mat T1110 =c \ c_1

mat colnames T1110 = "Total"	"Hombres" "Mujeres"
mat rownames T1110 = "Total" "Turismo" "Negocios" "Eventos" "Estudios" "Residencia" "Otros"
mat list T1110

** Tabla 1.1.11. Entrada de extranjeros por sexo, según motivos de viaje
tabulate mot_viam sex_migr if tip_movi==1 & tip_naci==2, matcell(a)
mat b1=a[1..6,1]
mat b2=a[1..6,2]

mat b3=a[1..6,3]
mat b4=b1+b2+b3
mat c= b4[1,1]+b4[2,1]+b4[3,1]+b4[4,1]+b4[5,1]+b4[6,1],b1[1,1]+b1[2,1]+b1[3,1]+b1[4,1]+b1[5,1]+b1[6,1], b2[1,1]+b2[2,1]+b2[3,1]+b2[4,1]+b2[5,1]+b2[6,1], b3[1,1]+b3[2,1]+b3[3,1]+b3[4,1]+b3[5,1]+b3[6,1]
mat c_1= b4, b1 , b2 , b3
mat T1111 = c \ c_1
mat colnames T1111 = "Total" "Hombres"	"Mujeres" "Indefinido"
mat rownames T1111 = "Total" "Turismo" "Negocios" "Eventos" "Estudios" "Residencia" "Otros"
mat list T1111 

*==============================================================================*  
* 3.1. CUADROS ESTADÍTICOS DE ENTRADAS Y SALIDAS INTERNACIONALES - 2019
*==============================================================================*  
** Tabla 3.1.1. Entrada y salida de ecuatorianos y extranjeros por trimestres
tabulate  tip_movi tip_naci, matcell(a_0)
forvalues s=1/4 {
di in red "`s'"
tabulate  tip_movi tip_naci if trimes==`s', matcell(a_`s')
}
mat c=a_0[1,1..2]

mat b1_1=a_0[1..2,1]
mat b1_2=a_0[1..2,2]
mat b1=b1_1+b1_2
mat b2_1=a_1[1..2,1]
mat b2_2=a_1[1..2,2]
mat b2=b2_1+b2_2
mat b3_1=a_2[1..2,1]
mat b3_2=a_2[1..2,2]
mat b3=b3_1+b3_2
mat b4_1=a_3[1..2,1]
mat b4_2=a_3[1..2,2]
mat b4=b4_1+b4_2
mat b5_1=a_4[1..2,1]
mat b5_2=a_4[1..2,2]
mat b5=b5_1+b5_2
mat c=b1, a_0, b2, a_1, b3, a_2, b4, a_3, b5, a_4
mat d1=c[1,1..15]
mat d2=c[2,1..15]
mat dt=d1+d2
mat dn=d1-d2
mat T311= dt \ c \dn

mat colnames T311 = "Total" "Ecuatorianos" "Extranjeros" "Total" "Ecuatorianos" "Extranjeros" "Total"	"Ecuatorianos" "Extranjeros" "Total"	"Ecuatorianos" "Extranjeros" "Total"	"Ecuatorianos" "Extranjeros"
mat rownames T311 = "Total" "Entradas" "Salidas" "Movimientos Netos*"
mat list T311

** Tabla 3.1.2. Entrada y salida de ecuatorianos por sexo, según mes de movimiento
** Tabla 3.1.3. Entrada y salida de extranjeros por sexo, según mes de movimiento
foreach nac of numlist 1 2 {
forvalues s = 1/2 {
di in red "`nac'"
di in red "`s'"
tabulate mes_movi sex_migr if tip_naci==`nac' & tip_movi==`s', matcell(a_`nac'_`s')
}
}
* Entrada Ecuatorianos
mat b1_1=a_1_1[1..12,1]
mat b1_2=a_1_1[1..12,2]

mat b1 = b1_1+b1_2
* Salida Ecuatorianos
mat b2_1=a_1_2[1..12,1]
mat b2_2=a_1_2[1..12,2]

mat b2 = b2_1+b2_2

mat T312= b1, b1_1, b1_2, b2, b2_1, b2_2

mat colnames T312 = "Total"	"Hombres"	"Mujeres"	"Total"	"Hombres" "Mujeres"
mat rownames T312 ="Enero" "Febrero" "Marzo" "Abril" "Mayo" "Junio" "Julio" "Agosto" "Septiembre" "Octubre" "Noviembre" "Diciembre"
mat list T312 // Tabla 3.1.2.

*Entrata Extranjeros
mat c1_1=a_2_1[1..12,1]
mat c1_2=a_2_1[1..12,2]
mat c1_3=a_2_1[1..12,3]
mat c1 = c1_1+c1_2+c1_3
*Salida extranjeros
mat c2_1=a_2_2[1..12,1]
mat c2_2=a_2_2[1..12,2]
mat c2_3=a_2_2[1..12,3]
mat c2 = c2_1+c2_2+c2_3

mat T313= c1, a_2_1, c2, a_2_2

mat colnames T313 = "Total"	"Hombres"	"Mujeres" "Indefinido"	"Total"	"Hombres" "Mujeres" "Indefinido"
mat rownames T313 ="Enero" "Febrero" "Marzo" "Abril" "Mayo" "Junio" "Julio" "Agosto" "Septiembre" "Octubre" "Noviembre" "Diciembre"
mat list T313 // Tabla 3.1.3.

** Tabla 3.1.4. Movimientos netos de ecuatorianos y extranjeros por sexo, según mes de movimiento
*  Cálculo de los movimientos netos por sexo
foreach nac of numlist 1 2 {
forvalues s = 1/2 {
di in red "`nac'"
di in red "`s'"
tabulate mes_movi sex_migr if tip_naci==`nac' & tip_movi==`s', matcell(a_`nac'_`s')
}
}

mat b= a_1_1-a_1_2
mat b_1=b[1..12,1]
mat b_2=b[1..12,2]
mat b1=b[1..12,1]+b[1..12,2]
mat c= a_2_1-a_2_2
mat c1=c[1..12,1]+c[1..12,2]+c[1..12,3]


mat d= b1, b_1, b_2,c1, c
mat t= d[1,1..7]+d[2,1..7]+d[3,1..7]+d[4,1..7]+d[5,1..7]+d[6,1..7]+d[7,1..7]+d[8,1..7]+d[9,1..7]+d[10,1..7]+d[11,1..7]+d[12,1..7]
mat T314= t\d

mat colnames T314 = "Total"	"Hombres"	"Mujeres" 	"Total"	"Hombres" "Mujeres" "Indefinido"
mat rownames T314 ="Total" "Enero" "Febrero" "Marzo" "Abril" "Mayo" "Junio" "Julio" "Agosto" "Septiembre" "Octubre" "Noviembre" "Diciembre"
mat list T314

** Tabla 3.1.5. Entrada y salida de ecuatorianos y extranjeros, según medios de transporte según cantón de ubicación de la jefatura de migración
table can_jefm tip_movi tip_naci, by(via_tran)

** Tabla 3.1.6. Entrada, salida y movimientos netos de ecuatorianos y extranjeros según cantón de ubicación de la jefatura de migración y sexo*
table sex_migr tip_movi tip_naci, by(can_jefm)

** Tabla 3.1.7. Entrada y salida de extranjeros por sexo, según nacionalidad
table nac_migr sex_migr tip_movi if tip_naci==2, by(cont_nac subcont_nac) 

** Tabla 3.1.8. Entrada de ecuatorianos y extranjeros por sexo, según continente, país y ciudad de procedencia
preserve
gen tecu_1=1 if tip_naci==1 
gen tecu_2=1 if tip_naci==1 & sex_migr==1  
gen tecu_3=1 if tip_naci==1 & sex_migr==2  

gen text_1=1 if tip_naci==2 
gen text_2=1 if tip_naci==2 & sex_migr==1  
gen text_3=1 if tip_naci==2 & sex_migr==2  
gen text_4=1 if tip_naci==2 & sex_migr==3  

collapse (sum) tecu_1 tecu_2 tecu_3 text_1 text_2 text_3 text_4 if tip_movi==1, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
export excel using "$dir1//tabla318_2019.xlsx", sheet(T318) firstrow(varlabels)  sheetmodify
restore

** Tabla 3.1.9. Salida de ecuatorianos y extranjeros por sexo, según continente, país y ciudad de procedencia
preserve
gen tecu_1=1 if tip_naci==1 
gen tecu_2=1 if tip_naci==1 & sex_migr==1  
gen tecu_3=1 if tip_naci==1 & sex_migr==2  

gen text_1=1 if tip_naci==2 
gen text_2=1 if tip_naci==2 & sex_migr==1  
gen text_3=1 if tip_naci==2 & sex_migr==2  
gen text_4=1 if tip_naci==2 & sex_migr==3  

collapse (sum) tecu_1 tecu_2 tecu_3 text_1 text_2 text_3 text_4 if tip_movi==2, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.10. Entradas de ecuatorianos por grupos de edad, según países de procedencia
preserve
gen _t=1
tab gedad1, gen(_t)

collapse (sum) _t* if tip_movi==1 & tip_naci==1, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.11. Salida de ecuatorianos por grupos de edad, según país de destino
preserve
gen _t=1
tab gedad1, gen(_t)

collapse (sum) _t* if tip_movi==2 & tip_naci==1, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.12. Salida de ecuatorianos por grupos de ocupación, según país y ciudad de destino
preserve
gen _t=1
tab ocu_migr1, gen(_t)

collapse (sum) _t* if tip_movi==2 & tip_naci==1, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.13. Entrada de ecuatorianos por motivo de viaje, según país y ciudad de procedencia
preserve
gen _t=1
tab mot_viam, gen(_t)

collapse (sum) _t* if tip_movi==1 & tip_naci==1, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.14. Salida de ecuatorianos por motivo de viaje, según país y ciudad de destino
preserve
gen _t=1
tab mot_viam, gen(_t)

collapse (sum) _t* if tip_movi==2 & tip_naci==1, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.15. Entrada de extranjeros por motivo de viaje, según país y ciudad de procedencia
preserve
gen _t=1
tab mot_viam, gen(_t)

collapse (sum) _t* if tip_movi==1 & tip_naci==2, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.16. Salida de extranjeros por motivo de viaje, según continente, país y ciudad de destino
preserve
gen _t=1
tab mot_viam, gen(_t)

collapse (sum) _t* if tip_movi==2 & tip_naci==2, by(lug_prod cont_prod subcont_prod pais_prod)
order cont_prod subcont_prod pais_prod lug_prod
sort cont_prod subcont_prod pais_prod lug_prod
restore

** Tabla 3.1.17. Entrada de extranjeros por grupos de edad, según nacionalidad
preserve
gen _t=1
tab gedad1, gen(_t)

collapse (sum) _t* if tip_movi==1 & tip_naci==2, by(nac_migr cont_nac subcont_nac)
order cont_nac subcont_nac nac_migr 
sort cont_nac subcont_nac nac_migr 
restore

** Tabla 3.1.18. Entrada de extranjeros por grupo de ocupación, según nacionalidad
preserve
gen _t=1
tab ocu_migr1, gen(_t)

collapse (sum) _t* if tip_movi==1 & tip_naci==2, by(nac_migr cont_nac subcont_nac)
order cont_nac subcont_nac nac_migr 
sort cont_nac subcont_nac nac_migr 
restore

** Tabla 3.1.19. Entrada y salida de extranjeros por sexo, según categoría migratoria
table cla_migr sex_migr tip_movi if tip_naci==2 

** Tabla 3.1.20. Entrada y Salida de ecuatorianos por motivo de viaje, según sexo y grupos de edad
forvalues i = 1/2 {
forvalues j = 1/2 {
tab gedad2 mot_viam if tip_naci==1 & tip_movi==`i' & sex_migr==`j', matcell(a`i'_`j')
}
}
mat b1_1=a1_1[1..7,1]+a1_1[1..7,2]+a1_1[1..7,3]+a1_1[1..7,4]+a1_1[1..7,5]+a1_1[1..7,6]
mat b2_1=a2_1[1..7,1]+a2_1[1..7,2]+a2_1[1..7,3]+a2_1[1..7,4]+a2_1[1..7,5]+a2_1[1..7,6]

mat b1_2=a1_2[1..7,1]+a1_2[1..7,2]+a1_2[1..7,3]+a1_2[1..7,4]+a1_2[1..7,5]+a1_2[1..7,6]
mat b2_2=a2_2[1..7,1]+a2_2[1..7,2]+a2_2[1..7,3]+a2_2[1..7,4]+a2_2[1..7,5]+a2_2[1..7,6]

mat c1 = b1_1, a1_1
mat c2 = b1_2, a1_2
mat c3 = b2_1, a2_1
mat c4 = b2_2, a2_2
mat T3120 = (c1,c3) \ (c2,c4)
mat list T3120

mat colnames T3120 = "Total"	"Turismo"	"Negocios"	"Eventos"	"Estudios"	"Residencia*"	"Otros"	"Total"	"Turismo"	"Negocios"	"Eventos"	"Estudios"	"Residencia*"	"Otros"
mat rownames T3120 ="Menores de 10 años"	"10 a 19 años"	"20 a 29 años"	"30 a 39 años"	"40 a 49 años"	"50 a 59 años"	"60 años y más"	"Menores de 10 años"	"10 a 19 años"	"20 a 29 años"	"30 a 39 años"	"40 a 49 años"	"50 a 59 años"	"60 años y más"
mat list T3120

** Tabla 3.1.21. Entrada y Salida de extranjeros por motivo de viaje, según sexo y grupos de edad
forvalues i = 1/2 {
forvalues j = 1/3 {
tab gedad2 mot_viam if tip_naci==2 & tip_movi==`i' & sex_migr==`j', matcell(a`i'_`j')
}
}
mat b1_1=a1_1[1..7,1]+a1_1[1..7,2]+a1_1[1..7,3]+a1_1[1..7,4]+a1_1[1..7,5]+a1_1[1..7,6]
mat b2_1=a2_1[1..7,1]+a2_1[1..7,2]+a2_1[1..7,3]+a2_1[1..7,4]+a2_1[1..7,5]+a2_1[1..7,6]

mat b1_2=a1_2[1..7,1]+a1_2[1..7,2]+a1_2[1..7,3]+a1_2[1..7,4]+a1_2[1..7,5]+a1_2[1..7,6]
mat b2_2=a2_2[1..7,1]+a2_2[1..7,2]+a2_2[1..7,3]+a2_2[1..7,4]+a2_2[1..7,5]+a2_2[1..7,6]

mat c1 = b1_1, a1_1
mat c2 = b1_2, a1_2
mat c3 = b2_1, a2_1
mat c4 = b2_2, a2_2
mat T3121 = (c1,c3) \ (c2,c4)
mat list T3121

mat colnames T3121 = "Total"	"Turismo"	"Negocios"	"Eventos"	"Estudios"	"Residencia*"	"Otros"	"Total"	"Turismo"	"Negocios"	"Eventos"	"Estudios"	"Residencia*"	"Otros"
mat rownames T3121 ="Menores de 10 años"	"10 a 19 años"	"20 a 29 años"	"30 a 39 años"	"40 a 49 años"	"50 a 59 años"	"60 años y más" "Menores de 10 años"	"10 a 19 años"	"20 a 29 años"	"30 a 39 años"	"40 a 49 años"	"50 a 59 años"	"60 años y más"
mat list T3121

** Tabla 3.1.22. Entrada y Salida de ecuatorianos por meses, según Jefaturas de Migración
preserve
gen _tot1=1 
gen _tot2=1 if tip_movi==1
gen _tot3=1 if tip_movi==2
forvalues i = 1/12 {
gen _t`i'_1 = 1 if tip_movi==1 & mes_movi==`i'
gen _t`i'_2 = 1 if tip_movi==2 & mes_movi==`i'
}
collapse (sum) _t* if tip_naci==1, by(jef_migr via_tran)
order via_tran jef_migr
sort via_tran jef_migr
restore

** Tabla 3.1.23. Entrada y Salida de extranjeros por meses, según Jefaturas de Migración
preserve
gen _tot1=1 
gen _tot2=1 if tip_movi==1
gen _tot3=1 if tip_movi==2
forvalues i = 1/12 {
gen _t`i'_1 = 1 if tip_movi==1 & mes_movi==`i'
gen _t`i'_2 = 1 if tip_movi==2 & mes_movi==`i'
}
collapse (sum) _t* if tip_naci==2, by(jef_migr via_tran)
order via_tran jef_migr
sort via_tran jef_migr
restore

** Tabla 3.1.24. Entradas y Salidas de Ecuatorianos, Extranjeros por motivo de viaje según vías de transporte y según cantón de ubicación de la jefatura de migración
preserve
gen _tot1_1=1 if tip_naci==1 & tip_movi==1
gen _tot1_2=1 if tip_naci==1 & tip_movi==2

gen _tot2_1=1 if tip_naci==2 & tip_movi==1
gen _tot2_2=1 if tip_naci==2 & tip_movi==2

foreach i of numlist 1/5 9 {
gen _tot1_1_`i'=1 if tip_naci==1 & tip_movi==1 & mot_viam==`i'
gen _tot1_2_`i'=1 if tip_naci==1 & tip_movi==2 & mot_viam==`i'

gen _tot2_1_`i'=1 if tip_naci==2 & tip_movi==1 & mot_viam==`i'
gen _tot2_2_`i'=1 if tip_naci==2 & tip_movi==2 & mot_viam==`i'
}
*
collapse (sum) _t*, by(can_jefm via_tran)

order via_tran can_jefm _tot1_1 _tot1_1* _tot1_2 _tot1_2* _tot2_1 _tot2_1* _tot2_2 _tot2_2*
sort via_tran can_jefm
restore

** Tabla 3.1.25. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Quito
** Tabla 3.1.26. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Guayaquil
** Tabla 3.1.27. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Huaquillas
** Tabla 3.1.28. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Tulcán
** Tabla 3.1.29. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Macará
** Tabla 3.1.30. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Esmeraldas
** Tabla 3.1.31. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Manta
** Tabla 3.1.32. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Sucumbios
** Tabla 3.1.33. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Salinas
** Tabla 3.1.34. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración San Lorenzo
** Tabla 3.1.35. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Latacunga
** Tabla 3.1.36. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Machala
** Tabla 3.1.37. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Espindola
** Tabla 3.1.38. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Zapotillo
** Tabla 3.1.39. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Santa Cruz
** Tabla 3.1.40. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración San Cristóbal
** Tabla 3.1.41. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Cuenca
** Tabla 3.1.42. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Chinchipe
** Tabla 3.1.43. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Lago Agrio
** Tabla 3.1.44. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Isabela
** Tabla 3.1.45. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Aguarico
** Tabla 3.1.45. Entrada, Salida y movimientos netos de ecuatorianos y extranjeros por sexo, según nacionalidad: Jefatura Migración Santa Rosa

foreach s of numlist 1701	901	707	401	1108	801	1308	2105	2403	805	501	701	1106	1113	2003	2001	101	1902	2101	2002	2202	712 {
preserve
gen _t1=1 if tip_movi==1
gen _t2=1 if tip_movi==2
forvalues i = 1/3 {
gen _t1_`i'=1 if tip_movi==1 & sex_migr==`i'
gen _t2_`i'=1 if tip_movi==2 & sex_migr==`i'
}
collapse (sum) _t* if can_jefm==`s', by(nac_migr cont_nac subcont_nac)
gen sn = _t1-_t2
order cont_nac subcont_nac nac_migr _t1* _t2* sn
sort cont_nac subcont_nac nac_migr
restore
}
*========================================= FIN ================================*
