################################################################################
#TITULO DE LA SINTAXIS:                                                        #
#Principales resultados de indicadores del REBPE 2023                          #
#OPERACIÓN ESTADÍSTICA:                                                        #
#Registro Estadístico base de Población del Ecuador REBPE - 2023               #
#UNIDAD TÉCNICA RESPONSABLE:                                                   #
#Dirección de Registros Administrativos (DIRAD)                                #
#ENTIDAD EJECUTORA:                                                            #
#Instituto Nacional de Estadística y Censos (INEC)                             #
################################################################################
# Fecha de elaboración:        Septiembre  del 2025                            #
# Fecha última modificación:   Noviembre del 2025                              #
################################################################################
# Elaborado por: Giorgia Congacha                                              #			
# Dirección de Registros Administrativos (DIRAD)                               #
# Instituto Nacional de Estadística y Censos (INEC)                            #
# inec@inec.gob.ec                                                             #
################################################################################
#Revisado por:	Marco Viteri                                                   #
#                                                                              #
#Aprobado por:	Paúl Benavides                                                 #
#                                                                              #
#Dirección de Registros Administrativos (DIRAD)                                #
#Instituto Nacional de Estadística y Censos (INEC)                             #
#inec@inec.gob.ec                                                              #
################################################################################

# Limpiamos la Consola
rm(list = ls())

# Instalamos las librerías

# install.packages("data.table")
# install.packages("dplyr")
suppressPackageStartupMessages({
  library(data.table)
  library(dplyr)
})

#Lectura de la base de datos REBPE (Cambiar directorio de trabajo)
rebpe_2023 <- fread("R:/CGTPE/DIRAD/GPMRA/REBPE_2023/a_Preliminar/1_dat/int_rebpe_2023_pre_z.csv", encoding = "UTF-8")

#Funciones para automatizar la salida de porcentajes en cada uno de los indicadores 
pct_chr <- function(x, total) sprintf("%.2f%%", 100 * (x / total))
round0 <- function(x) if (is.double(x)) round(x) else x

###################*****CARACTERISTICAS PRINCIPALES *******#####################
#Características principales de la base de datos
#Dimensión 
dim(rebpe_2023)
#Estructura de la base 
str(rebpe_2023)

################################## ETIQUETAS  ##################################

# Sexo 
rebpe_2023$sexo <- factor(rebpe_2023$sexo, levels = c(1,2,3),
                          labels = c("Hombre", "Mujer", "Indefinido"))

# Nacionalidad
rebpe_2023$nacionalidad <- factor(rebpe_2023$nacionalidad, levels = c(0,1,99),
                                  labels = c("Extranjera","Ecuatoriana","No registra"))

# Estado Civil 
rebpe_2023$e_civil <- factor(rebpe_2023$e_civil, levels = c(1,2,3,4,5,9),
                             labels = c("Soltero/a","Casado/a","Divorciado/a","Viudo/a","Unión de hecho","No registra"))

# Grupos de edad 
rebpe_2023$grupo_edad <- factor(rebpe_2023$grupo_edad, levels = 1:21,
                                labels = c("0 a 4 años","5 a 9 años","10 a 14 años","15 a 19 años","20 a 24 años","25 a 29 años",
                                           "30 a 34 años","35 a 39 años","40 a 44 años","45 a 49 años","50 a 54 años","55 a 59 años",
                                           "60 a 64 años","65 a 69 años","70 a 74 años","75 a 79 años","80 a 84 años","85 a 89 años",
                                           "90 a 94 años","95 a 99 años","100 y más años"))

# Etapas de vida 
rebpe_2023$etaedad <- factor(rebpe_2023$etaedad, levels = 1:5,
                             labels = c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)","Jóvenes (18 a 29 años)",
                                        "Adultas/os (30 a 64 años)","Adultas/os mayores (65 y más años)"))

# Provincia residencia / nacimiento
rebpe_2023 <- rebpe_2023 %>%
  mutate(prov_res = recode_factor(prov_res,
                                  "01"="Azuay","02"="Bolívar","03"="Cañar","04"="Carchi","05"="Cotopaxi","06"="Chimborazo",
                                  "07"="El Oro","08"="Esmeraldas","09"="Guayas","10"="Imbabura","11"="Loja","12"="Los Ríos",
                                  "13"="Manabí","14"="Morona Santiago","15"="Napo","16"="Pastaza","17"="Pichincha","18"="Tungurahua",
                                  "19"="Zamora Chinchipe","20"="Galápagos","21"="Sucumbíos","22"="Orellana",
                                  "23"="Santo Domingo de los Tsáchilas","24"="Santa Elena","90"="Zona en Estudio","99"="No registra"),
         prov_nac = recode_factor(prov_nac,
                                  "01"="Azuay","02"="Bolívar","03"="Cañar","04"="Carchi","05"="Cotopaxi","06"="Chimborazo",
                                  "07"="El Oro","08"="Esmeraldas","09"="Guayas","10"="Imbabura","11"="Loja","12"="Los Ríos",
                                  "13"="Manabí","14"="Morona Santiago","15"="Napo","16"="Pastaza","17"="Pichincha","18"="Tungurahua",
                                  "19"="Zamora Chinchipe","20"="Galápagos","21"="Sucumbíos","22"="Orellana",
                                  "23"="Santo Domingo de los Tsáchilas","24"="Santa Elena","88"="Extranjero","99"="No registra"))

rebpe_2023 <- rebpe_2023 %>%
  mutate(
    es_madre = recode_factor(es_madre, "1"="Si","2"="No","3"="No aplica"),
    es_padre = recode_factor(es_padre, "1"="Si","2"="No","3"="No aplica"),
    orfandad = recode_factor(orfandad, "1"="Si","2"="No","3"= "No aplica","9"="No registra"),
    tiene_disc = recode_factor(tiene_disc, "1"="Si","2"="No"),
    tipo_disc  = recode_factor(tipo_disc,
                               "1"="Intelectual","2"="Física","3"="Visual","4"="Auditiva",
                               "5"="Psicosocial","6"="Lenguaje","7"="No aplica","9"="No registra")
  )


############################ CÁLCULO DE INDICADORES ############################
#--------------------------- PRINCIPALES RESULTADOS ----------------------------

# Población registrada en Ecuador 
Poblacion_nacional <- nrow(rebpe_2023)

# Edad mediana nacional
Edad_mediana_nacional <- rebpe_2023[, .(mediana = median(edad, na.rm = TRUE))]

# Población  registrada por sexo
Poblacion_sexo <- rebpe_2023[, .(total = .N), by = sexo][order(sexo)]
Poblacion_sexo[, porcentaje := pct_chr(total, sum(total))]

# Población  registrada por nacionalidad 
Poblacion_nacionalidad <- rebpe_2023[, .(total = .N), by = nacionalidad][order(nacionalidad)]
Poblacion_nacionalidad[, porcentaje := pct_chr(total, sum(total))]

# Población  registrada por estado civil
Poblacion_estado_civil <- rebpe_2023[, .(total = .N), by = e_civil][order(e_civil)]
Poblacion_estado_civil[, porcentaje := pct_chr(total, sum(total))]

# Población  registrada por grupos de edad 
Poblacion_grupos_edad <- rebpe_2023[, .(total = .N), by = grupo_edad][order(grupo_edad)]
Poblacion_grupos_edad[, porcentaje := pct_chr(total, sum(total))]

# Población  registrada por etapas de vida 
Poblacion_etapas_de_vida <- rebpe_2023[, .(total = .N), by = etaedad][order(etaedad)]
Poblacion_etapas_de_vida[, porcentaje := pct_chr(total, sum(total))]

# Población  registrada por provincia de residencia
Poblacion_prov_res <- rebpe_2023[, .(total = .N), by = prov_res][order(prov_res)]
Poblacion_prov_res[, porcentaje := pct_chr(total, sum(total))]

# Población  registrada por provincia de nacimiento
Poblacion_prov_nac <- rebpe_2023[, .(total = .N), by = prov_nac][order(prov_nac)]
Poblacion_prov_nac[, porcentaje := pct_chr(total, sum(total))]

# ################################ ORFANDAD ####################################
# Filtro de la base completa a las personas  registradas como huérfanas
huerfanos <- rebpe_2023[orfandad %in% c("Si")]

# Filtro a la población de niños/as de 0 a 11 años 
menores <- rebpe_2023[etaedad == "Niños/as (0 a 11 años)", .N]

# Filtro a la población adolescente de 12 a 17 años 
adolescentes <- rebpe_2023[etaedad == "Adolescentes (12 a 17 años)", .N]
#----------------------------------INDICADORES----------------------------------
# 1 Porcentaje de niños/as  registrados como huérfanos 
porcentaje_ninos_huerfanos <- huerfanos[etaedad == "Niños/as (0 a 11 años)",
                         .(total = .N)][, porcentaje := pct_chr(total, menores)]

# 2.Porcentaje de adolescentes  registrados como huérfanos
porcentaje_adolescentes_huerfanos <- huerfanos[etaedad == "Adolescentes (12 a 17 años)",
                         .(total = .N)][, porcentaje := pct_chr(total, adolescentes)]
#-----------------------------DESAGREGACIÓN POR INDICADOR----------------------- 
#------------------------------------NIÑOS/AS-----------------------------------
# Niños/as  registrados en orfandad por sexo 
ind_ninos_huerfanos_sexo<-rebpe_2023[
  etaedad=="Niños/as (0 a 11 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=sexo                                
][
  , porcentaje := pct_chr(numerador,denominador)              
]
setorder(ind_ninos_huerfanos_sexo,sexo)

# Niños/as  registrados en orfandad por provincia de residencia 
ind_ninos_huerfanos_prov_res<-rebpe_2023[
  etaedad=="Niños/as (0 a 11 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=prov_res                                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_ninos_huerfanos_prov_res,prov_res)

# Niños/as  registrados en orfandad por etapas de vida 
ind_ninos_huerfanos_etaedad<-rebpe_2023[
  etaedad=="Niños/as (0 a 11 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=etaedad                                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_ninos_huerfanos_etaedad,etaedad)

# Niños/as registrados en orfandad por nacionalidad 
ind_ninos_huerfanos_nacionalidad<-rebpe_2023[
  etaedad=="Niños/as (0 a 11 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=nacionalidad                               
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_ninos_huerfanos_nacionalidad,nacionalidad)

# Niños/as  registrados en orfandad por discapacidad 
ind_ninos_huerfanos_tiene_disc <-rebpe_2023[
  etaedad=="Niños/as (0 a 11 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tiene_disc                               
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_ninos_huerfanos_tiene_disc,tiene_disc )
# Niños/as  registrados en orfandad por tipo de discapacidad 
ind_ninos_huerfanos_tipo_disc <-rebpe_2023[
  etaedad=="Niños/as (0 a 11 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tipo_disc                               
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_ninos_huerfanos_tipo_disc,tipo_disc)
#--------------------------------ADOLESCENTES-----------------------------------
# Adolescentes registrados en orfandad por sexo 
ind_adolescentes_huerfanos_sexo <-rebpe_2023[
  etaedad=="Adolescentes (12 a 17 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=sexo                              
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_adolescentes_huerfanos_sexo,sexo)
# Adolescentes  registrados en orfandad por provincia de residencia 
ind_adolescentes_huerfanos_prov_res <-rebpe_2023[
  etaedad=="Adolescentes (12 a 17 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=prov_res                          
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_adolescentes_huerfanos_prov_res,prov_res)

# Adolescentes  registrados en orfandad por etapas de vida 
ind_adolescentes_huerfanos_etaedad <-rebpe_2023[
  etaedad=="Adolescentes (12 a 17 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=etaedad                          
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_adolescentes_huerfanos_etaedad ,etaedad)

# Adolescentes registrados en orfandad por nacionalidad 
ind_adolescentes_huerfanos_nacionalidad <-rebpe_2023[
  etaedad=="Adolescentes (12 a 17 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=nacionalidad                       
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_adolescentes_huerfanos_nacionalidad ,nacionalidad)
# Adolescentes  registrados en orfandad por discapacidad 
ind_adolescentes_huerfanos_tiene_disc <-rebpe_2023[
  etaedad=="Adolescentes (12 a 17 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tiene_disc                       
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_adolescentes_huerfanos_tiene_disc ,tiene_disc)

# Adolescentes  registrados en orfandad por tipo de discapacidad 
ind_adolescentes_huerfanos_tipo_disc <-rebpe_2023[
  etaedad=="Adolescentes (12 a 17 años)",                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tipo_disc                       
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(ind_adolescentes_huerfanos_tipo_disc ,tipo_disc)
#--------------------------------AMBOS------------------------------------------
# NNA  registrados en orfandad por sexo 
NNA_huerfanos_sexo <-rebpe_2023[
  etaedad %in% c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)"),                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=sexo                      
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(NNA_huerfanos_sexo ,sexo)
# NNA  registrados en orfandad por provincia de residencia 
NNA_huerfanos_prov_res <-rebpe_2023[
  etaedad %in% c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)"),                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=prov_res                      
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(NNA_huerfanos_prov_res ,prov_res)
# NNA  registrados en orfandad por etapas de vida 
NNA_huerfanos_etaedad <-rebpe_2023[
  etaedad %in% c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)"),                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=etaedad                    
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(NNA_huerfanos_etaedad ,etaedad)

# NNA  registrados en orfandad por nacionalidad 
NNA_huerfanos_nacionalidad <-rebpe_2023[
  etaedad %in% c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)"),                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=nacionalidad                     
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(NNA_huerfanos_nacionalidad ,nacionalidad)

# NNA  registrados en orfandad por discapacidad 
NNA_huerfanos_tiene_disc <-rebpe_2023[
  etaedad %in% c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)"),                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tiene_disc                      
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(NNA_huerfanos_tiene_disc ,tiene_disc)

# NNA  registrados en orfandad por tipo de discapacidad 
NNA_huerfanos_tipo_disc <-rebpe_2023[
  etaedad %in% c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)"),                        
  .(
    numerador=sum(orfandad == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tipo_disc                      
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(NNA_huerfanos_tipo_disc ,tipo_disc)

# ################################## VIUDEZ ####################################
# Filtro a la población que en estado civil registra viudez
viudos <- rebpe_2023[e_civil == "Viudo/a"]

#Población mayor a 18 años 
m_edad <- rebpe_2023[edad >=18, .N]
#----------------------------------INDICADORES----------------------------------
# 1. Porcentaje de la población  registrada como viudo/a
porcentaje_poblacion_viuda <- viudos[, .(total = .N)][, porcentaje := pct_chr(total, m_edad)]

# 2. Edad promedio al enviudar 
Edad_promedio_enviudar <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2))]

# 3. Promedio de años vividos en viudez 
Promedio_anos_viudez <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2))]

#-----------------------------DESAGREGACION POR INDICADOR-----------------------
# Población  registrada como viudo/a por sexo 
Poblacion_viuda_sexo <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=sexo                      
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_sexo,sexo)

# Población  registrada como viudo/a por provincia de residencia 
Poblacion_viuda_prov_res <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=prov_res                    
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_prov_res,prov_res)
# Población  registrada como viudo/a por etapas de vida 
Poblacion_viuda_etaedad <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=etaedad                    
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_etaedad,etaedad)

# Población  registrada como viudo/a por grupos de edad 
Poblacion_viuda_grupo_edad <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=grupo_edad                   
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_grupo_edad,grupo_edad)

# Población  registrada como viudo/a por nacionalidad 
Poblacion_viuda_nacionalidad <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=nacionalidad                   
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_nacionalidad,nacionalidad)

# Población  registrada como viudo/a por discapacidad
Poblacion_viuda_tiene_disc <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=tiene_disc                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_tiene_disc,tiene_disc)

# Población  registrada como viudo/a por tipo de discapacidad
Poblacion_viuda_tipo_disc <-rebpe_2023[
  edad >=18,                        
  .(
    numerador=sum(e_civil == "Viudo/a", na.rm=T),         
    denominador=.N                                           
  ),
  by=tipo_disc                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_viuda_tipo_disc,tipo_disc)
#-------------------------------------------------------------------------------
# Edad promedio al enviudar por provincia de residencia  
Edad_promedio_viudez_prov_res <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2)),by = prov_res][order(prov_res)]

# Edad promedio al enviudar por sexo 
Edad_promedio_viudez_sexo <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2)), by = sexo][order(sexo)]

# Edad promedio al enviudar por discapacidad 
Edad_promedio_viudez_discapacidad <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2)), by = tiene_disc][order(tiene_disc)]

# Edad promedio al enviudar por tipo de discapacidad  
Edad_promedio_viudez_tipo_discapacidad <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2)), by = tipo_disc][order(tipo_disc)]

# Edad promedio al enviudar por nacionalidad 
Edad_promedio_viudez_nacionalidad <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2)), by = nacionalidad][order(nacionalidad)]  

# Edad promedio al enviudar por etapas de vida
Edad_promedio_viudez_etapas_de_vida <- viudos[, .(prom_edad = round(mean(edad_viud, na.rm = TRUE),2)), by = etaedad][order(etaedad)]  
#-------------------------------------------------------------------------------
# Promedio de años vividos en viudez por provincia de residencia
Promedio_anos_viudez_prov_res <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2)),by = prov_res][order(prov_res)]

# Promedio de años vividos en viudez por sexo
Promedio_anos_viudez_sexo <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2)),by = sexo][order(sexo)]

# Promedio de años vividos en viudez por discapacidad
Promedio_anos_viudez_discapacidad <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2)), by = tiene_disc][order(tiene_disc)]

# Promedio de años vividos en viudez por tipo de discapacidad
Promedio_anos_viudez_tipo_discapacidad <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2)), by = tipo_disc][order(tipo_disc)]

# Promedio de años vividos en viudez por nacionalidad
Promedio_anos_viudez_nacionalidad <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2)), by = nacionalidad][order(nacionalidad)]

# Promedio de años vividos en viudez por etapas de vida
Promedio_anos_viudez_etapas_de_vida <- viudos[, .(anios_viudo = round(mean(anios_viud, na.rm = TRUE),2)), by = etaedad][order(etaedad)]  

# ################################## PARENTALIDAD ##############################
################################# MADRES #######################################
# Filtro de la base a toda la población  registrada con filiación materna 
MADRES <- rebpe_2023[es_madre == "Si"]

# Filtro a todas las mujeres a partir de los 10 años de la base completa 
MUJERES <- rebpe_2023[sexo == "Mujer" & edad >= 10, .N]

#-----------------------------------INDICADOR-----------------------------------
# 1. Porcentaje de la población  registrada con filiación materna 
porcentaje_poblacion_filiacion_materna <- MADRES[, .(n_madres = .N)][, porcentaje := pct_chr(n_madres, MUJERES)]

#-----------------------------DESAGREGACIÓN POR INDICADOR-----------------------
# Población  registrada con filiación materna por provincia de residencia 
Poblacion_filiacion_materna_prov_res<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=prov_res                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_prov_res,prov_res)
# Población  registrada con filiación materna por nacionalidad 
Poblacion_filiacion_materna_nacionalidad<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=nacionalidad                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_nacionalidad,nacionalidad)

# Población  registrada con filiación materna por estado civil
Poblacion_filiacion_materna_estado_civil<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=e_civil                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_estado_civil,e_civil)

# Población  registrada con filiación materna por grupos de edad 
Poblacion_filiacion_materna_grupo_edad<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=grupo_edad                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_grupo_edad,grupo_edad)

# Población  registrada con filiación materna por etapas de vida 
Poblacion_filiacion_materna_etaedad<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=etaedad               
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_etaedad,etaedad)

# Población  registrada con filiación materna por discapacidad
Poblacion_filiacion_materna_tiene_disc<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tiene_disc                
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_tiene_disc,tiene_disc)

# Población  registrada con filiación materna por tipo de discapacidad
Poblacion_filiacion_materna_tipo_disc<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_madre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tipo_disc                
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_materna_tipo_disc,tipo_disc)

################################ PADRES #######################################
# Filtro a la población  registrada con filiación paterna 
PADRE <- rebpe_2023[es_padre == "Si"]

# Filtro a todos los hombres a partir de los 10 años de la base completa 
HOMBRES <- rebpe_2023[sexo == "Hombre" & edad >= 10, .N]

#----------------------------------- INDICADOR ---------------------------------
# 2. Porcentaje de la población  registrada con filiación paterna 
porcentaje_poblacion_filiacion_paterna <- PADRE[, .(pob_padres = .N)][, porcentajes := pct_chr(pob_padres, HOMBRES)]

#-----------------------------DESAGREGACIÓN POR INDICADOR-----------------------
# Población  registrada con filiación paterna por provincia de residencia 
Poblacion_filiacion_paterna_prov_res<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=prov_res                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_prov_res,prov_res)
# Población  registrada con filiación paterna por nacionalidad 
Poblacion_filiacion_paterna_nacionalidad<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=nacionalidad                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_nacionalidad,nacionalidad)

# Población  registrada con filiación paterna por estado civil 
Poblacion_filiacion_paterna_e_civil<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=e_civil                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_e_civil,e_civil)

# Población  registrada con filiación paterna por grupos de edad  
Poblacion_filiacion_paterna_grupo_edad<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=grupo_edad                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_grupo_edad,grupo_edad)

# Población  registrada con filiación paterna por etapas de vida 
Poblacion_filiacion_paterna_etaedad<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=etaedad                  
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_etaedad,etaedad)

# Población  registrada con filiación paterna por discapacidad
Poblacion_filiacion_paterna_tiene_disc<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tiene_disc                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_tiene_disc,tiene_disc)
# Población  registrada con filiación paterna por tipo de discapacidad 
Poblacion_filiacion_paterna_tipo_disc<-rebpe_2023[
  edad >=10,                        
  .(
    numerador=sum(es_padre == "Si", na.rm=T),         
    denominador=.N                                           
  ),
  by=tipo_disc                 
][
  , porcentaje := pct_chr(numerador,denominador)              
]

setorder(Poblacion_filiacion_paterna_tipo_disc,tipo_disc)

############################# POBLACIÓN ADULTA MAYOR ###########################
#----------------------------------- INDICADOR ---------------------------------
# Índice de envejecimiento
Índice_de_envejecimiento <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}]

#Filtro a la población adulta mayor
ADULTOS_MAYORES <- rebpe_2023[edad >= 65]
#-----------------------------DESAGREGACION POR INDICADOR-----------------------
# Índice de envejecimiento por provincia de residencia 
Índice_envejecimiento_prov_res <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}, by = prov_res[order(prov_res)]]

# Índice de envejecimiento por sexo
Índice_envejecimiento_sexo <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}, by = sexo[order(sexo)]]

# Índice de envejecimiento por estado civil 
Índice_envejecimiento_estado_civil <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}, by = e_civil[order(e_civil)]]

# Índice de envejecimiento por discapacidad
Índice_envejecimiento_discapacidad <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}, by = tiene_disc[order(tiene_disc)]]

# Índice de envejecimiento por tipo de discapacidad
Índice_envejecimiento_tipo_discapacidad <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}, by = tipo_disc[order(tipo_disc)]]

# Índice de envejecimiento por nacionalidad 
Índice_envejecimiento_nacionalidad <- rebpe_2023[, {
  mayores <- sum(edad >=65, na.rm = TRUE)
  ninos   <- sum(edad <=14, na.rm = TRUE)
  .(grupo_env = pct_chr(mayores, ninos))
}, by = nacionalidad[order(nacionalidad)]]