################################################################################
#TITULO DE LA SINTAXIS:                                                        #
#Sintaxis de tabulados del REBPE 2023                                          #
#OPERACIÓN ESTADÍSTICA:                                                        #
#Registro Estadístico base de Población del Ecuador REBPE - 2023               #
#UNIDAD TÉCNICA RESPONSABLE:                                                   #
#Dirección de Registros Administrativos (DIRAD)                                #
#ENTIDAD EJECUTORA:                                                            #
#Instituto Nacional de Estadística y Censos (INEC)                             #
################################################################################
# Fecha de elaboración:        Septiembre  del 2025                            #
# Fecha última modificación:   Noviembre del 2025                              #
################################################################################
# Elaborado por: Daniel Freire                                                 #			
# Dirección de Registros Administrativos (DIRAD)                               #
# Instituto Nacional de Estadística y Censos (INEC)                            #
# inec@inec.gob.ec                                                             #
################################################################################
#Revisado por:	Viviana Garzón, Marco Viteri, Angel Chiluisa                   #
#                                                                              #
#Aprobado por:	Paúl Benavides                                                 #
#                                                                              #
#Dirección de Registros Administrativos (DIRAD)                                #
#Instituto Nacional de Estadística y Censos (INEC)                             #
#inec@inec.gob.ec                                                              #
################################################################################

  
rm(list = ls())

#LIBRERIAS A UTILIZAR 
library(data.table)
library(dplyr)

#Lectura de la base de datos REBPE (Cambiar directorio de trabajo)
#==================== CARGA ====================
ruta_csv <- ".../rebpe_2023.csv"
rebpe_2023 <- fread(ruta_csv, encoding = "UTF-8")
setDT(rebpe_2023)

#==================== ETIQUETAS ================
  # Sexo 
  rebpe_2023$sexo <- factor(rebpe_2023$sexo, levels = c(1,2,3,9),
                            labels = c("Hombre", "Mujer", "Indefinido", "No registra"))
  
  # Nacionalidad
  rebpe_2023$nacionalidad <- factor(rebpe_2023$nacionalidad, levels = c(0,1,99),
                                    labels = c("Extranjera","Ecuatoriana","No registra"))
  
  # Estado Civil 
  rebpe_2023$e_civil <- factor(rebpe_2023$e_civil, levels = c(1,2,3,4,5,9),
                               labels = c("Soltero/a","Casado/a","Divorciado/a","Viudo/a","Unión de hecho","No registra"))
  
  # Grupos de edad 
  rebpe_2023$grupo_edad <- factor(rebpe_2023$grupo_edad, levels = 1:21,
                                  labels = c("0 a 4 años","5 a 9 años","10 a 14 años","15 a 19 años","20 a 24 años","25 a 29 años",
                                             "30 a 34 años","35 a 39 años","40 a 44 años","45 a 49 años","50 a 54 años","55 a 59 años",
                                             "60 a 64 años","65 a 69 años","70 a 74 años","75 a 79 años","80 a 84 años","85 a 89 años",
                                             "90 a 94 años","95 a 99 años","100 y más años"))
  
  # Etapas de vida 
  rebpe_2023$etaedad <- factor(rebpe_2023$etaedad, levels = 1:5,
                               labels = c("Niños/as (0 a 11 años)","Adolescentes (12 a 17 años)","Jóvenes (18 a 29 años)",
                                          "Adultas/os (30 a 64 años)","Adultas/os mayores (65 y más años)"))
  
  # Provincia residencia / nacimiento
  rebpe_2023 <- rebpe_2023 %>%
    mutate(prov_res = recode_factor(prov_res,
                                    "01"="Azuay","02"="Bolívar","03"="Cañar","04"="Carchi","05"="Cotopaxi","06"="Chimborazo",
                                    "07"="El Oro","08"="Esmeraldas","09"="Guayas","10"="Imbabura","11"="Loja","12"="Los Ríos",
                                    "13"="Manabí","14"="Morona Santiago","15"="Napo","16"="Pastaza","17"="Pichincha","18"="Tungurahua",
                                    "19"="Zamora Chinchipe","20"="Galápagos","21"="Sucumbíos","22"="Orellana",
                                    "23"="Santo Domingo de los Tsáchilas","24"="Santa Elena","90"="Zona en Estudio","99"="No registra"),
           prov_nac = recode_factor(prov_nac,
                                    "01"="Azuay","02"="Bolívar","03"="Cañar","04"="Carchi","05"="Cotopaxi","06"="Chimborazo",
                                    "07"="El Oro","08"="Esmeraldas","09"="Guayas","10"="Imbabura","11"="Loja","12"="Los Ríos",
                                    "13"="Manabí","14"="Morona Santiago","15"="Napo","16"="Pastaza","17"="Pichincha","18"="Tungurahua",
                                    "19"="Zamora Chinchipe","20"="Galápagos","21"="Sucumbíos","22"="Orellana",
                                    "23"="Santo Domingo de los Tsáchilas","24"="Santa Elena","88"="Extranjero","99"="No registra"))
  
  # Mes de nacimiento 
  meses <- c("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio",
             "Agosto","Septiembre","Octubre","Noviembre","Diciembre")
  rebpe_2023$mes_nac <- factor(rebpe_2023$mes_nac, levels = 1:12, labels = meses)
  
  rebpe_2023 <- rebpe_2023 %>%
    mutate(
      es_madre = recode_factor(es_madre, "1"="Si","2"="No","3"="No aplica"),
      es_padre = recode_factor(es_padre, "1"="Si","2"="No","3"="No aplica"),
      orfandad = recode_factor(orfandad, "1"="Si","2"="No","3"= "No aplica","9"="No registra"),
      tiene_disc = recode_factor(tiene_disc, "1"="Si","2"="No"),
      tipo_disc  = recode_factor(tipo_disc,
                                 "1"="Intelectual","2"="Física","3"="Visual","4"="Auditiva",
                                 "5"="Psicosocial","6"="Lenguaje","7"="No aplica","9"="No registra")
    )


#==================== SUBCONJUNTOS =============
orfandad <- rebpe_2023[edad <= 17 & orfandad == "Si"]
PAM      <- rebpe_2023[etaedad == "Adultas/os mayores (65 y más años)"]
discap   <- rebpe_2023[tiene_disc == "Si"]
mad      <- rebpe_2023[es_madre == "Si" & edad >= 10]
pad      <- rebpe_2023[es_padre == "Si" & edad >= 10]

#--------------------------- TABULADOS -----------------------------------------

## 1.x PRINCIPALES RESULTADOS

# 1.1 Población registrada en Ecuador, por estado civil y sexo, según etapas de vida

Tabla_1.1 <- rebpe_2023[, .N, by = .(etaedad, e_civil, sexo)]
Tabla_1.1[, comb := paste(e_civil, sexo, sep = "_")]
Tabla_1.1 <- dcast(Tabla_1.1, etaedad ~ comb, value.var = "N", fun.aggregate = sum, fill = 0)
Tabla_1.1_Total <- Tabla_1.1 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.1 <- rbind(Tabla_1.1_Total, Tabla_1.1)

# 1.2 Población registrada en Ecuador, por estado civil y sexo, según grupos de edad

Tabla_1.2 <- rebpe_2023[, .N, by = .(grupo_edad, e_civil, sexo)]
Tabla_1.2[, comb := paste(e_civil, sexo, sep = "_")]
Tabla_1.2 <- dcast(Tabla_1.2, grupo_edad ~ comb, value.var = "N", fun.aggregate = sum, fill = 0)
Tabla_1.2_Total <- Tabla_1.2 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.2 <- rbind(Tabla_1.2_Total, Tabla_1.2)

# 1.3 Población registrada en Ecuador, por nacionalidad y sexo, según etapas de vida

Tabla_1.3 <- rebpe_2023[, .N, by = .(etaedad, nacionalidad, sexo)]
Tabla_1.3[, comb := paste(nacionalidad, sexo, sep = "_")]
Tabla_1.3 <- dcast(Tabla_1.3, etaedad ~ comb, value.var = "N", fun.aggregate = sum, fill = 0)
Tabla_1.3_Total <- Tabla_1.3 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.3 <- rbind(Tabla_1.3_Total, Tabla_1.3)

# 1.4 Población registrada en Ecuador, por nacionalidad y sexo, según grupos de edad

Tabla_1.4 <- rebpe_2023[, .N, by = .(grupo_edad, nacionalidad, sexo)]
Tabla_1.4[, comb := paste(nacionalidad, sexo, sep = "_")]
Tabla_1.4 <- dcast(Tabla_1.4, grupo_edad ~ comb, value.var = "N", fun.aggregate = sum, fill = 0)
Tabla_1.4_Total <- Tabla_1.4 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.4 <- rbind(Tabla_1.4_Total, Tabla_1.4)

# 1.5 Población registrada en Ecuador, por nacionalidad y sexo, según provincia de residencia

Tabla_1.5 <- rebpe_2023[, .N, by = .(prov_res, nacionalidad, sexo)]
Tabla_1.5[, comb := paste(nacionalidad, sexo, sep = "_")]
Tabla_1.5 <- dcast(Tabla_1.5, prov_res ~ comb, value.var = "N", fun.aggregate = sum, fill = 0)
Tabla_1.5_Total <- Tabla_1.5 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.5 <- rbind(Tabla_1.5_Total, Tabla_1.5)

# 1.6 Población registrada en Ecuador, por sexo, según mes de nacimiento

Tabla_1.6 <- dcast(rebpe_2023, mes_nac ~ sexo, fun.aggregate = length, value.var = "mes_nac")
Tabla_1.6_Total <- Tabla_1.6 %>% summarise(mes_nac = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.6 <- rbind(Tabla_1.6_Total, Tabla_1.6)

# 1.7 Población registrada en Ecuador, por sexo, según provincia de nacimiento

Tabla_1.7 <- dcast(rebpe_2023, prov_nac ~ sexo, fun.aggregate = length, value.var = "prov_nac")
Tabla_1.7_Total <- Tabla_1.7 %>% summarise(prov_nac = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.7 <- rbind(Tabla_1.7_Total, Tabla_1.7)

# 1.8 Población registrada en Ecuador, por sexo, según provincia de residencia

Tabla_1.8 <- dcast(rebpe_2023, prov_res ~ sexo, fun.aggregate = length, value.var = "prov_res")
Tabla_1.8_Total <- Tabla_1.8 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_1.8 <- rbind(Tabla_1.8_Total, Tabla_1.8)

## 2.x NIÑAS, NIÑOS Y ADOLESCENTES HUERFANOS                                                                                                                                              

# 2.1 Población registrada en Ecuador de niñas, niños y adolescentes  con padre y/o madre fallecidos, por nacionalidad, según provincia de residencia

Tabla_2.1 <- dcast(orfandad, prov_res ~ nacionalidad, fun.aggregate = length, value.var = "prov_res")
Tabla_2.1_Total <- Tabla_2.1 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_2.1 <- rbind(Tabla_2.1_Total, Tabla_2.1)

# 2.2 Población registrada en Ecuador de niñas, niños y adolescentes  con padre y/o madre fallecidos, por sexo, según etapas de vida

Tabla_2.2 <- dcast(orfandad, etaedad ~ sexo, fun.aggregate = length, value.var = "etaedad")
Tabla_2.2_Total <- Tabla_2.2 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_2.2 <- rbind(Tabla_2.2_Total, Tabla_2.2)

# 2.3 Población registrada en Ecuador de niñas, niños y adolescentes  con padre y/o madre fallecidos, por sexo, según grupos de edad

orfandad[, grupo_edad_orf := cut(edad, breaks = c(-Inf,4,9,14,17),                                 labels = c("0-4 años","5-9 años","10-14 años","15-17 años"))]
Tabla_2.3 <- dcast(orfandad, grupo_edad_orf ~ sexo, fun.aggregate = length, value.var = "grupo_edad_orf")
Tabla_2.3_Total <- Tabla_2.3 %>% summarise(grupo_edad_orf = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_2.3 <- rbind(Tabla_2.3_Total, Tabla_2.3)

# 2.4 Población registrada en Ecuador de niñas, niños y adolescentes  con padre y/o madre fallecidos, por sexo, según provincia de residencia

Tabla_2.4 <- dcast(orfandad, prov_res ~ sexo, fun.aggregate = length, value.var = "prov_res")
Tabla_2.4_Total <- Tabla_2.4 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_2.4 <- rbind(Tabla_2.4_Total, Tabla_2.4)

## 3.x VIUDEZ

# 3.1 Población registrada en Ecuador viuda , por sexo, según etapas de vida

Tabla_3.1 <- dcast(rebpe_2023[e_civil == "Viudo/a" & !etaedad %in% c("Niños/as (0 a 11 años)", "Adolescentes (12 a 17 años)")],etaedad ~ sexo,
  fun.aggregate = length,value.var = "etaedad")
Tabla_3.1_Total <- Tabla_3.1 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_3.1 <- rbind(Tabla_3.1_Total, Tabla_3.1)

# 3.2 Población registrada en Ecuador viuda, por sexo, según grupos de edad

Tabla_3.2 <- dcast(rebpe_2023[e_civil == "Viudo/a" & !grupo_edad %in% c("0 a 4 años", "5 a 9 años", "10 a 14 años")],grupo_edad ~ sexo,
  fun.aggregate = length,value.var = "grupo_edad") 
Tabla_3.2_Total <- Tabla_3.2 %>%summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_3.2 <- rbind(Tabla_3.2_Total, Tabla_3.2)
Tabla_3.2[2,1] <- "18 a 19 años"

# 3.3 Población registrada en Ecuador viuda , por sexo, según provincia de residencia

Tabla_3.3 <- dcast(rebpe_2023[e_civil == "Viudo/a"], prov_res ~ sexo, fun.aggregate = length, value.var = "prov_res")
Tabla_3.3_Total <- Tabla_3.3 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_3.3 <- rbind(Tabla_3.3_Total, Tabla_3.3)

## 4.x PERSONAS QUE SON MADRES

# 4.1 Población registrada en Ecuador con filiación materna, por estado civil, según etapas de vida

Tabla_4.1 <- dcast(mad, etaedad ~ e_civil, fun.aggregate = length, value.var = "etaedad")
Tabla_4.1_Total <- Tabla_4.1 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_4.1 <- rbind(Tabla_4.1_Total, Tabla_4.1)

# 4.2 Población registrada en Ecuador con filiación materna, por estado civil, según grupos de edad

Tabla_4.2 <- dcast(mad, grupo_edad ~ e_civil, fun.aggregate = length, value.var = "grupo_edad")
Tabla_4.2_Total <- Tabla_4.2 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_4.2 <- rbind(Tabla_4.2_Total, Tabla_4.2)

# 4.3 Población registrada en Ecuador con filiación materna, por nacionalidad, según etapas de vida

Tabla_4.3 <- dcast(mad, etaedad ~ nacionalidad, fun.aggregate = length, value.var = "etaedad")
Tabla_4.3_Total <- Tabla_4.3 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_4.3 <- rbind(Tabla_4.3_Total, Tabla_4.3)

# 4.4 Población registrada en Ecuador con filiación materna, por etapas de vida, según provincia de residencia

Tabla_4.4 <- dcast(mad, prov_res ~ etaedad, fun.aggregate = length, value.var = "prov_res")
Tabla_4.4_Total <- Tabla_4.4 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_4.4 <- rbind(Tabla_4.4_Total, Tabla_4.4)

# 4.5 Población registrada en Ecuador con filiación materna, por nacionalidad, según grupos de edad

Tabla_4.5 <- dcast(mad, grupo_edad ~ nacionalidad, fun.aggregate = length, value.var = "grupo_edad")
Tabla_4.5_Total <- Tabla_4.5 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_4.5 <- rbind(Tabla_4.5_Total, Tabla_4.5)

## 5.x PERSONAS QUE SON PADRES

# 5.1 Población registrada en Ecuador con filiación paterna, por estado civil, según etapas de vida

Tabla_5.1 <- dcast(pad, etaedad ~ e_civil, fun.aggregate = length, value.var = "etaedad")
Tabla_5.1_Total <- Tabla_5.1 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_5.1 <- rbind(Tabla_5.1_Total, Tabla_5.1)

# 5.2 Población registrada en Ecuador con filiación paterna, por estado civil, según grupos de edad

Tabla_5.2 <- dcast(pad, grupo_edad ~ e_civil, fun.aggregate = length, value.var = "grupo_edad")
Tabla_5.2_Total <- Tabla_5.2 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_5.2 <- rbind(Tabla_5.2_Total, Tabla_5.2)

# 5.3 Población registrada en Ecuador con filiación paterna, por nacionalidad, según etapas de vida

Tabla_5.3 <- dcast(pad, etaedad ~ nacionalidad, fun.aggregate = length, value.var = "etaedad")
Tabla_5.3_Total <- Tabla_5.3 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_5.3 <- rbind(Tabla_5.3_Total, Tabla_5.3)

# 5.4 Población registrada en Ecuador con filiación paterna, por etapas de vida, según provincia de residencia

Tabla_5.4 <- dcast(pad, prov_res ~ etaedad, fun.aggregate = length, value.var = "prov_res")
Tabla_5.4_Total <- Tabla_5.4 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_5.4 <- rbind(Tabla_5.4_Total, Tabla_5.4)

# 5.5 Población registrada en Ecuador con filiación paterna, por nacionalidad, según grupos de edad

Tabla_5.5 <- dcast(pad, grupo_edad ~ nacionalidad, fun.aggregate = length, value.var = "grupo_edad")
Tabla_5.5_Total <- Tabla_5.5 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_5.5 <- rbind(Tabla_5.5_Total, Tabla_5.5)

## 6.x PERSONAS ADULTAS MAYORES

# 6.1 Población registrada en Ecuador adulta mayor , por nacionalidad, según provincia de residencia

Tabla_6.1 <- dcast(PAM, prov_res ~ nacionalidad, fun.aggregate = length, value.var = "prov_res")
Tabla_6.1_Total <- Tabla_6.1 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_6.1 <- rbind(Tabla_6.1_Total, Tabla_6.1)

# 6.2 Población registrada en Ecuador adulta mayor, por sexo, según estado civil

Tabla_6.2 <- dcast(PAM, e_civil ~ sexo, fun.aggregate = length, value.var = "e_civil")
Tabla_6.2_Total <- Tabla_6.2 %>% summarise(e_civil = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_6.2 <- rbind(Tabla_6.2_Total, Tabla_6.2)

# 6.3 Población registrada en Ecuador adulta mayor, por sexo, según grupos de edad

Tabla_6.3 <- dcast(PAM, grupo_edad ~ sexo, fun.aggregate = length, value.var = "grupo_edad")
Tabla_6.3_Total <- Tabla_6.3 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_6.3 <- rbind(Tabla_6.3_Total, Tabla_6.3)

# 6.4 Población registrada en Ecuador adulta mayor, por sexo, según provincia de residencia

Tabla_6.4 <- dcast(PAM, prov_res ~ sexo, fun.aggregate = length, value.var = "prov_res")
Tabla_6.4_Total <- Tabla_6.4 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_6.4 <- rbind(Tabla_6.4_Total, Tabla_6.4)

## 7.x PERSONAS CON DISCAPACIDAD

# 7.1 Población registrada en Ecuador con discapacidad, por sexo, según estado civil

Tabla_7.1 <- dcast(discap, e_civil ~ sexo, fun.aggregate = length, value.var = "e_civil")
Tabla_7.1_Total <- Tabla_7.1 %>% summarise(e_civil = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.1 <- rbind(Tabla_7.1_Total, Tabla_7.1)

# 7.2 Población registrada en Ecuador con discapacidad, por sexo, según etapas de vida

Tabla_7.2 <- dcast(discap, etaedad ~ sexo, fun.aggregate = length, value.var = "etaedad")
Tabla_7.2_Total <- Tabla_7.2 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.2 <- rbind(Tabla_7.2_Total, Tabla_7.2)

# 7.3 Población registrada en Ecuador con discapacidad, por sexo, según grupos de edad

Tabla_7.3 <- dcast(discap, grupo_edad ~ sexo, fun.aggregate = length, value.var = "grupo_edad")
Tabla_7.3_Total <- Tabla_7.3 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.3 <- rbind(Tabla_7.3_Total, Tabla_7.3)

# 7.4 Población registrada en Ecuador con discapacidad, por sexo, según provincia de residencia

Tabla_7.4 <- dcast(discap, prov_res ~ sexo, fun.aggregate = length, value.var = "prov_res")
Tabla_7.4_Total <- Tabla_7.4 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.4 <- rbind(Tabla_7.4_Total, Tabla_7.4)

# 7.5 Población registrada en Ecuador con discapacidad, por sexo, según tipo de discapacidad

Tabla_7.5 <- dcast(discap, tipo_disc ~ sexo, fun.aggregate = length, value.var = "tipo_disc")
Tabla_7.5_Total <- Tabla_7.5 %>% summarise(tipo_disc = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.5 <- rbind(Tabla_7.5_Total, Tabla_7.5)

# 7.6 Población registrada en Ecuador con discapacidad, por tipo de discapacidad, según estado civil 

Tabla_7.6 <- dcast(discap, e_civil ~ tipo_disc, fun.aggregate = length, value.var = "e_civil")
Tabla_7.6_Total <- Tabla_7.6 %>% summarise(e_civil = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.6 <- rbind(Tabla_7.6_Total, Tabla_7.6)

# 7.7 Población registrada en Ecuador con discapacidad, por tipo de discapacidad, según etapas de vida

Tabla_7.7 <- dcast(discap, etaedad ~ tipo_disc, fun.aggregate = length, value.var = "etaedad")
Tabla_7.7_Total <- Tabla_7.7 %>% summarise(etaedad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.7 <- rbind(Tabla_7.7_Total, Tabla_7.7)

# 7.8 Población registrada en Ecuador con discapacidad, por tipo de discapacidad, según grupos de edad  

Tabla_7.8 <- dcast(discap, grupo_edad ~ tipo_disc, fun.aggregate = length, value.var = "grupo_edad")
Tabla_7.8_Total <- Tabla_7.8 %>% summarise(grupo_edad = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.8 <- rbind(Tabla_7.8_Total, Tabla_7.8)

# 7.9 Población registrada en Ecuador con discapacidad, por tipo de discapacidad, según provincia de residencia

Tabla_7.9 <- dcast(discap, prov_res ~ tipo_disc, fun.aggregate = length, value.var = "prov_res")
Tabla_7.9_Total <- Tabla_7.9 %>% summarise(prov_res = "Total", across(where(is.numeric), ~sum(.x, na.rm = TRUE)))
Tabla_7.9 <- rbind(Tabla_7.9_Total, Tabla_7.9)


